
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;


/**
 * Test Case (Steps) template step
 * 
 */
public class TRStep {

    /**
     * Step value
     * 
     */
    @SerializedName("content")
    @Expose
    private String content;
    /**
     * Step expected result
     * 
     */
    @SerializedName("expected")
    @Expose
    private String expected;
    /**
     * Step actual result
     * 
     */
    @SerializedName("actual")
    @Expose
    private String actual;
    /**
     * The ID of the test step status.
     * 
     */
    @SerializedName("status_id")
    @Expose
    private String statusId;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRStep() {
    }

    /**
     * 
     * @param actual
     * @param statusId
     * @param expected
     * @param content
     */
    public TRStep(String content, String expected, String actual, String statusId) {
        super();
        this.content = content;
        this.expected = expected;
        this.actual = actual;
        this.statusId = statusId;
    }

    /**
     * Step value
     * 
     */
    public String getContent() {
        return content;
    }

    /**
     * Step value
     * 
     */
    public void setContent(String content) {
        this.content = content;
    }

    public TRStep withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Step expected result
     * 
     */
    public String getExpected() {
        return expected;
    }

    /**
     * Step expected result
     * 
     */
    public void setExpected(String expected) {
        this.expected = expected;
    }

    public TRStep withExpected(String expected) {
        this.expected = expected;
        return this;
    }

    /**
     * Step actual result
     * 
     */
    public String getActual() {
        return actual;
    }

    /**
     * Step actual result
     * 
     */
    public void setActual(String actual) {
        this.actual = actual;
    }

    public TRStep withActual(String actual) {
        this.actual = actual;
        return this;
    }

    /**
     * The ID of the test step status.
     * 
     */
    public String getStatusId() {
        return statusId;
    }

    /**
     * The ID of the test step status.
     * 
     */
    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public TRStep withStatusId(String statusId) {
        this.statusId = statusId;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("content", content).append("expected", expected).append("actual", actual).append("statusId", statusId).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(actual).append(statusId).append(content).append(expected).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRStep) == false) {
            return false;
        }
        TRStep rhs = ((TRStep) other);
        return new EqualsBuilder().append(actual, rhs.actual).append(statusId, rhs.statusId).append(content, rhs.content).append(expected, rhs.expected).isEquals();
    }

}
