
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRSuite {

    /**
     * The description of the test suite
     * 
     */
    @SerializedName("description")
    @Expose
    private String description;
    /**
     * The unique ID of the test suite
     * 
     */
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * The date/time when the test suite was closed (as UNIX timestamp) (added with TestRail 4.0)
     * 
     */
    @SerializedName("completed_on")
    @Expose
    private Long completedOn;
    /**
     * The name of the test suite
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;
    /**
     * The ID of the project this test suite belongs to
     * 
     */
    @SerializedName("project_id")
    @Expose
    private Long projectId;
    /**
     * True if the test suite is a baseline test suite and false otherwise (added with TestRail 4.0)
     * 
     */
    @SerializedName("is_baseline")
    @Expose
    private Boolean isBaseline;
    /**
     * True if the test suite is marked as completed/archived and false otherwise (added with TestRail 4.0)
     * 
     */
    @SerializedName("is_completed")
    @Expose
    private Boolean isCompleted;
    /**
     * True if the test suite is a master test suite and false otherwise (added with TestRail 4.0)
     * 
     */
    @SerializedName("is_master")
    @Expose
    private Boolean isMaster;
    /**
     * The address/URL of the test suite in the user interface
     * 
     */
    @SerializedName("url")
    @Expose
    private String url;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRSuite() {
    }

    /**
     * 
     * @param completedOn
     * @param isMaster
     * @param name
     * @param description
     * @param isBaseline
     * @param id
     * @param projectId
     * @param url
     * @param isCompleted
     */
    public TRSuite(String description, Long id, Long completedOn, String name, Long projectId, Boolean isBaseline, Boolean isCompleted, Boolean isMaster, String url) {
        super();
        this.description = description;
        this.id = id;
        this.completedOn = completedOn;
        this.name = name;
        this.projectId = projectId;
        this.isBaseline = isBaseline;
        this.isCompleted = isCompleted;
        this.isMaster = isMaster;
        this.url = url;
    }

    /**
     * The description of the test suite
     * 
     */
    public String getDescription() {
        return description;
    }

    /**
     * The description of the test suite
     * 
     */
    public void setDescription(String description) {
        this.description = description;
    }

    public TRSuite withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * The unique ID of the test suite
     * 
     */
    public Long getId() {
        return id;
    }

    /**
     * The unique ID of the test suite
     * 
     */
    public void setId(Long id) {
        this.id = id;
    }

    public TRSuite withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * The date/time when the test suite was closed (as UNIX timestamp) (added with TestRail 4.0)
     * 
     */
    public Long getCompletedOn() {
        return completedOn;
    }

    /**
     * The date/time when the test suite was closed (as UNIX timestamp) (added with TestRail 4.0)
     * 
     */
    public void setCompletedOn(Long completedOn) {
        this.completedOn = completedOn;
    }

    public TRSuite withCompletedOn(Long completedOn) {
        this.completedOn = completedOn;
        return this;
    }

    /**
     * The name of the test suite
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The name of the test suite
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRSuite withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * The ID of the project this test suite belongs to
     * 
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * The ID of the project this test suite belongs to
     * 
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public TRSuite withProjectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    /**
     * True if the test suite is a baseline test suite and false otherwise (added with TestRail 4.0)
     * 
     */
    public Boolean getIsBaseline() {
        return isBaseline;
    }

    /**
     * True if the test suite is a baseline test suite and false otherwise (added with TestRail 4.0)
     * 
     */
    public void setIsBaseline(Boolean isBaseline) {
        this.isBaseline = isBaseline;
    }

    public TRSuite withIsBaseline(Boolean isBaseline) {
        this.isBaseline = isBaseline;
        return this;
    }

    /**
     * True if the test suite is marked as completed/archived and false otherwise (added with TestRail 4.0)
     * 
     */
    public Boolean getIsCompleted() {
        return isCompleted;
    }

    /**
     * True if the test suite is marked as completed/archived and false otherwise (added with TestRail 4.0)
     * 
     */
    public void setIsCompleted(Boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public TRSuite withIsCompleted(Boolean isCompleted) {
        this.isCompleted = isCompleted;
        return this;
    }

    /**
     * True if the test suite is a master test suite and false otherwise (added with TestRail 4.0)
     * 
     */
    public Boolean getIsMaster() {
        return isMaster;
    }

    /**
     * True if the test suite is a master test suite and false otherwise (added with TestRail 4.0)
     * 
     */
    public void setIsMaster(Boolean isMaster) {
        this.isMaster = isMaster;
    }

    public TRSuite withIsMaster(Boolean isMaster) {
        this.isMaster = isMaster;
        return this;
    }

    /**
     * The address/URL of the test suite in the user interface
     * 
     */
    public String getUrl() {
        return url;
    }

    /**
     * The address/URL of the test suite in the user interface
     * 
     */
    public void setUrl(String url) {
        this.url = url;
    }

    public TRSuite withUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("description", description).append("id", id).append("completedOn", completedOn).append("name", name).append("projectId", projectId).append("isBaseline", isBaseline).append("isCompleted", isCompleted).append("isMaster", isMaster).append("url", url).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(completedOn).append(isMaster).append(name).append(description).append(isBaseline).append(id).append(projectId).append(url).append(isCompleted).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRSuite) == false) {
            return false;
        }
        TRSuite rhs = ((TRSuite) other);
        return new EqualsBuilder().append(completedOn, rhs.completedOn).append(isMaster, rhs.isMaster).append(name, rhs.name).append(description, rhs.description).append(isBaseline, rhs.isBaseline).append(id, rhs.id).append(projectId, rhs.projectId).append(url, rhs.url).append(isCompleted, rhs.isCompleted).isEquals();
    }

}
