
package org.touchbit.testrail4j.gson.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRTest {

    /**
     * The ID of the user the test is assigned to
     * 
     */
    @SerializedName("assignedto_id")
    @Expose
    private Long assignedtoId;
    /**
     * The ID of the related test case
     * 
     */
    @SerializedName("case_id")
    @Expose
    private Long caseId;
    /**
     * The ID of the test run the test belongs to
     * 
     */
    @SerializedName("run_id")
    @Expose
    private Long runId;
    /**
     * The ID of the current status of the test, also see get_statuses
     * 
     */
    @SerializedName("status_id")
    @Expose
    private Long statusId;
    /**
     * The ID of the test template
     * 
     */
    @SerializedName("template_id")
    @Expose
    private Long templateId;
    /**
     * The estimate of the related test case, e.g. '30s' or '1m 45s'
     * 
     */
    @SerializedName("estimate")
    @Expose
    private String estimate;
    /**
     * The estimate forecast of the related test case, e.g. '30s' or '1m 45s'
     * 
     */
    @SerializedName("estimate_forecast")
    @Expose
    private String estimateForecast;
    /**
     * The unique ID of the test
     * 
     */
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * The ID of the milestone that is linked to the test case
     * 
     */
    @SerializedName("milestone_id")
    @Expose
    private Long milestoneId;
    /**
     * The ID of the priority that is linked to the test case
     * 
     */
    @SerializedName("priority_id")
    @Expose
    private Long priorityId;
    /**
     * A comma-separated list of references/requirements that are linked to the test case
     * 
     */
    @SerializedName("refs")
    @Expose
    private String refs;
    /**
     * The title of the related test case
     * 
     */
    @SerializedName("title")
    @Expose
    private String title;
    /**
     * The ID of the test case type that is linked to the test case
     * 
     */
    @SerializedName("type_id")
    @Expose
    private Long typeId;
    /**
     * Test Case (Text) template steps
     * 
     */
    @SerializedName("custom_steps")
    @Expose
    private String customSteps;
    /**
     * Test Case (Text) template expected result
     * 
     */
    @SerializedName("custom_expected")
    @Expose
    private String customExpected;
    /**
     * Test Case (Text) template preconditions
     * 
     */
    @SerializedName("custom_preconds")
    @Expose
    private String customPreconds;
    /**
     * Exploratory Session template mission
     * 
     */
    @SerializedName("custom_mission")
    @Expose
    private String customMission;
    /**
     * Exploratory Session template goals
     * 
     */
    @SerializedName("custom_goals")
    @Expose
    private String customGoals;
    /**
     * Automation Type. Default values: 0 - None, 1 - Ranorex
     * 
     */
    @SerializedName("custom_automation_type")
    @Expose
    private Long customAutomationType;
    /**
     * Test Case (Steps) template steps
     * 
     */
    @SerializedName("custom_steps_separated")
    @Expose
    private List<TRStep> customStepsSeparated = new ArrayList<TRStep>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRTest() {
    }

    /**
     * 
     * @param customExpected
     * @param customAutomationType
     * @param milestoneId
     * @param customPreconds
     * @param templateId
     * @param title
     * @param customStepsSeparated
     * @param priorityId
     * @param statusId
     * @param refs
     * @param customSteps
     * @param assignedtoId
     * @param caseId
     * @param customGoals
     * @param estimate
     * @param customMission
     * @param typeId
     * @param runId
     * @param estimateForecast
     * @param id
     */
    public TRTest(Long assignedtoId, Long caseId, Long runId, Long statusId, Long templateId, String estimate, String estimateForecast, Long id, Long milestoneId, Long priorityId, String refs, String title, Long typeId, String customSteps, String customExpected, String customPreconds, String customMission, String customGoals, Long customAutomationType, List<TRStep> customStepsSeparated) {
        super();
        this.assignedtoId = assignedtoId;
        this.caseId = caseId;
        this.runId = runId;
        this.statusId = statusId;
        this.templateId = templateId;
        this.estimate = estimate;
        this.estimateForecast = estimateForecast;
        this.id = id;
        this.milestoneId = milestoneId;
        this.priorityId = priorityId;
        this.refs = refs;
        this.title = title;
        this.typeId = typeId;
        this.customSteps = customSteps;
        this.customExpected = customExpected;
        this.customPreconds = customPreconds;
        this.customMission = customMission;
        this.customGoals = customGoals;
        this.customAutomationType = customAutomationType;
        this.customStepsSeparated = customStepsSeparated;
    }

    /**
     * The ID of the user the test is assigned to
     * 
     */
    public Long getAssignedtoId() {
        return assignedtoId;
    }

    /**
     * The ID of the user the test is assigned to
     * 
     */
    public void setAssignedtoId(Long assignedtoId) {
        this.assignedtoId = assignedtoId;
    }

    public TRTest withAssignedtoId(Long assignedtoId) {
        this.assignedtoId = assignedtoId;
        return this;
    }

    /**
     * The ID of the related test case
     * 
     */
    public Long getCaseId() {
        return caseId;
    }

    /**
     * The ID of the related test case
     * 
     */
    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }

    public TRTest withCaseId(Long caseId) {
        this.caseId = caseId;
        return this;
    }

    /**
     * The ID of the test run the test belongs to
     * 
     */
    public Long getRunId() {
        return runId;
    }

    /**
     * The ID of the test run the test belongs to
     * 
     */
    public void setRunId(Long runId) {
        this.runId = runId;
    }

    public TRTest withRunId(Long runId) {
        this.runId = runId;
        return this;
    }

    /**
     * The ID of the current status of the test, also see get_statuses
     * 
     */
    public Long getStatusId() {
        return statusId;
    }

    /**
     * The ID of the current status of the test, also see get_statuses
     * 
     */
    public void setStatusId(Long statusId) {
        this.statusId = statusId;
    }

    public TRTest withStatusId(Long statusId) {
        this.statusId = statusId;
        return this;
    }

    /**
     * The ID of the test template
     * 
     */
    public Long getTemplateId() {
        return templateId;
    }

    /**
     * The ID of the test template
     * 
     */
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public TRTest withTemplateId(Long templateId) {
        this.templateId = templateId;
        return this;
    }

    /**
     * The estimate of the related test case, e.g. '30s' or '1m 45s'
     * 
     */
    public String getEstimate() {
        return estimate;
    }

    /**
     * The estimate of the related test case, e.g. '30s' or '1m 45s'
     * 
     */
    public void setEstimate(String estimate) {
        this.estimate = estimate;
    }

    public TRTest withEstimate(String estimate) {
        this.estimate = estimate;
        return this;
    }

    /**
     * The estimate forecast of the related test case, e.g. '30s' or '1m 45s'
     * 
     */
    public String getEstimateForecast() {
        return estimateForecast;
    }

    /**
     * The estimate forecast of the related test case, e.g. '30s' or '1m 45s'
     * 
     */
    public void setEstimateForecast(String estimateForecast) {
        this.estimateForecast = estimateForecast;
    }

    public TRTest withEstimateForecast(String estimateForecast) {
        this.estimateForecast = estimateForecast;
        return this;
    }

    /**
     * The unique ID of the test
     * 
     */
    public Long getId() {
        return id;
    }

    /**
     * The unique ID of the test
     * 
     */
    public void setId(Long id) {
        this.id = id;
    }

    public TRTest withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * The ID of the milestone that is linked to the test case
     * 
     */
    public Long getMilestoneId() {
        return milestoneId;
    }

    /**
     * The ID of the milestone that is linked to the test case
     * 
     */
    public void setMilestoneId(Long milestoneId) {
        this.milestoneId = milestoneId;
    }

    public TRTest withMilestoneId(Long milestoneId) {
        this.milestoneId = milestoneId;
        return this;
    }

    /**
     * The ID of the priority that is linked to the test case
     * 
     */
    public Long getPriorityId() {
        return priorityId;
    }

    /**
     * The ID of the priority that is linked to the test case
     * 
     */
    public void setPriorityId(Long priorityId) {
        this.priorityId = priorityId;
    }

    public TRTest withPriorityId(Long priorityId) {
        this.priorityId = priorityId;
        return this;
    }

    /**
     * A comma-separated list of references/requirements that are linked to the test case
     * 
     */
    public String getRefs() {
        return refs;
    }

    /**
     * A comma-separated list of references/requirements that are linked to the test case
     * 
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    public TRTest withRefs(String refs) {
        this.refs = refs;
        return this;
    }

    /**
     * The title of the related test case
     * 
     */
    public String getTitle() {
        return title;
    }

    /**
     * The title of the related test case
     * 
     */
    public void setTitle(String title) {
        this.title = title;
    }

    public TRTest withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * The ID of the test case type that is linked to the test case
     * 
     */
    public Long getTypeId() {
        return typeId;
    }

    /**
     * The ID of the test case type that is linked to the test case
     * 
     */
    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    public TRTest withTypeId(Long typeId) {
        this.typeId = typeId;
        return this;
    }

    /**
     * Test Case (Text) template steps
     * 
     */
    public String getCustomSteps() {
        return customSteps;
    }

    /**
     * Test Case (Text) template steps
     * 
     */
    public void setCustomSteps(String customSteps) {
        this.customSteps = customSteps;
    }

    public TRTest withCustomSteps(String customSteps) {
        this.customSteps = customSteps;
        return this;
    }

    /**
     * Test Case (Text) template expected result
     * 
     */
    public String getCustomExpected() {
        return customExpected;
    }

    /**
     * Test Case (Text) template expected result
     * 
     */
    public void setCustomExpected(String customExpected) {
        this.customExpected = customExpected;
    }

    public TRTest withCustomExpected(String customExpected) {
        this.customExpected = customExpected;
        return this;
    }

    /**
     * Test Case (Text) template preconditions
     * 
     */
    public String getCustomPreconds() {
        return customPreconds;
    }

    /**
     * Test Case (Text) template preconditions
     * 
     */
    public void setCustomPreconds(String customPreconds) {
        this.customPreconds = customPreconds;
    }

    public TRTest withCustomPreconds(String customPreconds) {
        this.customPreconds = customPreconds;
        return this;
    }

    /**
     * Exploratory Session template mission
     * 
     */
    public String getCustomMission() {
        return customMission;
    }

    /**
     * Exploratory Session template mission
     * 
     */
    public void setCustomMission(String customMission) {
        this.customMission = customMission;
    }

    public TRTest withCustomMission(String customMission) {
        this.customMission = customMission;
        return this;
    }

    /**
     * Exploratory Session template goals
     * 
     */
    public String getCustomGoals() {
        return customGoals;
    }

    /**
     * Exploratory Session template goals
     * 
     */
    public void setCustomGoals(String customGoals) {
        this.customGoals = customGoals;
    }

    public TRTest withCustomGoals(String customGoals) {
        this.customGoals = customGoals;
        return this;
    }

    /**
     * Automation Type. Default values: 0 - None, 1 - Ranorex
     * 
     */
    public Long getCustomAutomationType() {
        return customAutomationType;
    }

    /**
     * Automation Type. Default values: 0 - None, 1 - Ranorex
     * 
     */
    public void setCustomAutomationType(Long customAutomationType) {
        this.customAutomationType = customAutomationType;
    }

    public TRTest withCustomAutomationType(Long customAutomationType) {
        this.customAutomationType = customAutomationType;
        return this;
    }

    /**
     * Test Case (Steps) template steps
     * 
     */
    public List<TRStep> getCustomStepsSeparated() {
        return customStepsSeparated;
    }

    /**
     * Test Case (Steps) template steps
     * 
     */
    public void setCustomStepsSeparated(List<TRStep> customStepsSeparated) {
        this.customStepsSeparated = customStepsSeparated;
    }

    public TRTest withCustomStepsSeparated(List<TRStep> customStepsSeparated) {
        this.customStepsSeparated = customStepsSeparated;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("assignedtoId", assignedtoId).append("caseId", caseId).append("runId", runId).append("statusId", statusId).append("templateId", templateId).append("estimate", estimate).append("estimateForecast", estimateForecast).append("id", id).append("milestoneId", milestoneId).append("priorityId", priorityId).append("refs", refs).append("title", title).append("typeId", typeId).append("customSteps", customSteps).append("customExpected", customExpected).append("customPreconds", customPreconds).append("customMission", customMission).append("customGoals", customGoals).append("customAutomationType", customAutomationType).append("customStepsSeparated", customStepsSeparated).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(customExpected).append(customAutomationType).append(milestoneId).append(customPreconds).append(templateId).append(title).append(customStepsSeparated).append(priorityId).append(statusId).append(refs).append(customSteps).append(assignedtoId).append(caseId).append(customGoals).append(estimate).append(customMission).append(typeId).append(runId).append(estimateForecast).append(id).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRTest) == false) {
            return false;
        }
        TRTest rhs = ((TRTest) other);
        return new EqualsBuilder().append(customExpected, rhs.customExpected).append(customAutomationType, rhs.customAutomationType).append(milestoneId, rhs.milestoneId).append(customPreconds, rhs.customPreconds).append(templateId, rhs.templateId).append(title, rhs.title).append(customStepsSeparated, rhs.customStepsSeparated).append(priorityId, rhs.priorityId).append(statusId, rhs.statusId).append(refs, rhs.refs).append(customSteps, rhs.customSteps).append(assignedtoId, rhs.assignedtoId).append(caseId, rhs.caseId).append(customGoals, rhs.customGoals).append(estimate, rhs.estimate).append(customMission, rhs.customMission).append(typeId, rhs.typeId).append(runId, rhs.runId).append(estimateForecast, rhs.estimateForecast).append(id, rhs.id).isEquals();
    }

}
