
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRUser {

    /**
     * The email address of the user as configured in TestRail
     * (Required)
     * 
     */
    @SerializedName("email")
    @Expose
    private String email;
    /**
     * The unique ID of the user
     * (Required)
     * 
     */
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * True if the user is active and false otherwise
     * (Required)
     * 
     */
    @SerializedName("is_active")
    @Expose
    private Boolean isActive;
    /**
     * The full name of the user
     * (Required)
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRUser() {
    }

    /**
     * 
     * @param name
     * @param id
     * @param isActive
     * @param email
     */
    public TRUser(String email, Long id, Boolean isActive, String name) {
        super();
        this.email = email;
        this.id = id;
        this.isActive = isActive;
        this.name = name;
    }

    /**
     * The email address of the user as configured in TestRail
     * (Required)
     * 
     */
    public String getEmail() {
        return email;
    }

    /**
     * The email address of the user as configured in TestRail
     * (Required)
     * 
     */
    public void setEmail(String email) {
        this.email = email;
    }

    public TRUser withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * The unique ID of the user
     * (Required)
     * 
     */
    public Long getId() {
        return id;
    }

    /**
     * The unique ID of the user
     * (Required)
     * 
     */
    public void setId(Long id) {
        this.id = id;
    }

    public TRUser withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * True if the user is active and false otherwise
     * (Required)
     * 
     */
    public Boolean getIsActive() {
        return isActive;
    }

    /**
     * True if the user is active and false otherwise
     * (Required)
     * 
     */
    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public TRUser withIsActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    /**
     * The full name of the user
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The full name of the user
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRUser withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("email", email).append("id", id).append("isActive", isActive).append("name", name).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).append(id).append(isActive).append(email).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRUser) == false) {
            return false;
        }
        TRUser rhs = ((TRUser) other);
        return new EqualsBuilder().append(name, rhs.name).append(id, rhs.id).append(isActive, rhs.isActive).append(email, rhs.email).isEquals();
    }

}
