/*
 * Decompiled with CFR 0.152.
 */
package natchez.honeycomb;

import cats.FlatMap;
import cats.Functor;
import cats.effect.ExitCase;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.effect.concurrent.Ref;
import cats.effect.concurrent.Ref$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import io.honeycomb.libhoney.Event;
import io.honeycomb.libhoney.HoneyClient;
import java.io.Serializable;
import java.time.Instant;
import java.util.NoSuchElementException;
import java.util.UUID;
import natchez.Kernel;
import natchez.TraceValue;
import natchez.honeycomb.HoneycombSpan;
import natchez.honeycomb.HoneycombSpan$Headers$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JFunction0;
import scala.runtime.function.JFunction1;
import scala.runtime.function.JFunction2;
import scala.runtime.function.JProcedure1;

public final class HoneycombSpan$
implements Serializable {
    public static final HoneycombSpan$Headers$ Headers;
    public static final HoneycombSpan$ MODULE$;

    private HoneycombSpan$() {
    }

    static {
        MODULE$ = new HoneycombSpan$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HoneycombSpan$.class);
    }

    public <F> HoneycombSpan<F> apply(HoneyClient client, String name, UUID spanUUID, Option<UUID> parentId, UUID traceUUID, Instant timestamp, Ref<F, Map<String, TraceValue>> fields, Sync<F> evidence$1) {
        return new HoneycombSpan<F>(client, name, spanUUID, parentId, traceUUID, timestamp, fields, evidence$1);
    }

    public <F> HoneycombSpan<F> unapply(HoneycombSpan<F> x$1) {
        return x$1;
    }

    public String toString() {
        return "HoneycombSpan";
    }

    private <F> Object uuid(Sync<F> evidence$2) {
        return Sync$.MODULE$.apply(evidence$2).delay(this::uuid$$anonfun$1);
    }

    private <F> Object now(Sync<F> evidence$3) {
        return Sync$.MODULE$.apply(evidence$3).delay(this::now$$anonfun$1);
    }

    public <F> Function2<HoneycombSpan<F>, ExitCase<Throwable>, Object> finish(Sync<F> evidence$4) {
        return (JFunction2 & Serializable)(span, exitCase) -> package.all$.MODULE$.toFlatMapOps(this.now(evidence$4), (FlatMap)evidence$4).flatMap((Function1)(JFunction1 & Serializable)n -> package.all$.MODULE$.toFlatMapOps(span.fields().get(), (FlatMap)evidence$4).flatMap((Function1)(JFunction1 & Serializable)fs -> package.all$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply(evidence$4).delay(() -> this.finish$$anonfun$4$$anonfun$3$$anonfun$3$$anonfun$3(span, exitCase, n, fs)), (FlatMap)evidence$4).flatMap((Function1)(JFunction1 & Serializable)e -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(evidence$4).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.finish$$anonfun$5$$anonfun$4$$anonfun$4$$anonfun$4$$anonfun$1(e))), (Functor)evidence$4).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
        }))));
    }

    public <F> Object child(HoneycombSpan<F> parent, String name, Sync<F> evidence$5) {
        return package.all$.MODULE$.toFlatMapOps(this.uuid(evidence$5), evidence$5).flatMap((Function1)(JFunction1 & Serializable)spanUUID -> package.all$.MODULE$.toFlatMapOps(this.now(evidence$5), (FlatMap)evidence$5).flatMap((Function1)(JFunction1 & Serializable)timestamp -> {
            Sync sync = Ref$.MODULE$.apply(evidence$5);
            return package.all$.MODULE$.toFunctorOps(Ref.ApplyBuilders$.MODULE$.of$extension(sync, (Object)Predef$.MODULE$.Map().empty()), (Functor)evidence$5).map((Function1)(JFunction1 & Serializable)fields -> this.apply(parent.client(), name, (UUID)spanUUID, (Option<UUID>)Some$.MODULE$.apply((Object)parent.spanUUID()), parent.traceUUID(), (Instant)timestamp, (Ref)fields, evidence$5));
        }));
    }

    public <F> Object root(HoneyClient client, String name, Sync<F> evidence$6) {
        return package.all$.MODULE$.toFlatMapOps(this.uuid(evidence$6), evidence$6).flatMap((Function1)(JFunction1 & Serializable)spanUUID -> package.all$.MODULE$.toFlatMapOps(this.uuid(evidence$6), (FlatMap)evidence$6).flatMap((Function1)(JFunction1 & Serializable)traceUUID -> package.all$.MODULE$.toFlatMapOps(this.now(evidence$6), (FlatMap)evidence$6).flatMap((Function1)(JFunction1 & Serializable)timestamp -> {
            Sync sync = Ref$.MODULE$.apply(evidence$6);
            return package.all$.MODULE$.toFunctorOps(Ref.ApplyBuilders$.MODULE$.of$extension(sync, (Object)Predef$.MODULE$.Map().empty()), (Functor)evidence$6).map((Function1)(JFunction1 & Serializable)fields -> this.apply(client, name, (UUID)spanUUID, (Option<UUID>)None$.MODULE$, (UUID)traceUUID, (Instant)timestamp, (Ref)fields, evidence$6));
        })));
    }

    public <F> Object fromKernel(HoneyClient client, String name, Kernel kernel, Sync<F> ev) {
        return package.all$.MODULE$.toFlatMapOps(ev.catchNonFatal(() -> this.fromKernel$$anonfun$1(kernel), (.less.colon.less)$less$colon$less$.MODULE$.refl()), ev).flatMap((Function1)(JFunction1 & Serializable)traceUUID -> package.all$.MODULE$.toFlatMapOps(ev.catchNonFatal(() -> this.fromKernel$$anonfun$3$$anonfun$1(kernel), (.less.colon.less)$less$colon$less$.MODULE$.refl()), (FlatMap)ev).flatMap((Function1)(JFunction1 & Serializable)parentId -> package.all$.MODULE$.toFlatMapOps(this.uuid(ev), (FlatMap)ev).flatMap((Function1)(JFunction1 & Serializable)spanUUID -> package.all$.MODULE$.toFlatMapOps(this.now(ev), (FlatMap)ev).flatMap((Function1)(JFunction1 & Serializable)timestamp -> {
            Sync sync = Ref$.MODULE$.apply(ev);
            return package.all$.MODULE$.toFunctorOps(Ref.ApplyBuilders$.MODULE$.of$extension(sync, (Object)Predef$.MODULE$.Map().empty()), (Functor)ev).map((Function1)(JFunction1 & Serializable)fields -> this.apply(client, name, (UUID)spanUUID, (Option<UUID>)Some$.MODULE$.apply(parentId), (UUID)traceUUID, (Instant)timestamp, (Ref)fields, ev));
        }))));
    }

    public <F> Object fromKernelOrElseRoot(HoneyClient client, String name, Kernel kernel, Sync<F> ev) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.fromKernel(client, name, kernel, ev), ev);
        return ApplicativeErrorOps$.MODULE$.recoverWith$extension(object, (PartialFunction)new Serializable(client, name, ev){
            private final HoneyClient client$1;
            private final String name$1;
            private final Sync ev$1;
            {
                this.client$1 = client$11;
                this.name$1 = name$14;
                this.ev$1 = ev$19;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchElementException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return throwable instanceof NoSuchElementException ? HoneycombSpan$.MODULE$.root(this.client$1, this.name$1, this.ev$1) : function1.apply((Object)x);
            }
        }, ev);
    }

    private final UUID uuid$$anonfun$1() {
        return UUID.randomUUID();
    }

    private final Instant now$$anonfun$1() {
        return Instant.now();
    }

    private final Event finish$$anonfun$4$$anonfun$3$$anonfun$3$$anonfun$3(HoneycombSpan span$3, ExitCase exitCase$3, Instant n$2, Map fs$1) {
        Event event;
        Event e = span$3.client().createEvent();
        e.setTimestamp(span$3.timestamp().toEpochMilli());
        fs$1.foreach((Function1)(JFunction1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            TraceValue v = (TraceValue)tuple2._2();
            return (Event)e.addField(k, v.value());
        });
        span$3.parentId().foreach((Function1)(JFunction1 & Serializable)_$7 -> (Event)e.addField("trace.parent_id", _$7));
        e.addField("name", (Object)span$3.name());
        e.addField("trace.span_id", (Object)span$3.spanUUID());
        e.addField("trace.trace_id", (Object)span$3.traceUUID());
        e.addField("duration_ms", (Object)BoxesRunTime.boxToLong((long)(n$2.toEpochMilli() - span$3.timestamp().toEpochMilli())));
        ExitCase exitCase = exitCase$3;
        if (ExitCase.Completed$.MODULE$.equals(exitCase)) {
            event = (Event)e.addField("exit.case", (Object)"completed");
        } else if (ExitCase.Canceled$.MODULE$.equals(exitCase)) {
            event = (Event)e.addField("exit.case", (Object)"canceled");
        } else if (exitCase instanceof ExitCase.Error) {
            Throwable throwable;
            ExitCase.Error error = ExitCase.Error$.MODULE$.unapply((ExitCase.Error)exitCase);
            Throwable ex = throwable = (Throwable)error._1();
            e.addField("exit.case", (Object)"error");
            e.addField("exit.error.class", (Object)ex.getClass().getName());
            event = (Event)e.addField("exit.error.message", (Object)ex.getMessage());
        } else {
            throw new MatchError((Object)exitCase);
        }
        return e;
    }

    private final void finish$$anonfun$5$$anonfun$4$$anonfun$4$$anonfun$4$$anonfun$1(Event e$3) {
        e$3.send();
    }

    private final UUID fromKernel$$anonfun$1(Kernel kernel$1) {
        return UUID.fromString((String)kernel$1.toHeaders().apply((Object)HoneycombSpan$Headers$.MODULE$.TraceId()));
    }

    private final UUID fromKernel$$anonfun$3$$anonfun$1(Kernel kernel$3) {
        return UUID.fromString((String)kernel$3.toHeaders().apply((Object)HoneycombSpan$Headers$.MODULE$.SpanId()));
    }
}

