/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.derby;

import javax.sql.DataSource;
import org.apache.derby.jdbc.ClientDataSource;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.NoExceptionsAreFatalSorter;
import org.tranql.connector.derby.attributes.Attributes;
import org.tranql.connector.derby.attributes.ParseException;
import org.tranql.connector.jdbc.AbstractLocalDataSourceMCF;

public class ClientLocalMCF
extends AbstractLocalDataSourceMCF {
    private final ClientDataSource ds;

    public ClientLocalMCF() {
        super((DataSource)new ClientDataSource(), (ExceptionSorter)new NoExceptionsAreFatalSorter(), false);
        this.ds = (ClientDataSource)this.dataSource;
    }

    public String getUserName() {
        return this.ds.getUser();
    }

    public void setUserName(String user) {
        this.ds.setUser(user);
    }

    public String getPassword() {
        return this.ds.getPassword();
    }

    public void setPassword(String password) {
        this.ds.setPassword(password);
    }

    public String getServerName() {
        return this.ds.getServerName();
    }

    public void setServerName(String serverName) {
        this.ds.setServerName(serverName);
    }

    public Integer getPortNumber() {
        return new Integer(this.ds.getPortNumber());
    }

    public void setPortNumber(Integer port) {
        this.ds.setPortNumber(port.intValue());
    }

    public String getDatabaseName() {
        return this.ds.getDatabaseName();
    }

    public void setDatabaseName(String name) {
        this.ds.setDatabaseName(name);
    }

    public Boolean getCreateDatabase() {
        Attributes attr = new Attributes();
        try {
            attr = new Attributes(this.ds.getConnectionAttributes());
        }
        catch (ParseException e) {
            return Boolean.FALSE;
        }
        String createDatabase = attr.getAttributeValue("create");
        if (createDatabase == null) {
            return Boolean.FALSE;
        }
        return Boolean.parseBoolean(createDatabase);
    }

    public void setCreateDatabase(Boolean create) {
        Attributes attr = new Attributes();
        try {
            attr = new Attributes(this.ds.getConnectionAttributes());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (create.booleanValue()) {
            attr.setAttributeValue("create", "true");
        } else {
            attr.remove("create");
        }
        this.ds.setConnectionAttributes(attr.toString());
    }

    public Boolean getRetrieveMessageText() {
        return this.ds.getRetrieveMessageText();
    }

    public void setRetrieveMessageText(Boolean b) {
        this.ds.setRetrieveMessageText(b.booleanValue());
    }
}

