/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.derby.attributes;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.tranql.connector.derby.attributes.ParseException;

public class Attributes {
    private Properties props = new Properties();

    public Attributes() {
    }

    public Attributes(String attr) throws ParseException {
        if (attr != null) {
            this.parseAttributes(attr);
        }
    }

    private void parseAttributes(String attr) throws ParseException {
        StringTokenizer st = new StringTokenizer(attr, ";");
        while (st.hasMoreElements()) {
            String singleAttr = st.nextToken();
            StringTokenizer kv = new StringTokenizer(singleAttr, "=");
            if (kv.countTokens() != 2) {
                throw new ParseException("Attribute of \"" + singleAttr + "\" is malformed.  Entire attribute string is \"" + attr + "\"");
            }
            this.props.setProperty(kv.nextToken(), kv.nextToken());
        }
    }

    public String toString() {
        Enumeration<Object> keys = this.props.keys();
        StringBuffer sb = new StringBuffer();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)this.props.get(key);
            sb.append(key + "=" + value);
            if (!keys.hasMoreElements()) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public String getAttributeValue(String key) {
        return this.props.getProperty(key);
    }

    public void setAttributeValue(String key, String value) {
        this.props.setProperty(key, value);
    }

    public void remove(String key) {
        this.props.remove(key);
    }
}

