/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.oracle;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.jdbc.AbstractLocalDataSourceMCF;
import org.tranql.connector.oracle.LocalMCF;
import org.tranql.connector.oracle.OracleRACExceptionSorter;

public class LocalRACMCF
extends AbstractLocalDataSourceMCF {
    private static final long serialVersionUID = 8672506697045238199L;
    private static final Log log = LogFactory.getLog((String)LocalMCF.class.getName());
    private final OracleDataSource ds;
    private String password;

    public LocalRACMCF() throws SQLException {
        super((DataSource)new OracleDataSource(), (ExceptionSorter)new OracleRACExceptionSorter(), true);
        this.ds = (OracleDataSource)this.dataSource;
        System.setProperty("oracle.ons.oraclehome", ".");
    }

    public String getDatabaseName() {
        return this.ds.getDatabaseName();
    }

    public String getServiceName() {
        return this.ds.getServiceName();
    }

    public void setDataSourceName(String dsname) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setDataSourceName(" + dsname + ")"));
        }
        this.ds.setDataSourceName(dsname);
    }

    public String getDataSourceName() {
        return this.ds.getDataSourceName();
    }

    public String getDescription() {
        return this.ds.getDescription();
    }

    public String getNetworkProtocol() {
        return this.ds.getNetworkProtocol();
    }

    public void setPassword(String pwd) {
        this.password = pwd;
        if (log.isDebugEnabled()) {
            log.debug((Object)"setPassword(????????)");
        }
        this.ds.setPassword(pwd);
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getPortNumber() {
        return new Integer(this.ds.getPortNumber());
    }

    public String getServerName() {
        return this.ds.getServerName();
    }

    public void setUserName(String user) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setUserName(" + user + ")"));
        }
        this.ds.setUser(user);
    }

    public String getUserName() {
        return this.ds.getUser();
    }

    public String getDriverType() {
        return this.ds.getDriverType();
    }

    public String getTNSEntryName() {
        return this.ds.getTNSEntryName();
    }

    public String getURL() {
        try {
            return this.ds.getURL();
        }
        catch (SQLException e) {
            return "<unknown location>";
        }
    }

    public void setURL(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setURL(" + s + ")"));
        }
        this.ds.setURL(s);
    }

    public Integer getMaxStatements() throws SQLException {
        return new Integer(this.ds.getMaxStatements());
    }

    public void setMaxStatements(Integer ms) throws SQLException {
        int i;
        int n = i = ms == null ? 0 : ms;
        if (log.isDebugEnabled()) {
            log.debug((Object)("setMaxStatements(" + i + ")"));
        }
        this.ds.setMaxStatements(i);
        this.ds.setImplicitCachingEnabled(i != 0);
    }

    public String getConnectionCacheName() throws SQLException {
        return this.ds.getConnectionCacheName();
    }

    public void setConnectionCacheName(String s) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setConnectionCacheName(" + s + ")"));
        }
        this.ds.setConnectionCachingEnabled(true);
        this.ds.setFastConnectionFailoverEnabled(true);
        this.ds.setConnectionCacheName(s);
    }

    public String getONSConfiguration() throws SQLException {
        return this.ds.getONSConfiguration();
    }

    public void setONSConfiguration(String s) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setONSConfiguration(" + s + ")"));
        }
        this.ds.setONSConfiguration(s);
    }

    public Properties getConnectionCacheProperties() throws SQLException {
        return this.ds.getConnectionCacheProperties();
    }

    public void setConnectionCacheProperties(String s) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setConnectionCacheProperties(" + s + ")"));
        }
        Properties props = new Properties();
        String[] args = s.trim().split("[,]");
        for (int i = 0; i < args.length; ++i) {
            String[] prop = args[i].trim().split("[ =]+");
            if (prop.length == 2) {
                props.setProperty(prop[0], prop[1]);
                continue;
            }
            log.error((Object)("setConnectionCacheProperties(" + s + ")"));
            log.error((Object)("Found invalid Oracle ConnectionCacheProperties(" + prop.toString() + ")"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting ConnectionCacheProperties=" + props.toString()));
        }
        this.ds.setConnectionCacheProperties(props);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LocalRACMCF) {
            try {
                OracleDataSource other = ((LocalRACMCF)((Object)obj)).ds;
                return LocalRACMCF.equals(this.ds.getURL(), other.getURL()) && LocalRACMCF.equals(this.ds.getConnectionCacheName(), other.getConnectionCacheName());
            }
            catch (SQLException e) {
                return false;
            }
        }
        return false;
    }

    private static boolean equals(String a, String b) {
        return a == b || a != null && a.equals(b);
    }

    public int hashCode() {
        try {
            return LocalRACMCF.hashCode(this.ds.getURL()) ^ LocalRACMCF.hashCode(this.ds.getConnectionCacheName());
        }
        catch (SQLException e) {
            return 0;
        }
    }

    private static int hashCode(String s) {
        return s == null ? 0 : s.hashCode();
    }

    public String toString() {
        return "LocalRACMCF[" + this.getURL() + "]";
    }
}

