/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.ext.aws.neptune.app;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.dropwizard.setup.Environment;
import java.util.concurrent.TimeUnit;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.trellisldp.agent.SimpleAgentService;
import org.trellisldp.api.AgentService;
import org.trellisldp.api.AuditService;
import org.trellisldp.api.CacheService;
import org.trellisldp.api.IOService;
import org.trellisldp.api.NamespaceService;
import org.trellisldp.api.RDFaWriterService;
import org.trellisldp.api.ResourceService;
import org.trellisldp.app.TrellisCache;
import org.trellisldp.ext.aws.AbstractAWSServiceBundler;
import org.trellisldp.ext.aws.neptune.app.AppConfiguration;
import org.trellisldp.ext.aws.neptune.app.RDFConnectionHealthCheck;
import org.trellisldp.io.JenaIOService;
import org.trellisldp.namespaces.NamespacesJsonContext;
import org.trellisldp.rdfa.HtmlSerializer;
import org.trellisldp.triplestore.TriplestoreResourceService;

public class TrellisServiceBundler
extends AbstractAWSServiceBundler {
    private final AuditService auditService;
    private final TriplestoreResourceService resourceService;
    private final AgentService agentService = new SimpleAgentService();
    private final IOService ioService;

    public TrellisServiceBundler(AppConfiguration config, Environment environment) {
        this.ioService = TrellisServiceBundler.buildIoService(config);
        this.resourceService = TrellisServiceBundler.buildResourceService(config, environment);
        this.auditService = this.resourceService;
    }

    public ResourceService getResourceService() {
        return this.resourceService;
    }

    public AuditService getAuditService() {
        return this.auditService;
    }

    public AgentService getAgentService() {
        return this.agentService;
    }

    public IOService getIOService() {
        return this.ioService;
    }

    private static TriplestoreResourceService buildResourceService(AppConfiguration config, Environment environment) {
        RDFConnection rdfConnection = RDFConnectionFactory.connect((String)config.getResources());
        environment.healthChecks().register("rdfconnection", (HealthCheck)new RDFConnectionHealthCheck(rdfConnection));
        return new TriplestoreResourceService(rdfConnection);
    }

    private static IOService buildIoService(AppConfiguration config) {
        long cacheSize = config.getJsonld().getCacheSize();
        long hours = config.getJsonld().getCacheExpireHours();
        Cache cache = CacheBuilder.newBuilder().maximumSize(cacheSize).expireAfterAccess(hours, TimeUnit.HOURS).build();
        TrellisCache profileCache = new TrellisCache(cache);
        NamespacesJsonContext namespaceService = new NamespacesJsonContext(config.getNamespaces());
        HtmlSerializer htmlSerializer = new HtmlSerializer((NamespaceService)namespaceService, config.getAssets().getTemplate(), config.getAssets().getCss(), config.getAssets().getJs(), config.getAssets().getIcon());
        return new JenaIOService((NamespaceService)namespaceService, (RDFaWriterService)htmlSerializer, (CacheService)profileCache, config.getJsonld().getContextWhitelist(), config.getJsonld().getContextDomainWhitelist());
    }
}

