/*
 * Copyright (c) 2021 Aaron Coburn and individual contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trellisldp.ext.cassandra;

import java.io.InputStream;

import org.apache.commons.io.input.CountingInputStream;

/**
 * An {@link InputStream} that counts the bytes read from it and does not propagate {@link #close()}.
 *
 */
public class NoopCloseCountingInputStream extends CountingInputStream {

    /**
     * @param in the {@link InputStream} to wrap
     */
    public NoopCloseCountingInputStream(final InputStream in) {
        super(in);
    }

    @Override
    public void close() { /* NO OP */ }
}
