/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trellisldp.api.Event;
import org.trellisldp.api.EventSerializationService;
import org.trellisldp.api.EventService;
import org.trellisldp.api.NoopEventSerializationService;

public class AmqpEventService
implements EventService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpEventService.class);
    public static final String CONFIG_AMQP_EXCHANGE_NAME = "trellis.amqp.exchange-name";
    public static final String CONFIG_AMQP_ROUTING_KEY = "trellis.amqp.routing-key";
    public static final String CONFIG_AMQP_MANDATORY = "trellis.amqp.mandatory";
    public static final String CONFIG_AMQP_IMMEDIATE = "trellis.amqp.immediate";
    public static final String CONFIG_AMQP_URI = "trellis.amqp.uri";
    private final EventSerializationService service;
    private final Channel channel;
    private final String exchangeName;
    private final String routingKey;
    private final boolean mandatory;
    private final boolean immediate;

    public AmqpEventService() {
        this.service = new NoopEventSerializationService();
        this.channel = null;
        this.exchangeName = null;
        this.routingKey = null;
        this.mandatory = false;
        this.immediate = false;
    }

    @Inject
    public AmqpEventService(EventSerializationService serializer, Channel channel) {
        this(serializer, channel, ConfigProvider.getConfig());
    }

    private AmqpEventService(EventSerializationService serializer, Channel channel, Config config) {
        this(serializer, channel, (String)config.getValue(CONFIG_AMQP_EXCHANGE_NAME, String.class), (String)config.getValue(CONFIG_AMQP_ROUTING_KEY, String.class), config.getOptionalValue(CONFIG_AMQP_MANDATORY, Boolean.class).orElse(Boolean.TRUE), config.getOptionalValue(CONFIG_AMQP_IMMEDIATE, Boolean.class).orElse(Boolean.FALSE));
    }

    public AmqpEventService(EventSerializationService serializer, Channel channel, String exchangeName, String routingKey) {
        this(serializer, channel, exchangeName, routingKey, true, false);
    }

    public AmqpEventService(EventSerializationService serializer, Channel channel, String exchangeName, String routingKey, boolean mandatory, boolean immediate) {
        this.service = Objects.requireNonNull(serializer, "Event serializer may not be null!");
        this.channel = Objects.requireNonNull(channel, "AMQP Channel may not be null!");
        this.exchangeName = Objects.requireNonNull(exchangeName, "AMQP exchange name may not be null!");
        this.routingKey = Objects.requireNonNull(routingKey, "AMQP routing key may not be null!");
        this.mandatory = mandatory;
        this.immediate = immediate;
    }

    public void emit(Event event) {
        Objects.requireNonNull(event, "Cannot emit a null event!");
        AMQP.BasicProperties props = new AMQP.BasicProperties().builder().contentType("application/ld+json").contentEncoding("UTF-8").build();
        try {
            this.channel.basicPublish(this.exchangeName, this.routingKey, this.mandatory, this.immediate, props, this.service.serialize(event).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            LOGGER.error("Error writing to broker: {}", (Object)ex.getMessage());
        }
    }
}

