/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.inject.Inject;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trellisldp.api.ActivityStreamService;
import org.trellisldp.api.Event;
import org.trellisldp.api.EventService;

public class AmqpPublisher
implements EventService {
    public static final String AMQP_EXCHANGE_NAME = "trellis.amqp.exchangename";
    public static final String AMQP_ROUTING_KEY = "trellis.amqp.routingkey";
    public static final String AMQP_MANDATORY = "trellis.amqp.mandatory";
    public static final String AMQP_IMMEDIATE = "trellis.amqp.immediate";
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpPublisher.class);
    private static ActivityStreamService service = ServiceLoader.load(ActivityStreamService.class).iterator().next();
    private final Channel channel;
    private final String exchangeName;
    private final String routingKey;
    private final Boolean mandatory;
    private final Boolean immediate;

    @Inject
    public AmqpPublisher(Channel channel) {
        this(channel, ConfigurationProvider.getConfiguration());
    }

    private AmqpPublisher(Channel channel, Configuration config) {
        this(channel, config.get(AMQP_EXCHANGE_NAME), config.get(AMQP_ROUTING_KEY), (Boolean)config.getOrDefault(AMQP_MANDATORY, Boolean.class, (Object)true), (Boolean)config.getOrDefault(AMQP_IMMEDIATE, Boolean.class, (Object)false));
    }

    public AmqpPublisher(Channel channel, String exchangeName, String routingKey) {
        this(channel, exchangeName, routingKey, null, null);
    }

    public AmqpPublisher(Channel channel, String exchangeName, String routingKey, Boolean mandatory, Boolean immediate) {
        Objects.requireNonNull(channel, "AMQP Channel may not be null!");
        Objects.requireNonNull(exchangeName, "AMQP exchange name may not be null!");
        Objects.requireNonNull(routingKey, "AMQP routing key may not be null!");
        this.channel = channel;
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
        this.mandatory = Optional.ofNullable(mandatory).orElse(true);
        this.immediate = Optional.ofNullable(immediate).orElse(false);
    }

    public void emit(Event event) {
        Objects.requireNonNull(event, "Cannot emit a null event!");
        AMQP.BasicProperties props = new AMQP.BasicProperties().builder().contentType("application/ld+json").contentEncoding("UTF-8").build();
        service.serialize(event).ifPresent(message -> {
            try {
                this.channel.basicPublish(this.exchangeName, this.routingKey, this.mandatory.booleanValue(), this.immediate.booleanValue(), props, message.getBytes());
            }
            catch (IOException ex) {
                LOGGER.error("Error writing to broker: {}", (Object)ex.getMessage());
            }
        });
    }
}

