/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.api;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;

public final class BinaryMetadata {
    private final IRI identifier;
    private final String mimeType;
    private final Map<String, List<String>> hints;

    private BinaryMetadata(IRI identifier, String mimeType, Map<String, List<String>> hints) {
        this.identifier = Objects.requireNonNull(identifier, "Identifier may not be null!");
        this.mimeType = mimeType;
        this.hints = Objects.requireNonNull(hints, "Hints may not be null!");
    }

    public IRI getIdentifier() {
        return this.identifier;
    }

    public Optional<String> getMimeType() {
        return Optional.ofNullable(this.mimeType);
    }

    public Map<String, List<String>> getHints() {
        return this.hints;
    }

    public static Builder builder(IRI identifier) {
        return new Builder(identifier);
    }

    public static final class Builder {
        private final IRI identifier;
        private String mimeType;
        private Map<String, List<String>> hints;

        private Builder(IRI identifier) {
            this.identifier = Objects.requireNonNull(identifier, "Identifier cannot be null!");
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder hints(Map<String, List<String>> hints) {
            this.hints = Objects.requireNonNull(hints, "Hints cannot be null!");
            return this;
        }

        public BinaryMetadata build() {
            return new BinaryMetadata(this.identifier, this.mimeType, this.hints == null ? Collections.emptyMap() : this.hints);
        }
    }
}

