/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.api;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.enterprise.context.ApplicationScoped;
import org.trellisldp.api.IdentifierService;

@ApplicationScoped
public class DefaultIdentifierService
implements IdentifierService {
    private final String defaultPrefix;

    public DefaultIdentifierService() {
        this("");
    }

    public DefaultIdentifierService(String prefix) {
        this.defaultPrefix = prefix;
    }

    @Override
    public Supplier<String> getSupplier(String prefix, int hierarchy, int length) {
        Objects.requireNonNull(prefix, "The Id prefix may not be null!");
        return () -> DefaultIdentifierService.getId(prefix, hierarchy, length);
    }

    @Override
    public Supplier<String> getSupplier(String prefix) {
        return this.getSupplier(prefix, 0, 0);
    }

    @Override
    public Supplier<String> getSupplier() {
        return this.getSupplier(this.defaultPrefix);
    }

    private static String getId(String prefix, int hierarchy, int length) {
        String id = UUID.randomUUID().toString();
        String nodash = id.replace("-", "");
        StringJoiner joiner = new StringJoiner("/");
        IntStream.rangeClosed(0, hierarchy - 1).forEach(x -> joiner.add(nodash.substring(x * length, (x + 1) * length)));
        joiner.add(id);
        return prefix + joiner;
    }
}

