/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.rdf.api.IRI;
import org.trellisldp.api.BinaryMetadata;
import org.trellisldp.api.Resource;

public final class Metadata {
    private final IRI identifier;
    private final IRI ixnModel;
    private final IRI container;
    private final IRI memberRelation;
    private final IRI membershipResource;
    private final IRI memberOfRelation;
    private final IRI insertedContentRelation;
    private final IRI agent;
    private final BinaryMetadata binary;
    private final Set<IRI> graphNames;
    private final String revision;
    private final Map<String, String> properties;

    private Metadata(IRI identifier, IRI ixnModel, IRI container, IRI membershipResource, IRI memberRelation, IRI memberOfRelation, IRI insertedContentRelation, IRI agent, BinaryMetadata binary, String revision, Set<IRI> graphNames, Map<String, String> properties) {
        this.identifier = Objects.requireNonNull(identifier, "Identifier cannot be null!");
        this.ixnModel = Objects.requireNonNull(ixnModel, "Interaction model cannot be null!");
        this.container = container;
        this.membershipResource = membershipResource;
        this.memberRelation = memberRelation;
        this.memberOfRelation = memberOfRelation;
        this.insertedContentRelation = insertedContentRelation;
        this.agent = agent;
        this.binary = binary;
        this.revision = revision;
        this.graphNames = graphNames;
        this.properties = properties;
    }

    public static Builder builder(IRI identifier) {
        return new Builder(identifier);
    }

    public static Builder builder(Resource r) {
        return Metadata.builder(r.getIdentifier()).interactionModel(r.getInteractionModel()).revision(r.getRevision()).metadataGraphNames(r.getMetadataGraphNames()).container(r.getContainer().orElse(null)).binary(r.getBinaryMetadata().orElse(null)).memberRelation(r.getMemberRelation().orElse(null)).membershipResource(r.getMembershipResource().orElse(null)).memberOfRelation(r.getMemberOfRelation().orElse(null)).insertedContentRelation(r.getInsertedContentRelation().orElse(null));
    }

    public IRI getIdentifier() {
        return this.identifier;
    }

    public IRI getInteractionModel() {
        return this.ixnModel;
    }

    public Optional<IRI> getContainer() {
        return Optional.ofNullable(this.container);
    }

    public Optional<IRI> getAgent() {
        return Optional.ofNullable(this.agent);
    }

    public Optional<IRI> getMembershipResource() {
        return Optional.ofNullable(this.membershipResource);
    }

    public Optional<IRI> getMemberRelation() {
        return Optional.ofNullable(this.memberRelation);
    }

    public Optional<IRI> getMemberOfRelation() {
        return Optional.ofNullable(this.memberOfRelation);
    }

    public Optional<IRI> getInsertedContentRelation() {
        return Optional.ofNullable(this.insertedContentRelation);
    }

    public Optional<BinaryMetadata> getBinary() {
        return Optional.ofNullable(this.binary);
    }

    public Set<IRI> getMetadataGraphNames() {
        return this.graphNames;
    }

    public Optional<String> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static final class Builder {
        private final IRI identifier;
        private IRI ixnModel;
        private IRI container;
        private IRI memberRelation;
        private IRI membershipResource;
        private IRI memberOfRelation;
        private IRI insertedContentRelation;
        private IRI agent;
        private BinaryMetadata binary;
        private String revision;
        private Set<IRI> graphNames = Collections.emptySet();
        private Map<String, String> properties = new HashMap<String, String>();

        private Builder(IRI identifier) {
            this.identifier = Objects.requireNonNull(identifier, "Identifier cannot be null!");
        }

        public Builder interactionModel(IRI ixnModel) {
            this.ixnModel = ixnModel;
            return this;
        }

        public Builder container(IRI container) {
            this.container = container;
            return this;
        }

        public Builder memberRelation(IRI memberRelation) {
            this.memberRelation = memberRelation;
            return this;
        }

        public Builder membershipResource(IRI membershipResource) {
            this.membershipResource = membershipResource;
            return this;
        }

        public Builder memberOfRelation(IRI memberOfRelation) {
            this.memberOfRelation = memberOfRelation;
            return this;
        }

        public Builder insertedContentRelation(IRI insertedContentRelation) {
            this.insertedContentRelation = insertedContentRelation;
            return this;
        }

        public Builder agent(IRI agent) {
            this.agent = agent;
            return this;
        }

        public Builder binary(BinaryMetadata binary) {
            this.binary = binary;
            return this;
        }

        public Builder metadataGraphNames(Set<IRI> graphNames) {
            this.graphNames = Objects.requireNonNull(graphNames, "Metadata graph names may not be null!");
            return this;
        }

        public Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public Builder property(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Metadata build() {
            return new Metadata(this.identifier, this.ixnModel, this.container, this.membershipResource, this.memberRelation, this.memberOfRelation, this.insertedContentRelation, this.agent, this.binary, this.revision, this.graphNames, Collections.unmodifiableMap(this.properties));
        }
    }
}

