/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.api;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.IRI;
import org.trellisldp.api.NoopImplementation;
import org.trellisldp.api.Notification;
import org.trellisldp.api.NotificationSerializationService;

@NoopImplementation
public class NoopNotificationSerializationService
implements NotificationSerializationService {
    private static final String AS_NAMESPACE = "https://www.w3.org/ns/activitystreams#";

    @Override
    public String serialize(Notification notification) {
        return "{\n  \"@context\": \"https://www.w3.org/ns/activitystreams\",\n  \"id\": \"" + notification.getIdentifier().getIRIString() + "\"" + this.getTypesAsJsonFragment(notification) + notification.getObject().map(obj -> ",\n  \"object\": \"" + obj.getIRIString() + "\"").orElse("") + "\n}";
    }

    private String getTypesAsJsonFragment(Notification notification) {
        List types = notification.getTypes().stream().map(IRI::getIRIString).map(type -> type.startsWith(AS_NAMESPACE) ? type.substring(AS_NAMESPACE.length()) : type).map(type -> "\"" + type + "\"").collect(Collectors.toList());
        if (types.isEmpty()) {
            return "";
        }
        if (types.size() == 1) {
            return ",\n  \"type\": " + (String)types.get(0);
        }
        return ",\n  \"type\": [" + String.join((CharSequence)",", types) + "]";
    }
}

