/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.api;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.trellisldp.api.BinaryMetadata;
import org.trellisldp.api.TrellisUtils;

public interface Resource {
    public IRI getIdentifier();

    public IRI getInteractionModel();

    public Instant getModified();

    default public String getRevision() {
        return this.getModified() + "::" + this.getIdentifier();
    }

    public Optional<IRI> getContainer();

    default public Optional<IRI> getMembershipResource() {
        return Optional.empty();
    }

    default public Optional<IRI> getMemberRelation() {
        return Optional.empty();
    }

    default public Optional<IRI> getMemberOfRelation() {
        return Optional.empty();
    }

    default public Optional<IRI> getInsertedContentRelation() {
        return Optional.empty();
    }

    public Stream<Quad> stream();

    default public Dataset dataset() {
        try (Stream<Quad> quads = this.stream();){
            Dataset dataset = quads.collect(TrellisUtils.toDataset());
            return dataset;
        }
    }

    default public Stream<Quad> stream(IRI graphName) {
        return this.stream(Collections.singleton(graphName));
    }

    default public Stream<Quad> stream(Collection<IRI> graphNames) {
        return this.stream().filter(quad -> quad.getGraphName().filter(graphNames::contains).isPresent());
    }

    default public Optional<BinaryMetadata> getBinaryMetadata() {
        return Optional.empty();
    }

    default public boolean hasMetadata(IRI graphName) {
        return this.getMetadataGraphNames().contains(graphName);
    }

    default public Set<IRI> getMetadataGraphNames() {
        return Collections.emptySet();
    }

    default public Stream<Map.Entry<String, String>> getExtraLinkRelations() {
        return Stream.empty();
    }

    public static enum SpecialResources implements Resource
    {
        MISSING_RESOURCE{

            @Override
            public IRI getIdentifier() {
                return null;
            }

            @Override
            public IRI getInteractionModel() {
                return null;
            }

            @Override
            public String getRevision() {
                return null;
            }

            @Override
            public Instant getModified() {
                return null;
            }

            @Override
            public Optional<IRI> getContainer() {
                return Optional.empty();
            }

            @Override
            public Stream<Quad> stream() {
                return Stream.empty();
            }

            public String toString() {
                return "A non-existent resource";
            }
        }
        ,
        DELETED_RESOURCE{

            @Override
            public IRI getIdentifier() {
                return null;
            }

            @Override
            public Instant getModified() {
                return null;
            }

            @Override
            public String getRevision() {
                return null;
            }

            @Override
            public Optional<IRI> getContainer() {
                return Optional.empty();
            }

            @Override
            public IRI getInteractionModel() {
                return null;
            }

            @Override
            public Stream<Quad> stream() {
                return Stream.empty();
            }

            public String toString() {
                return "A deleted resource";
            }
        };

    }
}

