/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.api;

import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.trellisldp.api.Metadata;
import org.trellisldp.api.RDFFactory;
import org.trellisldp.api.Resource;
import org.trellisldp.api.RetrievalService;
import org.trellisldp.api.TrellisUtils;

public interface ResourceService
extends RetrievalService<Resource> {
    default public CompletionStage<Void> create(Metadata metadata, Dataset dataset) {
        return this.replace(metadata, dataset);
    }

    public CompletionStage<Void> replace(Metadata var1, Dataset var2);

    public CompletionStage<Void> delete(Metadata var1);

    public CompletionStage<Void> add(IRI var1, Dataset var2);

    default public RDFTerm skolemize(RDFTerm term) {
        if (term instanceof BlankNode) {
            return RDFFactory.getInstance().createIRI("trellis:bnode/" + ((BlankNode)term).uniqueReference());
        }
        return term;
    }

    default public RDFTerm unskolemize(RDFTerm term) {
        String iri;
        if (term instanceof IRI && (iri = ((IRI)term).getIRIString()).startsWith("trellis:bnode/")) {
            return RDFFactory.getInstance().createBlankNode(iri.substring("trellis:bnode/".length()));
        }
        return term;
    }

    default public <T extends RDFTerm> T toInternal(T term, String baseUrl) {
        String iri;
        if (term instanceof IRI && (iri = ((IRI)term).getIRIString()).startsWith(baseUrl)) {
            IRI t = RDFFactory.getInstance().createIRI("trellis:data/" + iri.substring(baseUrl.length()));
            return (T)t;
        }
        return term;
    }

    default public <T extends RDFTerm> T toExternal(T term, String baseUrl) {
        String iri;
        if (term instanceof IRI && (iri = ((IRI)term).getIRIString()).startsWith("trellis:data/")) {
            IRI t = RDFFactory.getInstance().createIRI(baseUrl + iri.substring("trellis:data/".length()));
            return (T)t;
        }
        return term;
    }

    default public IRI getResourceIdentifier(String baseUrl, String path) {
        return TrellisUtils.buildTrellisIdentifier(path);
    }

    public CompletionStage<Void> touch(IRI var1);

    public Set<IRI> supportedInteractionModels();

    public String generateIdentifier();
}

