/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.api;

import java.util.Locale;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFSyntax;
import org.trellisldp.api.RDFFactory;

public final class Syntax {
    private static final RDF rdf = RDFFactory.getInstance();
    public static final RDFSyntax SPARQL_UPDATE = new TrellisSyntax("SPARQL-Update", "SPARQL 1.1 Update", "application/sparql-update", ".ru", "http://www.w3.org/TR/sparql11-update/", false);
    public static final RDFSyntax LD_PATCH = new TrellisSyntax("LD-Patch", "Linked Data Patch Format", "text/ldpatch", ".ldp", "http://www.w3.org/ns/formats/LD_Patch", false);

    private Syntax() {
    }

    static class TrellisSyntax
    implements RDFSyntax {
        private final String name;
        private final String title;
        private final String mediaType;
        private final String fileExtension;
        private final boolean supportsDataset;
        private final IRI iri;

        public TrellisSyntax(String name, String title, String mediaType, String fileExtension, String iri, boolean supportsDataset) {
            this.name = name;
            this.title = title;
            this.mediaType = mediaType.toLowerCase(Locale.ROOT);
            this.fileExtension = fileExtension.toLowerCase(Locale.ROOT);
            this.supportsDataset = supportsDataset;
            this.iri = rdf.createIRI(iri);
        }

        public String mediaType() {
            return this.mediaType;
        }

        public String fileExtension() {
            return this.fileExtension;
        }

        public boolean supportsDataset() {
            return this.supportsDataset;
        }

        public String title() {
            return this.title;
        }

        public String name() {
            return this.name;
        }

        public IRI iri() {
            return this.iri;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RDFSyntax)) {
                return false;
            }
            RDFSyntax other = (RDFSyntax)obj;
            return this.mediaType.equalsIgnoreCase(other.mediaType());
        }

        public int hashCode() {
            return this.mediaType.hashCode();
        }

        public String toString() {
            return this.title;
        }
    }
}

