/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.api;

import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.Triple;
import org.trellisldp.api.RDFFactory;

public final class TrellisUtils {
    private static final RDF rdf = RDFFactory.getInstance();
    private static final String SLASH = "/";
    public static final String TRELLIS_SCHEME = "trellis:";
    public static final String TRELLIS_DATA_PREFIX = "trellis:data/";
    public static final String TRELLIS_BNODE_PREFIX = "trellis:bnode/";
    public static final String TRELLIS_SESSION_PREFIX = "trellis:session/";
    public static final String TRELLIS_ADMIN_ROLE = "trellis_admin_role";

    public static Optional<IRI> getContainer(IRI identifier) {
        if (identifier.getIRIString().equals(TRELLIS_DATA_PREFIX)) {
            return Optional.empty();
        }
        String path = TrellisUtils.normalizeIdentifier(identifier.getIRIString().substring(TRELLIS_DATA_PREFIX.length()));
        int index = Math.max(path.lastIndexOf(47), 0);
        return Optional.of(rdf.createIRI(TRELLIS_DATA_PREFIX + path.substring(0, index)));
    }

    public static IRI normalizeIdentifier(IRI identifier) {
        String iri = identifier.getIRIString();
        if (iri.contains("#") || iri.contains("?") || iri.endsWith(SLASH)) {
            return rdf.createIRI(TrellisUtils.normalizeIdentifier(iri));
        }
        return identifier;
    }

    private static String normalizeIdentifier(String identifier) {
        return TrellisUtils.removeTrailingSlash(TrellisUtils.removeQueryParams(TrellisUtils.removeFragment(identifier)));
    }

    private static String removeFragment(String iri) {
        return iri.split("#")[0];
    }

    private static String removeQueryParams(String iri) {
        return iri.split("\\?")[0];
    }

    private static String removeTrailingSlash(String iri) {
        if (iri.endsWith(SLASH) && !TRELLIS_DATA_PREFIX.equals(iri)) {
            return iri.substring(0, iri.length() - 1);
        }
        return iri;
    }

    public static IRI buildTrellisIdentifier(String path) {
        String normalized;
        String string = normalized = path.endsWith(SLASH) ? path.substring(0, path.length() - 1) : path;
        if (normalized.startsWith(SLASH)) {
            return rdf.createIRI(TRELLIS_DATA_PREFIX + TrellisUtils.normalizePath(normalized.substring(1)));
        }
        return rdf.createIRI(TRELLIS_DATA_PREFIX + TrellisUtils.normalizePath(normalized));
    }

    public static String normalizePath(String path) {
        return path.replace(" ", "%20");
    }

    public static Collector<Triple, ?, Graph> toGraph() {
        return Collector.of(() -> ((RDF)rdf).createGraph(), Graph::add, (left, right) -> {
            right.iterate().forEach(arg_0 -> ((Graph)left).add(arg_0));
            return left;
        }, Collector.Characteristics.UNORDERED);
    }

    public static DatasetCollector toDataset() {
        return new DatasetCollector();
    }

    private TrellisUtils() {
    }

    static class DatasetCollector
    implements Collector<Quad, Dataset, Dataset> {
        DatasetCollector() {
        }

        @Override
        public Supplier<Dataset> supplier() {
            return () -> ((RDF)rdf).createDataset();
        }

        @Override
        public BiConsumer<Dataset, Quad> accumulator() {
            return Dataset::add;
        }

        @Override
        public BinaryOperator<Dataset> combiner() {
            return (left, right) -> {
                right.iterate().forEach(arg_0 -> ((Dataset)left).add(arg_0));
                return left;
            };
        }

        @Override
        public Function<Dataset, Dataset> finisher() {
            return x -> x;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Set.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
        }
    }
}

