/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.app;

import io.dropwizard.Application;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.text.StrSubstitutor;
import org.apache.tamaya.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trellisldp.api.AccessControlService;
import org.trellisldp.api.ServiceBundler;
import org.trellisldp.app.TrellisUtils;
import org.trellisldp.app.config.BasicAuthConfiguration;
import org.trellisldp.app.config.JwtAuthConfiguration;
import org.trellisldp.app.config.TrellisConfiguration;
import org.trellisldp.http.AgentAuthorizationFilter;
import org.trellisldp.http.CacheControlFilter;
import org.trellisldp.http.CrossOriginResourceSharingFilter;
import org.trellisldp.http.TrellisHttpFilter;
import org.trellisldp.http.TrellisHttpResource;
import org.trellisldp.http.WebAcFilter;
import org.trellisldp.http.WebSubHeaderFilter;
import org.trellisldp.webac.WebACService;

public abstract class AbstractTrellisApplication<T extends TrellisConfiguration>
extends Application<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTrellisApplication.class);
    public static final String CONFIG_APP_INITIALIZE_ROOT = "trellis.app.initialize.root";

    protected abstract ServiceBundler getServiceBundler();

    protected List<Object> getComponents() {
        return Collections.emptyList();
    }

    protected Object getLdpComponent(T config, boolean initialize) {
        TrellisHttpResource ldpResource = new TrellisHttpResource(this.getServiceBundler(), ((TrellisConfiguration)((Object)config)).getBaseUrl());
        if (initialize) {
            ldpResource.initialize();
        }
        return ldpResource;
    }

    protected void initialize(T config, Environment environment) {
        LOGGER.debug("Initializing Trellis application with {}", config.getClass());
    }

    public String getName() {
        return "Trellis LDP";
    }

    public void initialize(Bootstrap<T> bootstrap) {
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StrSubstitutor)new EnvironmentVariableSubstitutor(false)));
    }

    public void run(T config, Environment environment) throws Exception {
        this.initialize(config, environment);
        TrellisUtils.getAuthFilters(config).forEach(arg_0 -> ((JerseyEnvironment)environment.jersey()).register(arg_0));
        environment.jersey().register(this.getLdpComponent(config, (Boolean)ConfigurationProvider.getConfiguration().getOrDefault(CONFIG_APP_INITIALIZE_ROOT, Boolean.class, (Object)Boolean.TRUE)));
        AgentAuthorizationFilter agentFilter = new AgentAuthorizationFilter(this.getServiceBundler().getAgentService(), new HashSet<String>(((TrellisConfiguration)((Object)config)).getAuth().getAdminUsers()));
        environment.jersey().register((Object)agentFilter);
        environment.jersey().register((Object)new TrellisHttpFilter());
        environment.jersey().register((Object)new CacheControlFilter(((TrellisConfiguration)((Object)config)).getCache().getMaxAge(), ((TrellisConfiguration)((Object)config)).getCache().getMustRevalidate(), ((TrellisConfiguration)((Object)config)).getCache().getNoCache()));
        TrellisUtils.getWebacCache(config).ifPresent(cache -> {
            WebACService webac = new WebACService(this.getServiceBundler().getResourceService(), cache);
            ArrayList challenges = new ArrayList();
            Optional.of(config.getAuth().getJwt()).filter(JwtAuthConfiguration::getEnabled).map(x -> "Bearer").ifPresent(challenges::add);
            Optional.of(config.getAuth().getBasic()).filter(BasicAuthConfiguration::getEnabled).map(x -> "Basic").ifPresent(challenges::add);
            environment.jersey().register((Object)new WebAcFilter((AccessControlService)webac, challenges, config.getAuth().getRealm(), config.getBaseUrl()));
        });
        Optional.ofNullable(((TrellisConfiguration)((Object)config)).getHubUrl()).ifPresent(hub -> environment.jersey().register((Object)new WebSubHeaderFilter(hub)));
        TrellisUtils.getCorsConfiguration(config).ifPresent(cors -> environment.jersey().register((Object)new CrossOriginResourceSharingFilter(cors.getAllowOrigin(), cors.getAllowMethods(), cors.getAllowHeaders(), cors.getExposeHeaders(), cors.getAllowCredentials(), cors.getMaxAge())));
        this.getComponents().forEach(arg_0 -> ((JerseyEnvironment)environment.jersey()).register(arg_0));
    }
}

