/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.app;

import com.google.common.cache.Cache;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trellisldp.api.CacheService;

public class TrellisCache<K, V>
implements CacheService<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrellisCache.class);
    private final Cache<K, V> cache;

    public TrellisCache(Cache<K, V> cache) {
        this.cache = cache;
    }

    public V get(K key, Function<K, V> mapper) {
        try {
            return (V)this.cache.get(key, () -> mapper.apply(key));
        }
        catch (ExecutionException ex) {
            LOGGER.warn("Error fetching {} from cache: {}", key, (Object)ex.getMessage());
            return null;
        }
    }
}

