/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.app;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.ContainerRequestFilter;
import org.apache.commons.rdf.api.IRI;
import org.trellisldp.api.CacheService;
import org.trellisldp.app.TrellisCache;
import org.trellisldp.app.config.AuthConfiguration;
import org.trellisldp.app.config.CORSConfiguration;
import org.trellisldp.app.config.JwtAuthConfiguration;
import org.trellisldp.app.config.TrellisConfiguration;
import org.trellisldp.auth.basic.BasicAuthFilter;
import org.trellisldp.auth.oauth.Authenticator;
import org.trellisldp.auth.oauth.NullAuthenticator;
import org.trellisldp.auth.oauth.OAuthFilter;
import org.trellisldp.auth.oauth.OAuthUtils;

final class TrellisUtils {
    public static Authenticator getJwtAuthenticator(JwtAuthConfiguration config) {
        Authenticator jwksAuthenticator = OAuthUtils.buildAuthenticatorWithJwk((String)config.getJwks());
        if (Objects.nonNull(jwksAuthenticator)) {
            return jwksAuthenticator;
        }
        Authenticator keystoreAuthenticator = OAuthUtils.buildAuthenticatorWithTruststore((String)config.getKeyStore(), (char[])config.getKeyStorePassword().toCharArray(), config.getKeyIds());
        if (Objects.nonNull(keystoreAuthenticator)) {
            return keystoreAuthenticator;
        }
        Authenticator sharedKeyAuthenticator = OAuthUtils.buildAuthenticatorWithSharedSecret((String)config.getKey());
        if (Objects.nonNull(sharedKeyAuthenticator)) {
            return sharedKeyAuthenticator;
        }
        return new NullAuthenticator();
    }

    public static Optional<CacheService<String, Set<IRI>>> getWebacCache(TrellisConfiguration config) {
        if (config.getAuth().getWebac().getEnabled()) {
            Cache authCache = CacheBuilder.newBuilder().maximumSize(config.getAuth().getWebac().getCacheSize()).expireAfterWrite(config.getAuth().getWebac().getCacheExpireSeconds(), TimeUnit.SECONDS).build();
            return Optional.of(new TrellisCache(authCache));
        }
        return Optional.empty();
    }

    public static List<ContainerRequestFilter> getAuthFilters(TrellisConfiguration config) {
        ArrayList<ContainerRequestFilter> filters = new ArrayList<ContainerRequestFilter>();
        AuthConfiguration auth = config.getAuth();
        if (auth.getJwt().getEnabled()) {
            filters.add((ContainerRequestFilter)new OAuthFilter(TrellisUtils.getJwtAuthenticator(auth.getJwt())));
        }
        if (auth.getBasic().getEnabled() && Objects.nonNull(auth.getBasic().getUsersFile())) {
            filters.add((ContainerRequestFilter)new BasicAuthFilter(auth.getBasic().getUsersFile()));
        }
        return filters;
    }

    public static Optional<CORSConfiguration> getCorsConfiguration(TrellisConfiguration config) {
        if (config.getCors().getEnabled()) {
            return Optional.of(config.getCors());
        }
        return Optional.empty();
    }

    private TrellisUtils() {
    }
}

