/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.dropwizard;

import io.dropwizard.Application;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.microprofile.config.ConfigProvider;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trellisldp.dropwizard.CrossOriginResourceSharingFilter;
import org.trellisldp.dropwizard.TrellisUtils;
import org.trellisldp.dropwizard.config.BasicAuthConfiguration;
import org.trellisldp.dropwizard.config.JwtAuthConfiguration;
import org.trellisldp.dropwizard.config.TrellisConfiguration;
import org.trellisldp.http.CacheControlFilter;
import org.trellisldp.http.TrellisHttpFilter;
import org.trellisldp.http.TrellisHttpResource;
import org.trellisldp.http.WebSubHeaderFilter;
import org.trellisldp.http.core.ServiceBundler;
import org.trellisldp.vocabulary.Trellis;
import org.trellisldp.webac.WebAcFilter;
import org.trellisldp.webac.WebAcService;

public abstract class AbstractTrellisApplication<T extends TrellisConfiguration>
extends Application<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTrellisApplication.class);
    public static final String CONFIG_DROPWIZARD_INITIALIZE_ROOT = "trellis.dropwizard.initialize-root";

    protected abstract ServiceBundler getServiceBundler();

    protected List<Object> getComponents() {
        return Collections.emptyList();
    }

    protected Object getLdpComponent(T config, boolean initialize) throws Exception {
        TrellisHttpResource ldpResource = new TrellisHttpResource(this.getServiceBundler(), Collections.singletonMap("acl", Trellis.PreferAccessControl), ((TrellisConfiguration)((Object)config)).getBaseUrl());
        if (initialize) {
            ldpResource.initialize();
        }
        return ldpResource;
    }

    protected void initialize(T config, Environment environment) {
        LOGGER.debug("Initializing Trellis application with {}", config.getClass());
    }

    public String getName() {
        return "Trellis LDP";
    }

    public void initialize(Bootstrap<T> bootstrap) {
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StringSubstitutor)new EnvironmentVariableSubstitutor(false)));
    }

    public void run(T config, Environment environment) throws Exception {
        this.initialize(config, environment);
        TrellisUtils.getAuthFilters(config).forEach(arg_0 -> ((JerseyEnvironment)environment.jersey()).register(arg_0));
        environment.jersey().register(this.getLdpComponent(config, ConfigProvider.getConfig().getOptionalValue(CONFIG_DROPWIZARD_INITIALIZE_ROOT, Boolean.class).orElse(Boolean.TRUE)));
        environment.jersey().register((Object)new TrellisHttpFilter());
        CacheControlFilter cacheFilter = new CacheControlFilter();
        cacheFilter.setMaxAge(((TrellisConfiguration)((Object)config)).getCache().getMaxAge());
        cacheFilter.setMustRevalidate(((TrellisConfiguration)((Object)config)).getCache().getMustRevalidate());
        cacheFilter.setNoCache(((TrellisConfiguration)((Object)config)).getCache().getNoCache());
        environment.jersey().register((Object)cacheFilter);
        Optional.ofNullable(TrellisUtils.getWebacService(config, this.getServiceBundler().getResourceService())).ifPresent(webac -> {
            ArrayList challengeTypes = new ArrayList();
            Optional.of(config.getAuth().getJwt()).filter(JwtAuthConfiguration::getEnabled).map(x -> "Bearer").ifPresent(challengeTypes::add);
            Optional.of(config.getAuth().getBasic()).filter(BasicAuthConfiguration::getEnabled).map(x -> "Basic").ifPresent(challengeTypes::add);
            List challenges = challengeTypes.stream().map(String::trim).map(ch -> TrellisUtils.buildChallenge(ch, config.getAuth().getRealm(), config.getAuth().getScope())).collect(Collectors.toList());
            WebAcFilter webacFilter = new WebAcFilter();
            webacFilter.setChallenges(challenges);
            webacFilter.setBaseUrl(config.getBaseUrl());
            environment.jersey().register((Object)webacFilter);
            environment.jersey().register((Object)new AbstractBinder((WebAcService)webac){
                final /* synthetic */ WebAcService val$webac;
                {
                    this.val$webac = webAcService;
                }

                protected void configure() {
                    this.bind(this.val$webac).to(WebAcService.class);
                }
            });
        });
        Optional.ofNullable(((TrellisConfiguration)((Object)config)).getHubUrl()).ifPresent(hub -> {
            WebSubHeaderFilter webSubFilter = new WebSubHeaderFilter();
            webSubFilter.setHub(hub);
            environment.jersey().register((Object)webSubFilter);
        });
        Optional.ofNullable(TrellisUtils.getCorsConfiguration(config)).ifPresent(cors -> environment.jersey().register((Object)new CrossOriginResourceSharingFilter(cors.getAllowOrigin(), cors.getAllowMethods(), cors.getAllowHeaders(), cors.getExposeHeaders(), cors.getAllowCredentials(), cors.getMaxAge())));
        this.getComponents().forEach(arg_0 -> ((JerseyEnvironment)environment.jersey()).register(arg_0));
    }
}

