/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.dropwizard;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class CrossOriginResourceSharingFilter
implements ContainerResponseFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrossOriginResourceSharingFilter.class);
    private static final Set<String> simpleResponseHeaders = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("cache-control", "content-language", "expires", "last-modified", "pragma")));
    private static final Set<String> simpleHeaders = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("accept-language", "content-language")));
    private final Set<String> origins;
    private final Set<String> allowedMethods;
    private final Set<String> allowedHeaders;
    private final Set<String> exposedHeaders;
    private final boolean credentials;
    private final int cacheSeconds;

    public CrossOriginResourceSharingFilter(Collection<String> origins, Collection<String> allowedMethods, Collection<String> allowedHeaders, Collection<String> exposedHeaders, boolean credentials, int cacheSeconds) {
        this.origins = new HashSet<String>(origins);
        this.allowedMethods = new HashSet<String>(allowedMethods);
        this.allowedHeaders = allowedHeaders.stream().map(String::toLowerCase).filter(x -> !simpleHeaders.contains(x)).collect(Collectors.toSet());
        this.exposedHeaders = exposedHeaders.stream().map(String::toLowerCase).filter(x -> !simpleResponseHeaders.contains(x)).collect(Collectors.toSet());
        this.credentials = credentials;
        this.cacheSeconds = cacheSeconds;
    }

    public void filter(ContainerRequestContext req, ContainerResponseContext res) {
        this.handleRequest(req, res).forEach((arg_0, arg_1) -> ((MultivaluedMap)res.getHeaders()).add(arg_0, arg_1));
    }

    private Map<String, String> handleRequest(ContainerRequestContext req, ContainerResponseContext res) {
        if ("OPTIONS".equals(req.getMethod())) {
            return this.handlePreflightRequest(req, res);
        }
        return this.handleSimpleRequest(req);
    }

    private boolean originMatches(String origin) {
        return this.origins.contains(origin) || this.origins.contains("*");
    }

    private Map<String, String> handleSimpleRequest(ContainerRequestContext req) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String origin = req.getHeaderString("Origin");
        if (origin == null) {
            LOGGER.debug("CORS: No Origin header");
            return Collections.emptyMap();
        }
        if (!this.originMatches(origin)) {
            LOGGER.debug("CORS: No Origin header match");
            return Collections.emptyMap();
        }
        headers.put("Access-Control-Allow-Origin", origin);
        if (this.credentials) {
            headers.put("Access-Control-Allow-Credentials", "true");
        }
        if (!this.exposedHeaders.isEmpty()) {
            headers.put("Access-Control-Expose-Headers", String.join((CharSequence)",", this.exposedHeaders));
        }
        return headers;
    }

    private Map<String, String> handlePreflightRequest(ContainerRequestContext req, ContainerResponseContext res) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String origin = req.getHeaderString("Origin");
        if (origin == null) {
            LOGGER.debug("CORS PreFlight: No Origin header");
            return Collections.emptyMap();
        }
        if (!this.originMatches(origin)) {
            LOGGER.debug("CORS PreFlight: No Origin header match");
            return Collections.emptyMap();
        }
        String method = req.getHeaderString("Access-Control-Request-Method");
        Set<String> fieldNames = CrossOriginResourceSharingFilter.populateFieldNames(req.getHeaderString("Access-Control-Request-Headers"));
        if (!this.allowedMethods.contains(method)) {
            return Collections.emptyMap();
        }
        if (fieldNames.stream().map(String::toLowerCase).filter(x -> !simpleHeaders.contains(x)).anyMatch(x -> !this.allowedHeaders.contains(x))) {
            return Collections.emptyMap();
        }
        headers.put("Access-Control-Allow-Origin", origin);
        if (this.credentials) {
            headers.put("Access-Control-Allow-Credentials", "true");
        }
        if (this.cacheSeconds > 0) {
            headers.put("Access-Control-Max-Age", Integer.toString(this.cacheSeconds));
        }
        headers.put("Access-Control-Allow-Methods", this.allowedMethods.stream().filter(res.getAllowedMethods()::contains).collect(Collectors.joining(",")));
        if (fieldNames.stream().map(String::toLowerCase).anyMatch(x -> !simpleHeaders.contains(x))) {
            headers.put("Access-Control-Allow-Headers", String.join((CharSequence)",", this.allowedHeaders));
        }
        return headers;
    }

    private static Set<String> populateFieldNames(String requestHeaders) {
        return requestHeaders == null ? Collections.emptySet() : Arrays.stream(requestHeaders.split(",")).map(String::trim).collect(Collectors.toSet());
    }
}

