/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.dropwizard;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.ContainerRequestFilter;
import org.trellisldp.api.CacheService;
import org.trellisldp.api.ResourceService;
import org.trellisldp.api.RuntimeTrellisException;
import org.trellisldp.auth.basic.BasicAuthFilter;
import org.trellisldp.cache.TrellisCache;
import org.trellisldp.dropwizard.config.AuthConfiguration;
import org.trellisldp.dropwizard.config.CORSConfiguration;
import org.trellisldp.dropwizard.config.JwtAuthConfiguration;
import org.trellisldp.dropwizard.config.TrellisConfiguration;
import org.trellisldp.oauth.Authenticator;
import org.trellisldp.oauth.NullAuthenticator;
import org.trellisldp.oauth.OAuthFilter;
import org.trellisldp.oauth.OAuthUtils;
import org.trellisldp.webac.WebAcService;

final class TrellisUtils {
    public static Authenticator getJwtAuthenticator(JwtAuthConfiguration config) {
        Authenticator jwksAuthenticator = OAuthUtils.buildAuthenticatorWithJwk((String)config.getJwks());
        if (jwksAuthenticator != null) {
            return jwksAuthenticator;
        }
        Authenticator keystoreAuthenticator = OAuthUtils.buildAuthenticatorWithTruststore((String)config.getKeyStore(), (char[])config.getKeyStorePassword().toCharArray(), config.getKeyIds());
        if (keystoreAuthenticator != null) {
            return keystoreAuthenticator;
        }
        Authenticator sharedKeyAuthenticator = OAuthUtils.buildAuthenticatorWithSharedSecret((String)config.getKey());
        if (sharedKeyAuthenticator != null) {
            return sharedKeyAuthenticator;
        }
        return new NullAuthenticator();
    }

    public static WebAcService getWebacService(TrellisConfiguration config, ResourceService resourceService) {
        if (config.getAuth().getWebac().getEnabled()) {
            Cache authCache = CacheBuilder.newBuilder().maximumSize(config.getAuth().getWebac().getCacheSize()).expireAfterWrite(config.getAuth().getWebac().getCacheExpireSeconds(), TimeUnit.SECONDS).build();
            WebAcService webac = new WebAcService(resourceService, (CacheService)new TrellisCache(authCache));
            try {
                webac.initialize();
            }
            catch (Exception ex) {
                throw new RuntimeTrellisException("Error initializing Access Control system", (Throwable)ex);
            }
            return webac;
        }
        return null;
    }

    public static List<ContainerRequestFilter> getAuthFilters(TrellisConfiguration config) {
        OAuthFilter filter;
        ArrayList<ContainerRequestFilter> filters = new ArrayList<ContainerRequestFilter>();
        AuthConfiguration auth = config.getAuth();
        String realm = config.getAuth().getRealm();
        HashSet<String> admins = new HashSet<String>(config.getAuth().getAdminUsers());
        if (auth.getJwt().getEnabled()) {
            filter = new OAuthFilter();
            filter.setAuthenticator(TrellisUtils.getJwtAuthenticator(auth.getJwt()));
            filter.setChallenge("Bearer realm=\"" + realm + "\"");
            filter.setAdmins(admins);
            filters.add((ContainerRequestFilter)filter);
        }
        if (auth.getBasic().getEnabled() && auth.getBasic().getUsersFile() != null) {
            filter = new BasicAuthFilter();
            filter.setFile(new File(auth.getBasic().getUsersFile()));
            filter.setChallenge("Basic realm=\"" + realm + "\"");
            filter.setAdmins(admins);
            filters.add((ContainerRequestFilter)filter);
        }
        return filters;
    }

    public static String buildChallenge(String scheme, String realm, String scope) {
        String realmParam = realm.isEmpty() ? "" : " realm=\"" + realm + "\"";
        String scopeParam = scope.isEmpty() ? "" : " scope=\"" + scope + "\"";
        return scheme + realmParam + scopeParam;
    }

    public static CORSConfiguration getCorsConfiguration(TrellisConfiguration config) {
        if (config.getCors().getEnabled()) {
            return config.getCors();
        }
        return null;
    }

    private TrellisUtils() {
    }
}

