/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.dropwizard.config;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.Configuration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.trellisldp.dropwizard.config.AssetConfiguration;
import org.trellisldp.dropwizard.config.AuthConfiguration;
import org.trellisldp.dropwizard.config.CORSConfiguration;
import org.trellisldp.dropwizard.config.CacheConfiguration;
import org.trellisldp.dropwizard.config.JsonLdConfiguration;
import org.trellisldp.dropwizard.config.NotificationsConfiguration;

public class TrellisConfiguration
extends Configuration {
    @NotNull
    private String defaultName = "Trellis";
    @NotNull
    private AuthConfiguration auth = new AuthConfiguration();
    @NotNull
    private CacheConfiguration cache = new CacheConfiguration();
    @NotNull
    private AssetConfiguration assets = new AssetConfiguration();
    @NotNull
    private CORSConfiguration cors = new CORSConfiguration();
    @NotNull
    private JsonLdConfiguration jsonld = new JsonLdConfiguration();
    @NotNull
    private NotificationsConfiguration notifications = new NotificationsConfiguration();
    private boolean useRelativeIris;
    private String hubUrl;
    private String baseUrl;
    private final Map<String, Object> extras = Collections.synchronizedMap(new HashMap());

    @JsonProperty
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @JsonProperty
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @JsonProperty
    public String getHubUrl() {
        return this.hubUrl;
    }

    @JsonProperty
    public void setHubUrl(String hubUrl) {
        this.hubUrl = hubUrl;
    }

    @JsonProperty
    public void setAssets(AssetConfiguration assets) {
        this.assets = assets;
    }

    @JsonProperty
    public AssetConfiguration getAssets() {
        return this.assets;
    }

    @JsonProperty
    public String getDefaultName() {
        return this.defaultName;
    }

    @JsonProperty
    public void setDefaultName(String name) {
        this.defaultName = name;
    }

    @JsonAnySetter
    public TrellisConfiguration setAdditionalConfig(String name, Object value) {
        this.extras.put(name, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.extras;
    }

    @JsonProperty
    public void setCache(CacheConfiguration cache) {
        this.cache = cache;
    }

    @JsonProperty
    public CacheConfiguration getCache() {
        return this.cache;
    }

    @JsonProperty
    public void setCors(CORSConfiguration cors) {
        this.cors = cors;
    }

    @JsonProperty
    public CORSConfiguration getCors() {
        return this.cors;
    }

    @JsonProperty
    public void setAuth(AuthConfiguration auth) {
        this.auth = auth;
    }

    @JsonProperty
    public AuthConfiguration getAuth() {
        return this.auth;
    }

    @JsonProperty
    public void setJsonld(JsonLdConfiguration jsonld) {
        this.jsonld = jsonld;
    }

    @JsonProperty
    public JsonLdConfiguration getJsonld() {
        return this.jsonld;
    }

    @JsonProperty
    public void setUseRelativeIris(boolean useRelativeIris) {
        this.useRelativeIris = useRelativeIris;
    }

    @JsonProperty
    public boolean getUseRelativeIris() {
        return this.useRelativeIris;
    }

    @JsonProperty
    public void setNotifications(NotificationsConfiguration notifications) {
        this.notifications = notifications;
    }

    @JsonProperty
    public NotificationsConfiguration getNotifications() {
        return this.notifications;
    }
}

