/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.event.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.IRI;
import org.trellisldp.api.Event;
import org.trellisldp.vocabulary.AS;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonPropertyOrder(value={"@context", "id", "type", "inbox", "actor", "object", "published"})
class ActivityStreamMessage {
    private String context = "https://www.w3.org/ns/activitystreams";
    private String id;
    private List<String> type;
    private String inbox;
    private List<String> actor;
    private EventResource object;
    private String published;

    ActivityStreamMessage() {
    }

    @JsonProperty(value="@context")
    public String getContext() {
        return this.context;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getType() {
        return this.type;
    }

    public String getInbox() {
        return this.inbox;
    }

    public List<String> getActor() {
        return this.actor;
    }

    public EventResource getObject() {
        return this.object;
    }

    @JsonProperty(value="published")
    public String getPublished() {
        return this.published;
    }

    public static ActivityStreamMessage from(Event event) {
        ActivityStreamMessage msg = new ActivityStreamMessage();
        msg.id = event.getIdentifier().getIRIString();
        msg.type = event.getTypes().stream().map(IRI::getIRIString).map(type -> type.startsWith(AS.getNamespace()) ? type.substring(AS.getNamespace().length()) : type).collect(Collectors.toList());
        msg.published = event.getCreated().toString();
        List actors = event.getAgents().stream().map(IRI::getIRIString).collect(Collectors.toList());
        msg.actor = actors.isEmpty() ? null : actors;
        event.getInbox().map(IRI::getIRIString).ifPresent(inbox -> {
            msg.inbox = inbox;
        });
        event.getObject().map(IRI::getIRIString).ifPresent(object -> {
            msg.object = new EventResource((String)object, event.getObjectTypes().stream().map(IRI::getIRIString).collect(Collectors.toList()));
        });
        return msg;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    static class EventResource {
        private final String id;
        private final List<String> type;

        public EventResource(String id, List<String> type) {
            this.id = id;
            this.type = type.isEmpty() ? null : type;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getType() {
            return this.type;
        }
    }
}

