/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.event.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import javax.enterprise.context.ApplicationScoped;
import org.trellisldp.api.Event;
import org.trellisldp.api.EventSerializationService;
import org.trellisldp.api.RuntimeTrellisException;
import org.trellisldp.event.jackson.ActivityStreamMessage;

@ApplicationScoped
public class DefaultEventSerializationService
implements EventSerializationService {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public String serialize(Event event) {
        try {
            return MAPPER.writeValueAsString((Object)ActivityStreamMessage.from(event));
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeTrellisException("Error serializing event", (Throwable)ex);
        }
    }

    static {
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

