/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.kafka;

import java.util.Objects;
import java.util.ServiceLoader;
import org.apache.commons.rdf.api.IRI;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trellisldp.api.ActivityStreamService;
import org.trellisldp.api.Event;
import org.trellisldp.api.EventService;

public class KafkaPublisher
implements EventService {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPublisher.class);
    private static ActivityStreamService service = ServiceLoader.load(ActivityStreamService.class).iterator().next();
    private final Producer<String, String> producer;
    private final String topicName;

    public KafkaPublisher(Producer<String, String> producer, String topicName) {
        Objects.requireNonNull(producer);
        Objects.requireNonNull(topicName);
        this.producer = producer;
        this.topicName = topicName;
    }

    public void emit(Event event) {
        Objects.requireNonNull(event, "Cannot emit a null event!");
        service.serialize(event).ifPresent(message -> {
            LOGGER.debug("Sending message to Kafka topic: {}", (Object)this.topicName);
            this.producer.send(new ProducerRecord(this.topicName, event.getTarget().map(IRI::getIRIString).orElse(null), message));
        });
    }
}

