/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.namespace;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.ConfigProvider;
import org.trellisldp.api.NamespaceService;
import org.trellisldp.vocabulary.ACL;
import org.trellisldp.vocabulary.AS;
import org.trellisldp.vocabulary.DC;
import org.trellisldp.vocabulary.FOAF;
import org.trellisldp.vocabulary.LDP;
import org.trellisldp.vocabulary.RDF;
import org.trellisldp.vocabulary.RDFS;
import org.trellisldp.vocabulary.SKOS;
import org.trellisldp.vocabulary.VCARD;
import org.trellisldp.vocabulary.XSD;

@ApplicationScoped
public class SimpleNamespaceService
implements NamespaceService {
    public static final String CONFIG_NAMESPACE_MAPPING = "trellis.namespace.mapping";
    private final Map<String, String> namespaces = new HashMap<String, String>();

    public SimpleNamespaceService() {
        this.namespaces.put("ldp", LDP.getNamespace());
        this.namespaces.put("acl", ACL.getNamespace());
        this.namespaces.put("as", AS.getNamespace());
        this.namespaces.put("dc", DC.getNamespace());
        this.namespaces.put("rdf", RDF.getNamespace());
        this.namespaces.put("rdfs", RDFS.getNamespace());
        this.namespaces.put("skos", SKOS.getNamespace());
        this.namespaces.put("xsd", XSD.getNamespace());
        this.namespaces.put("foaf", FOAF.getNamespace());
        this.namespaces.put("vcard", VCARD.getNamespace());
        ConfigProvider.getConfig().getOptionalValue(CONFIG_NAMESPACE_MAPPING, String.class).map(SimpleNamespaceService::configToMap).ifPresent(data -> data.forEach(this.namespaces::put));
    }

    public Map<String, String> getNamespaces() {
        return Collections.unmodifiableMap(this.namespaces);
    }

    public boolean setPrefix(String prefix, String namespace) {
        return true;
    }

    static Map<String, String> configToMap(String config) {
        return Arrays.stream(config.split(",")).map(item -> item.split("=")).filter(kv -> ((String[])kv).length == 2).filter(kv -> !kv[0].trim().isEmpty() && !kv[1].trim().isEmpty()).collect(Collectors.toMap(kv -> kv[0].trim(), kv -> kv[1].trim()));
    }
}

