/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.notification.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.IRI;
import org.trellisldp.api.Notification;
import org.trellisldp.vocabulary.AS;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonPropertyOrder(value={"@context", "id", "type", "actor", "object", "published"})
class ActivityStreamMessage {
    private List<Object> contexts = List.of("https://www.w3.org/ns/activitystreams", Map.of("state", Map.of("@id", "http://www.w3.org/2011/http-headers#etag")));
    private String id;
    private List<String> type;
    private List<String> actor;
    private NotificationResource object;
    private String published;

    ActivityStreamMessage() {
    }

    @JsonProperty(value="@context")
    public List<Object> getContext() {
        return this.contexts;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getType() {
        return this.type;
    }

    public List<String> getActor() {
        return this.actor;
    }

    public NotificationResource getObject() {
        return this.object;
    }

    @JsonProperty(value="published")
    public String getPublished() {
        return this.published;
    }

    public static ActivityStreamMessage from(Notification notification) {
        ActivityStreamMessage msg = new ActivityStreamMessage();
        msg.id = notification.getIdentifier().getIRIString();
        msg.type = notification.getTypes().stream().map(IRI::getIRIString).map(type -> type.startsWith(AS.getNamespace()) ? type.substring(AS.getNamespace().length()) : type).collect(Collectors.toList());
        msg.published = notification.getCreated().toString();
        List actors = notification.getAgents().stream().map(IRI::getIRIString).collect(Collectors.toList());
        msg.actor = actors.isEmpty() ? null : actors;
        notification.getObject().map(IRI::getIRIString).ifPresent(object -> {
            msg.object = new NotificationResource((String)object, notification.getObjectTypes().stream().map(IRI::getIRIString).collect(Collectors.toList()), notification.getObjectState().orElse(null));
        });
        return msg;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    static class NotificationResource {
        private final String id;
        private final List<String> type;
        private final String state;

        public NotificationResource(String id, List<String> type, String state) {
            this.id = id;
            this.type = type.isEmpty() ? null : type;
            this.state = state;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getType() {
            return this.type;
        }

        public String getState() {
            return this.state;
        }
    }
}

