/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.notification.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import javax.enterprise.context.ApplicationScoped;
import org.trellisldp.api.Notification;
import org.trellisldp.api.NotificationSerializationService;
import org.trellisldp.api.TrellisRuntimeException;
import org.trellisldp.notification.jackson.ActivityStreamMessage;

@ApplicationScoped
public class DefaultNotificationSerializationService
implements NotificationSerializationService {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public String serialize(Notification notification) {
        try {
            return MAPPER.writeValueAsString((Object)ActivityStreamMessage.from(notification));
        }
        catch (JsonProcessingException ex) {
            throw new TrellisRuntimeException("Error serializing notification", (Throwable)ex);
        }
    }

    static {
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

