/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.spi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.IRI;
import org.trellisldp.spi.Event;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
class ActivityStreamMessage {
    private String id;
    private List<String> type;
    private String inbox;
    private List<String> actor;
    private EventResource object;
    @JsonProperty(value="@context")
    public String context = "https://www.w3.org/ns/activitystreams";

    ActivityStreamMessage() {
    }

    public String getId() {
        return this.id;
    }

    public List<String> getType() {
        return this.type;
    }

    public String getInbox() {
        return this.inbox;
    }

    public List<String> getActor() {
        return this.actor;
    }

    public EventResource getObject() {
        return this.object;
    }

    public static ActivityStreamMessage from(Event event) {
        ActivityStreamMessage msg = new ActivityStreamMessage();
        msg.id = event.getIdentifier().getIRIString();
        msg.type = event.getTypes().stream().map(IRI::getIRIString).collect(Collectors.toList());
        msg.actor = event.getAgents().stream().map(IRI::getIRIString).collect(Collectors.toList());
        event.getInbox().map(IRI::getIRIString).ifPresent(inbox -> {
            msg.inbox = inbox;
        });
        event.getTarget().map(IRI::getIRIString).ifPresent(target -> {
            msg.object = new EventResource((String)target, event.getTargetTypes().stream().map(IRI::getIRIString).collect(Collectors.toList()));
        });
        return msg;
    }

    static class EventResource {
        private String id;
        private List<String> type;

        public EventResource(String id, List<String> type) {
            this.id = id;
            this.type = type;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getType() {
            return this.type;
        }
    }
}

