/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.spi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Optional;
import org.trellisldp.spi.ActivityStreamMessage;
import org.trellisldp.spi.Event;

final class ActivityStreamSerializer {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    static Optional<String> serialize(Event event) {
        try {
            return Optional.of(MAPPER.writeValueAsString((Object)ActivityStreamMessage.from(event)));
        }
        catch (JsonProcessingException ex) {
            return Optional.empty();
        }
    }

    private ActivityStreamSerializer() {
    }

    static {
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

