/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.trellisldp.vocabulary.ACL;

public class Authorization {
    private final BlankNodeOrIRI identifier;
    private final Map<IRI, Set<IRI>> dataMap = new HashMap<IRI, Set<IRI>>();

    public static Authorization from(BlankNodeOrIRI identifier, Graph graph) {
        return new Authorization(identifier, graph);
    }

    public Authorization(BlankNodeOrIRI identifier, Graph graph) {
        Objects.requireNonNull(identifier, "The Authorization identifier may not be null!");
        Objects.requireNonNull(graph, "The input graph may not be null!");
        this.identifier = identifier;
        this.dataMap.put(ACL.agent, new HashSet());
        this.dataMap.put(ACL.agentClass, new HashSet());
        this.dataMap.put(ACL.agentGroup, new HashSet());
        this.dataMap.put(ACL.mode, new HashSet());
        this.dataMap.put(ACL.accessTo, new HashSet());
        this.dataMap.put(ACL.default_, new HashSet());
        graph.stream(identifier, null, null).filter(triple -> this.dataMap.containsKey(triple.getPredicate())).filter(triple -> triple.getObject() instanceof IRI).forEach(triple -> this.dataMap.get(triple.getPredicate()).add((IRI)triple.getObject()));
    }

    public BlankNodeOrIRI getIdentifier() {
        return this.identifier;
    }

    public Set<IRI> getAgent() {
        return Collections.unmodifiableSet(this.dataMap.get(ACL.agent));
    }

    public Set<IRI> getAgentClass() {
        return Collections.unmodifiableSet(this.dataMap.get(ACL.agentClass));
    }

    public Set<IRI> getAgentGroup() {
        return Collections.unmodifiableSet(this.dataMap.get(ACL.agentGroup));
    }

    public Set<IRI> getMode() {
        return Collections.unmodifiableSet(this.dataMap.get(ACL.mode));
    }

    public Set<IRI> getAccessTo() {
        return Collections.unmodifiableSet(this.dataMap.get(ACL.accessTo));
    }

    public Set<IRI> getDefault() {
        return Collections.unmodifiableSet(this.dataMap.get(ACL.default_));
    }
}

