/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.spi;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;
import org.trellisldp.api.Binary;
import org.trellisldp.spi.Session;

public interface BinaryService {
    default public Optional<InputStream> getContent(String partition, IRI identifier) {
        return this.getResolver(identifier).flatMap(resolver -> resolver.getContent(partition, identifier));
    }

    default public Boolean exists(String partition, IRI identifier) {
        return this.getResolver(identifier).map(resolver -> resolver.exists(partition, identifier)).orElse(false);
    }

    default public void setContent(String partition, IRI identifier, InputStream stream) {
        this.getResolver(identifier).ifPresent(resolver -> resolver.setContent(partition, identifier, stream));
    }

    default public void setContent(String partition, IRI identifier, InputStream stream, Map<String, String> metadata) {
        this.getResolver(identifier).ifPresent(resolver -> resolver.setContent(partition, identifier, stream, metadata));
    }

    default public void purgeContent(String partition, IRI identifier) {
        this.getResolver(identifier).ifPresent(resolver -> resolver.purgeContent(partition, identifier));
    }

    default public Optional<String> calculateDigest(String partition, IRI identifier, String algorithm) {
        return this.getContent(partition, identifier).flatMap(stream -> this.digest(algorithm, (InputStream)stream));
    }

    public Set<String> supportedAlgorithms();

    public Optional<Resolver> getResolver(IRI var1);

    public Optional<Resolver> getResolverForPartition(String var1);

    public Optional<String> digest(String var1, InputStream var2);

    public Supplier<String> getIdentifierSupplier(String var1);

    public static interface Resolver {
        public List<String> getUriSchemes();

        public Optional<InputStream> getContent(String var1, IRI var2);

        public Boolean exists(String var1, IRI var2);

        default public void setContent(String partition, IRI identifier, InputStream stream) {
            this.setContent(partition, identifier, stream, Collections.emptyMap());
        }

        public void setContent(String var1, IRI var2, InputStream var3, Map<String, String> var4);

        public void purgeContent(String var1, IRI var2);

        public Boolean supportsMultipartUpload();

        public String initiateUpload(String var1, IRI var2, String var3);

        public String uploadPart(String var1, Integer var2, InputStream var3);

        public MultipartUpload completeUpload(String var1, Map<Integer, String> var2);

        public void abortUpload(String var1);

        public Boolean uploadSessionExists(String var1);

        public Stream<Map.Entry<Integer, String>> listParts(String var1);
    }

    public static class MultipartUpload {
        private final Binary binary;
        private final String baseUrl;
        private final String path;
        private final Session session;

        public MultipartUpload(String baseUrl, String path, Session session, Binary binary) {
            this.baseUrl = baseUrl;
            this.path = path;
            this.session = session;
            this.binary = binary;
        }

        public Binary getBinary() {
            return this.binary;
        }

        public String getPath() {
            return this.path;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public Session getSession() {
            return this.session;
        }
    }
}

