/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.trellisldp.spi.Session;
import org.trellisldp.vocabulary.AS;
import org.trellisldp.vocabulary.LDP;
import org.trellisldp.vocabulary.PROV;
import org.trellisldp.vocabulary.Trellis;
import org.trellisldp.vocabulary.XSD;

public final class RDFUtils {
    private static RDF rdf = ServiceLoader.load(RDF.class).iterator().next();
    public static final String TRELLIS_PREFIX = "trellis:";
    public static final String TRELLIS_BNODE_PREFIX = "trellis:bnode/";
    public static final Map<IRI, IRI> superClassOf;

    public static RDF getInstance() {
        return rdf;
    }

    public static List<Quad> auditCreation(IRI subject, Session session) {
        return RDFUtils.auditData(subject, session, Arrays.asList(PROV.Activity, AS.Create));
    }

    public static List<Quad> auditDeletion(IRI subject, Session session) {
        return RDFUtils.auditData(subject, session, Arrays.asList(PROV.Activity, AS.Delete));
    }

    public static List<Quad> auditUpdate(IRI subject, Session session) {
        return RDFUtils.auditData(subject, session, Arrays.asList(PROV.Activity, AS.Update));
    }

    private static List<Quad> auditData(IRI subject, Session session, List<IRI> types) {
        ArrayList<Quad> data = new ArrayList<Quad>();
        BlankNode bnode = rdf.createBlankNode();
        data.add(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAudit, (BlankNodeOrIRI)subject, PROV.wasGeneratedBy, (RDFTerm)bnode));
        types.forEach(t -> data.add(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAudit, (BlankNodeOrIRI)bnode, org.trellisldp.vocabulary.RDF.type, (RDFTerm)t)));
        data.add(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAudit, (BlankNodeOrIRI)bnode, PROV.wasAssociatedWith, (RDFTerm)session.getAgent()));
        data.add(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAudit, (BlankNodeOrIRI)bnode, PROV.startedAtTime, (RDFTerm)rdf.createLiteral(session.getCreated().toString(), XSD.dateTime)));
        session.getDelegatedBy().ifPresent(delegate -> data.add(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAudit, (BlankNodeOrIRI)bnode, PROV.actedOnBehalfOf, (RDFTerm)delegate)));
        return data;
    }

    public static Stream<IRI> ldpResourceTypes(IRI interactionModel) {
        return Stream.of(interactionModel).filter(type -> superClassOf.containsKey(type) || LDP.Resource.equals(type)).flatMap(type -> Stream.concat(RDFUtils.ldpResourceTypes(superClassOf.get(type)), Stream.of(type)));
    }

    public static <T extends RDFTerm> T toExternalTerm(T term, String baseUrl) {
        String iri;
        if (term instanceof IRI && (iri = ((IRI)term).getIRIString()).startsWith(TRELLIS_PREFIX)) {
            return (T)rdf.createIRI(baseUrl + iri.substring(TRELLIS_PREFIX.length()));
        }
        return term;
    }

    public static <T extends RDFTerm> T toInternalTerm(T term, String baseUrl) {
        String iri;
        if (term instanceof IRI && (iri = ((IRI)term).getIRIString()).startsWith(baseUrl)) {
            return (T)rdf.createIRI(TRELLIS_PREFIX + iri.substring(baseUrl.length()));
        }
        return term;
    }

    public static String cleanIdentifier(String identifier) {
        String id = identifier.split("#")[0].split("\\?")[0];
        if (id.endsWith("/")) {
            return id.substring(0, id.length() - 1);
        }
        return id;
    }

    public static IRI cleanIdentifier(IRI identifier) {
        return rdf.createIRI(RDFUtils.cleanIdentifier(identifier.getIRIString()));
    }

    private RDFUtils() {
    }

    static {
        HashMap<IRI, IRI> data = new HashMap<IRI, IRI>();
        data.put(LDP.NonRDFSource, LDP.Resource);
        data.put(LDP.RDFSource, LDP.Resource);
        data.put(LDP.Container, LDP.RDFSource);
        data.put(LDP.BasicContainer, LDP.Container);
        data.put(LDP.DirectContainer, LDP.Container);
        data.put(LDP.IndirectContainer, LDP.Container);
        superClassOf = Collections.unmodifiableMap(data);
    }
}

