/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.test;

import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.RDFSyntax;
import org.apache.commons.rdf.api.RDFTerm;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.platform.runner.JUnitPlatform;
import org.junit.runner.RunWith;
import org.trellisldp.test.BaseCommonTests;
import org.trellisldp.vocabulary.AS;
import org.trellisldp.vocabulary.LDP;
import org.trellisldp.vocabulary.PROV;
import org.trellisldp.vocabulary.RDF;
import org.trellisldp.vocabulary.Trellis;

@RunWith(value=JUnitPlatform.class)
public class AuditTests
extends BaseCommonTests {
    private static String container;
    private static String resource;
    private static String JWT_SECRET;

    protected static void setUp() {
        String jwt = AuditTests.buildJwt(Trellis.AdministratorAgent.getIRIString(), JWT_SECRET);
        String user1 = AuditTests.buildJwt("https://people.apache.org/~acoburn/#i", JWT_SECRET);
        String user2 = AuditTests.buildJwt("https://madison.example.com/profile#me", JWT_SECRET);
        String containerContent = AuditTests.getResourceAsString("/basicContainer.ttl");
        try (Response res = AuditTests.target().request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).header("Authorization", (Object)jwt).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            container = res.getLocation().toString();
        }
        res = AuditTests.target(container).request().header("Authorization", (Object)jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));
        var5_5 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            resource = res.getLocation().toString();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuditTests.$closeResource(var5_5, (AutoCloseable)res);
            }
        }
        res = AuditTests.target(resource).request().header("Authorization", (Object)user1).method("PATCH", Entity.entity((Object)"INSERT { <> <http://purl.org/dc/terms/title> \"A title\" } WHERE {}", (String)"application/sparql-update"));
        var5_5 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuditTests.$closeResource(var5_5, (AutoCloseable)res);
            }
        }
        res = AuditTests.target(resource).request().header("Authorization", (Object)user2).method("PATCH", Entity.entity((Object)"INSERT { <> <http://www.w3.org/2004/02/skos/core#prefLabel> \"Label\" } WHERE {}", (String)"application/sparql-update"));
        var5_5 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuditTests.$closeResource(var5_5, (AutoCloseable)res);
            }
        }
    }

    @Test
    @DisplayName(value="Check the absense of audit triples.")
    public void testNoAuditTriples() {
        try (Response res = AuditTests.target(resource).request().get();){
            Graph g = this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
            Assertions.assertEquals((long)2L, (long)g.size());
        }
    }

    @Test
    @DisplayName(value="Check the explicit absense of audit triples.")
    public void testOmitAuditTriples() {
        try (Response res = AuditTests.target(resource).request().header("Prefer", (Object)("return=representation; omit=\"" + Trellis.PreferAudit.getIRIString() + "\"")).get();){
            Graph g = this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
            Assertions.assertEquals((long)2L, (long)g.size());
        }
    }

    @Test
    @DisplayName(value="Check the presence of audit triples.")
    public void testAuditTriples() {
        try (Response res = AuditTests.target(resource).request().header("Prefer", (Object)("return=representation; include=\"" + Trellis.PreferAudit.getIRIString() + "\"")).get();){
            Graph g = this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
            Assertions.assertEquals((long)3L, (long)g.stream((BlankNodeOrIRI)rdf.createIRI(resource), PROV.wasGeneratedBy, null).count());
            g.stream((BlankNodeOrIRI)rdf.createIRI(resource), PROV.wasGeneratedBy, null).forEach(triple -> {
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)triple.getObject(), RDF.type, (RDFTerm)PROV.Activity));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)triple.getObject(), PROV.atTime, null));
                Assertions.assertEquals((long)4L, (long)g.stream((BlankNodeOrIRI)triple.getObject(), null, null).count());
            });
            Assertions.assertTrue((boolean)g.contains(null, PROV.wasAssociatedWith, (RDFTerm)Trellis.AdministratorAgent));
            Assertions.assertTrue((boolean)g.contains(null, PROV.wasAssociatedWith, (RDFTerm)rdf.createIRI("https://madison.example.com/profile#me")));
            Assertions.assertTrue((boolean)g.contains(null, PROV.wasAssociatedWith, (RDFTerm)rdf.createIRI("https://people.apache.org/~acoburn/#i")));
            Assertions.assertEquals((long)2L, (long)g.stream(null, RDF.type, (RDFTerm)AS.Update).count());
            Assertions.assertEquals((long)1L, (long)g.stream(null, RDF.type, (RDFTerm)AS.Create).count());
            Assertions.assertEquals((long)17L, (long)g.size());
        }
    }

    static {
        JWT_SECRET = "secret";
    }
}

