/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.test;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.platform.runner.JUnitPlatform;
import org.junit.runner.RunWith;
import org.trellisldp.test.BaseCommonTests;
import org.trellisldp.vocabulary.LDP;
import org.trellisldp.vocabulary.Trellis;

@RunWith(value=JUnitPlatform.class)
public class AuthorizationTests
extends BaseCommonTests {
    private static final String JWT_SECRET = "secret";
    private static final String ACL = "acl";
    private static final String PATCH = "PATCH";
    private static final String EXT_ACL = "?ext=acl";
    private static final String INSERT_PROP_FOO = "INSERT { <> <http://example.com/prop> \"Foo\" } WHERE {}";
    private static final String INSERT_PROP_BAR = "INSERT { <> <http://example.com/prop> \"Bar\" } WHERE {}";
    private static final String PREFIX_ACL = "PREFIX acl: <http://www.w3.org/ns/auth/acl#>\n\n";
    private static String container;
    private static String publicContainer;
    private static String publicContainerAcl;
    private static String publicContainerChild;
    private static String protectedContainer;
    private static String protectedContainerAcl;
    private static String protectedContainerChild;
    private static String privateContainer;
    private static String privateContainerAcl;
    private static String privateContainerChild;
    private static String groupContainer;
    private static String groupContainerAcl;
    private static String groupContainerChild;
    private static String defaultContainer;
    private static String defaultContainerAcl;
    private static String defaultContainerChild;
    private static String groupResource;

    protected static void setUp() {
        String jwt = AuthorizationTests.buildJwt(Trellis.AdministratorAgent.getIRIString(), JWT_SECRET);
        String containerContent = AuthorizationTests.getResourceAsString("/basicContainer.ttl");
        try (Response res = AuthorizationTests.target().request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).header("Authorization", (Object)jwt).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            container = res.getLocation().toString();
        }
        res = AuthorizationTests.target(container).request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).header("Authorization", (Object)jwt).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));
        var3_3 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            publicContainer = res.getLocation().toString();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuthorizationTests.$closeResource(var3_3, (AutoCloseable)res);
            }
        }
        res = AuthorizationTests.target(publicContainer).request().header("Authorization", (Object)jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));
        var3_3 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            publicContainerChild = res.getLocation().toString();
            publicContainerAcl = AuthorizationTests.getLinks(res).stream().filter(link -> link.getRel().equals(ACL)).map(link -> link.getUri().toString()).findFirst().orElse("");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuthorizationTests.$closeResource(var3_3, (AutoCloseable)res);
            }
        }
        String publicAcl = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX acl: <http://www.w3.org/ns/auth/acl#>\n\nINSERT DATA { [acl:accessTo <" + publicContainer + ">; acl:mode acl:Read;    acl:agentClass foaf:Agent ] }; \n" + PREFIX_ACL + "INSERT DATA { [acl:accessTo <" + publicContainer + ">; acl:mode acl:Read, acl:Write;   acl:agentClass acl:AuthenticatedAgent ] }";
        try (Response res = AuthorizationTests.target(publicContainerAcl).request().header("Authorization", (Object)jwt).method(PATCH, Entity.entity((Object)publicAcl, (String)"application/sparql-update"));){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
        }
        res = AuthorizationTests.target(container).request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).header("Authorization", (Object)jwt).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));
        var4_7 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            protectedContainer = res.getLocation().toString();
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuthorizationTests.$closeResource(var4_7, (AutoCloseable)res);
            }
        }
        res = AuthorizationTests.target(protectedContainer).request().header("Authorization", (Object)jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));
        var4_7 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            protectedContainerChild = res.getLocation().toString();
            protectedContainerAcl = AuthorizationTests.getLinks(res).stream().filter(link -> link.getRel().equals(ACL)).map(link -> link.getUri().toString()).findFirst().orElse("");
        }
        catch (Throwable throwable) {
            var4_7 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuthorizationTests.$closeResource(var4_7, (AutoCloseable)res);
            }
        }
        String protectedAcl = "PREFIX acl: <http://www.w3.org/ns/auth/acl#>\n\nINSERT DATA { \n[acl:accessTo  <" + protectedContainer + ">;  acl:mode acl:Read, acl:Write;   acl:agent <https://people.apache.org/~acoburn/#i> ] };" + PREFIX_ACL + "INSERT DATA { \n[acl:accessTo  <" + protectedContainer + ">; acl:mode acl:Read, acl:Append;    acl:agent <https://madison.example.com/profile/#me> ] }";
        try (Response res = AuthorizationTests.target(protectedContainerAcl).request().header("Authorization", (Object)jwt).method(PATCH, Entity.entity((Object)protectedAcl, (String)"application/sparql-update"));){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
        }
        res = AuthorizationTests.target(container).request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).header("Authorization", (Object)jwt).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));
        var5_12 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            privateContainer = res.getLocation().toString();
        }
        catch (Throwable throwable) {
            var5_12 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuthorizationTests.$closeResource(var5_12, (AutoCloseable)res);
            }
        }
        res = AuthorizationTests.target(privateContainer).request().header("Authorization", (Object)jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));
        var5_12 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            privateContainerChild = res.getLocation().toString();
            privateContainerAcl = AuthorizationTests.getLinks(res).stream().filter(link -> link.getRel().equals(ACL)).map(link -> link.getUri().toString()).findFirst().orElse("");
        }
        catch (Throwable throwable) {
            var5_12 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuthorizationTests.$closeResource(var5_12, (AutoCloseable)res);
            }
        }
        String privateAcl = "PREFIX acl: <http://www.w3.org/ns/auth/acl#>\n\nINSERT DATA { [acl:accessTo  <" + privateContainer + ">; acl:mode acl:Read, acl:Write;    acl:agent <http://example.com/administrator> ] }";
        try (Response res = AuthorizationTests.target(privateContainerAcl).request().header("Authorization", (Object)jwt).method(PATCH, Entity.entity((Object)privateAcl, (String)"application/sparql-update"));){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
        }
        String groupContent = "@prefix acl: <http://www.w3.org/ns/auth/acl#>.\n@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .\n<> a acl:GroupListing.\n<#Developers> a vcard:Group;\n  vcard:hasUID <urn:uuid:8831CBAD-1111-2222-8563-F0F4787E5398:ABGroup>;\n  vcard:hasMember <https://pat.example.com/profile/card#me>;\n  vcard:hasMember <https://people.apache.org/~acoburn/#i>.\n<#Management> a vcard:Group;\n  vcard:hasUID <urn:uuid:8831CBAD-3333-4444-8563-F0F4787E5398:ABGroup>;\n  vcard:hasMember <https://madison.example.com/profile/#me>.";
        try (Response res = AuthorizationTests.target(container).request().header("Authorization", (Object)jwt).post(Entity.entity((Object)"@prefix acl: <http://www.w3.org/ns/auth/acl#>.\n@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .\n<> a acl:GroupListing.\n<#Developers> a vcard:Group;\n  vcard:hasUID <urn:uuid:8831CBAD-1111-2222-8563-F0F4787E5398:ABGroup>;\n  vcard:hasMember <https://pat.example.com/profile/card#me>;\n  vcard:hasMember <https://people.apache.org/~acoburn/#i>.\n<#Management> a vcard:Group;\n  vcard:hasUID <urn:uuid:8831CBAD-3333-4444-8563-F0F4787E5398:ABGroup>;\n  vcard:hasMember <https://madison.example.com/profile/#me>.", (String)"text/turtle;charset=utf-8"));){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            groupResource = res.getLocation().toString();
        }
        res = AuthorizationTests.target(container).request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).header("Authorization", (Object)jwt).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));
        var7_20 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            groupContainer = res.getLocation().toString();
        }
        catch (Throwable throwable) {
            var7_20 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuthorizationTests.$closeResource(var7_20, (AutoCloseable)res);
            }
        }
        res = AuthorizationTests.target(groupContainer).request().header("Authorization", (Object)jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));
        var7_20 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            groupContainerChild = res.getLocation().toString();
            groupContainerAcl = AuthorizationTests.getLinks(res).stream().filter(link -> link.getRel().equals(ACL)).map(link -> link.getUri().toString()).findFirst().orElse("");
        }
        catch (Throwable throwable) {
            var7_20 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuthorizationTests.$closeResource(var7_20, (AutoCloseable)res);
            }
        }
        String groupAcl = "PREFIX acl: <http://www.w3.org/ns/auth/acl#>\n\nINSERT DATA {  [acl:accessTo <" + groupContainer + ">; acl:mode acl:Read, acl:Write;  acl:agentGroup <" + groupResource + "#Developers> ] };\n" + PREFIX_ACL + "INSERT DATA {  [acl:accessTo <" + groupContainer + ">; acl:mode acl:Read;  acl:agentGroup <" + groupResource + "#Management> ] }";
        try (Response res = AuthorizationTests.target(groupContainerAcl).request().header("Authorization", (Object)jwt).method(PATCH, Entity.entity((Object)groupAcl, (String)"application/sparql-update"));){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
        }
        res = AuthorizationTests.target(container).request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).header("Authorization", (Object)jwt).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));
        var8_25 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            defaultContainer = res.getLocation().toString();
        }
        catch (Throwable throwable) {
            var8_25 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuthorizationTests.$closeResource(var8_25, (AutoCloseable)res);
            }
        }
        res = AuthorizationTests.target(defaultContainer).request().header("Authorization", (Object)jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));
        var8_25 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            defaultContainerChild = res.getLocation().toString();
            defaultContainerAcl = AuthorizationTests.getLinks(res).stream().filter(link -> link.getRel().equals(ACL)).map(link -> link.getUri().toString()).findFirst().orElse("");
        }
        catch (Throwable throwable) {
            var8_25 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                AuthorizationTests.$closeResource(var8_25, (AutoCloseable)res);
            }
        }
        String defaultAcl = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX acl: <http://www.w3.org/ns/auth/acl#>\n\nINSERT DATA {  [acl:accessTo <" + defaultContainer + ">; acl:mode acl:Read; acl:agentClass foaf:Agent ] }; \n" + PREFIX_ACL + "INSERT DATA { [acl:accessTo <" + defaultContainer + ">; acl:mode acl:Read, acl:Write; \n   acl:default <" + defaultContainer + ">; \n   acl:agent <https://people.apache.org/~acoburn/#i> ] }";
        try (Response res = AuthorizationTests.target(defaultContainerAcl).request().header("Authorization", (Object)jwt).method(PATCH, Entity.entity((Object)defaultAcl, (String)"application/sparql-update"));){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
        }
    }

    @Test
    public void testPublicLinkHeader() {
        Assertions.assertEquals((Object)(publicContainer + EXT_ACL), (Object)publicContainerAcl);
    }

    @Test
    public void testProtectedLinkHeader() {
        Assertions.assertEquals((Object)(protectedContainer + EXT_ACL), (Object)protectedContainerAcl);
    }

    @Test
    public void testPrivateLinkHeader() {
        Assertions.assertEquals((Object)(privateContainer + EXT_ACL), (Object)privateContainerAcl);
    }

    @Nested
    @DisplayName(value="Anonymous tests")
    public class AnonymousTests {
        @Test
        @DisplayName(value="Verify that an anonymous user can read a public resource")
        public void testCanReadPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user can read the child of a public resource")
        public void testCanReadPublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot append to a public resource")
        public void testUserCanAppendPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot write to a public resource")
        public void testCanWritePublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot write to the child of a public resource")
        public void testCanWritePublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild).request().method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot control a public resource")
        public void testCanControlPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainerAcl).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot control the child of a public resource")
        public void testCanControlPublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild + AuthorizationTests.EXT_ACL).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot read a protected resource")
        public void testCanReadProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot read the child of a protected resource")
        public void testCanReadProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot append to a protected resource")
        public void testUserCanAppendProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot write to a protected resource")
        public void testCanWriteProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot write to the child of a protected resource")
        public void testCanWriteProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild).request().method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot control a protected resource")
        public void testCanControlProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainerAcl).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot control the child of a protected resource")
        public void testCanControlProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild + AuthorizationTests.EXT_ACL).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot read a private resource")
        public void testCanReadPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot read the child of a private resource")
        public void testCanReadPrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot append to a private resource")
        public void testUserCanAppendPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot write to a private resource")
        public void testCanWritePrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot write to the child of a private resource")
        public void testCanWritePrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild).request().method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot control a private resource")
        public void testCanControlPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainerAcl).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot control the child of a private resource")
        public void testCanControlPrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild + AuthorizationTests.EXT_ACL).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot read a group-controlled resource")
        public void testCanReadGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot read the child of a group-controlled resource")
        public void testCanReadGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot append to a group-controlled resource")
        public void testUserCanAppendGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot write to a group-controlled resource")
        public void testCanWriteGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot write to the child of a group-controlled resource")
        public void testCanWriteGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild).request().method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot control a group-controlled resource")
        public void testCanControlGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainerAcl).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot control the child of a group-controlled resource")
        public void testCanControlGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild + AuthorizationTests.EXT_ACL).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user can read a default ACL resource")
        public void testCanReadDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot read the child of a default ACL resource")
        public void testCanReadDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot append to a default ACL resource")
        public void testUserCanAppendDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot write to a default ACL resource")
        public void testCanWriteDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an anonymous user cannot write to the child of a default ACL resource")
        public void testCanWriteDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild).request().method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a default ACL resource")
        public void testCanControlDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainerAcl).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a default ACL resource")
        public void testCanControlDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild + AuthorizationTests.EXT_ACL).request().get();){
                Assertions.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }
    }

    @Nested
    @DisplayName(value="Jwt Other user tests")
    public class JwtOtherUserTests {
        private final String jwt = BaseCommonTests.buildJwt("https://madison.example.com/profile/#me", "secret");

        @Test
        @DisplayName(value="Verify that a user can read a public resource")
        public void testUserCanReadPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a public resource")
        public void testUserCanReadPublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can append to a public resource")
        public void testUserCanAppendPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to a public resource")
        public void testUserCanWritePublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to the child of a public resource")
        public void testUserCanWritePublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a public resource")
        public void testUserCanControlPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a public resource")
        public void testUserCanControlPublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read a protected resource")
        public void testUserCanReadProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a protected resource")
        public void testUserCanReadProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can append to a protected resource")
        public void testUserCanAppendProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to a protected resource")
        public void testUserCanWriteProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to the child of a protected resource")
        public void testUserCanWriteProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a protected resource")
        public void testUserCanControlProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a protected resource")
        public void testUserCanControlProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot read a private resource")
        public void testUserCanReadPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot read the child of a private resource")
        public void testUserCanReadPrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot append to a private resource")
        public void testUserCanAppendPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to a private resource")
        public void testUserCanWritePrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to the child of a private resource")
        public void testUserCanWritePrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a private resource")
        public void testUserCanControlPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a private resource")
        public void testUserCanControlPrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read a group-controlled resource")
        public void testCanReadGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a group-controlled resource")
        public void testCanReadGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot append to a group-controlled resource")
        public void testUserCanAppendGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().header("Authorization", (Object)this.jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to a group-controlled resource")
        public void testCanWriteGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to the child of a group-controlled resource")
        public void testCanWriteGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a group-controlled resource")
        public void testCanControlGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a group-controlled resource")
        public void testCanControlGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read a default ACL resource")
        public void testCanReadDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot read the child of a default ACL resource")
        public void testCanReadDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot append to a group-controlled resource")
        public void testUserCanAppendDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().header("Authorization", (Object)this.jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to a default ACL resource")
        public void testCanWriteDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to the child of a default ACL resource")
        public void testCanWriteDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a default ACL resource")
        public void testCanControlDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a default ACL resource")
        public void testCanControlDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }
    }

    @Nested
    @DisplayName(value="Basic Auth other user tests")
    public class BasicAuthOtherUserTests {
        private final String auth = "Basic " + Base64.encodeBase64String((byte[])"user:password".getBytes(StandardCharsets.UTF_8));

        @Test
        @DisplayName(value="Verify that a user can read a public resource")
        public void testUserCanReadPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a public resource")
        public void testUserCanReadPublicResourceChile() {
            try (Response res = BaseCommonTests.target(publicContainerChild).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can append to a public resource")
        public void testUserCanAppendPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.auth).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to a public resource")
        public void testUserCanWritePublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to the child of a public resource")
        public void testUserCanWritePublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a public resource")
        public void testUserCanControlPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a public resource")
        public void testUserCanControlPublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read a protected resource")
        public void testUserCanReadProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a protected resource")
        public void testUserCanReadProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can append to a public resource")
        public void testUserCanAppendProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.auth).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to a protected resource")
        public void testUserCanWriteProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to the child of a protected resource")
        public void testUserCanWriteProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a protected resource")
        public void testUserCanControlProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainerAcl).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a protected resource")
        public void testUserCanControlProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot read a private resource")
        public void testUserCanReadPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot read the child of a private resource")
        public void testUserCanReadPrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot append to a private resource")
        public void testUserCanAppendPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.auth).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to a private resource")
        public void testUserCanWritePrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to the child of a private resource")
        public void testUserCanWritePrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a private resource")
        public void testUserCanControlPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainerAcl).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a private resource")
        public void testUserCanControlPrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read a group-controlled resource")
        public void testCanReadGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a group-controlled resource")
        public void testCanReadGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot append to a group-controlled resource")
        public void testUserCanAppendGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().header("Authorization", (Object)this.auth).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to a group-controlled resource")
        public void testCanWriteGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to the child of a group-controlled resource")
        public void testCanWriteGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a group-controlled resource")
        public void testCanControlGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainerAcl).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a group-controlled resource")
        public void testCanControlGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read a default ACL resource")
        public void testCanReadDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot read the child of a default ACL resource")
        public void testCanReadDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot append to a default ACL resource")
        public void testUserCanAppendDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().header("Authorization", (Object)this.auth).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to a default ACL resource")
        public void testCanWriteDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to the child of a default ACL resource")
        public void testCanWriteDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a default ACL resource")
        public void testCanControlDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainerAcl).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a default ACL resource")
        public void testCanControlDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }
    }

    @Nested
    @DisplayName(value="Jwt User tests")
    public class JwtUserTests {
        private final String jwt = BaseCommonTests.buildJwt("https://people.apache.org/~acoburn/#i", "secret");

        @Test
        @DisplayName(value="Verify that a user can read a public resource")
        public void testUserCanReadPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a public resource")
        public void testUserCanReadPublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can append to a public resource")
        public void testUserCanAppendPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to a public resource")
        public void testUserCanWritePublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to the child of a public resource")
        public void testUserCanWritePublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a public resource")
        public void testUserCanControlPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a public resource")
        public void testUserCanControlPublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read a protected resource")
        public void testUserCanReadProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a protected resource")
        public void testUserCanReadProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can append to a protected resource")
        public void testUserCanAppendProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to a protected resource")
        public void testUserCanWriteProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to the child of a protected resource")
        public void testUserCanWriteProtectedResourceChile() {
            try (Response res = BaseCommonTests.target(protectedContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a protected resource")
        public void testUserCanControlProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a protected resource")
        public void testUserCanControlProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot read a private resource")
        public void testUserCanReadPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot read the child of a private resource")
        public void testUserCanReadPrivateResourceChile() {
            try (Response res = BaseCommonTests.target(privateContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot append to a private resource")
        public void testUserCanAppendPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to a private resource")
        public void testUserCanWritePrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to the child of a private resource")
        public void testUserCanWritePrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a private resource")
        public void testUserCanControlPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a private resource")
        public void testUserCanControlPrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read a group-controlled resource")
        public void testCanReadGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a group-controlled resource")
        public void testCanReadGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to a group-controlled resource")
        public void testCanWriteGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to the child of a group-controlled resource")
        public void testCanWriteGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a group-controlled resource")
        public void testCanControlGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a group-controlled resource")
        public void testCanControlGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read a default ACL resource")
        public void testCanReadDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a default ACL resource")
        public void testCanReadDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to a default ACL resource")
        public void testCanWriteDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to the child of a default ACL resource")
        public void testCanWriteDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a default ACL resource")
        public void testCanControlDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a default ACL resource")
        public void testCanControlDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }
    }

    @Nested
    @DisplayName(value="Basic Auth User tests")
    public class BasicAuthUserTests {
        private final String auth = "Basic " + Base64.encodeBase64String((byte[])"acoburn:secret".getBytes());

        @Test
        @DisplayName(value="Verify that a user can read a public resource")
        public void testUserCanReadPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a public resource")
        public void testUserCanReadPublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can append to a public resource")
        public void testUserCanAppendPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.auth).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to a public resource")
        public void testUserCanWritePublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to the child of a public resource")
        public void testUserCanWritePublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a public resource")
        public void testUserCanControlPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a public resource")
        public void testUserCanControlPublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read a protected resource")
        public void testUserCanReadProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a protected resource")
        public void testUserCanReadProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can append to a protected resource")
        public void testUserCanAppendProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.auth).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to a protected resource")
        public void testUserCanWriteProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to the child of a protected resource")
        public void testUserCanWriteProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_BAR, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a protected resource")
        public void testUserCanControlProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainerAcl).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a protected resource")
        public void testUserCanControlProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot read a private resource")
        public void testUserCanReadPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot read the child of a private resource")
        public void testUserCanReadPrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot append to a private resource")
        public void testUserCanAppendPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.auth).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to a private resource")
        public void testUserCanWritePrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot write to the child of a private resource")
        public void testUserCanWritePrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a private resource")
        public void testUserCanControlPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a private resource")
        public void testUserCanControlPrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read a group-controlled resource")
        public void testCanReadGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a group-controlled resource")
        public void testCanReadGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to a group-controlled resource")
        public void testCanWriteGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to the child of a group-controlled resource")
        public void testCanWriteGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a group-controlled resource")
        public void testCanControlGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainerAcl).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a group-controlled resource")
        public void testCanControlGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read a default ACL resource")
        public void testCanReadDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can read the child of a default ACL resource")
        public void testCanReadDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to a default ACL resource")
        public void testCanWriteDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user can write to the child of a default ACL resource")
        public void testCanWriteDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild).request().header("Authorization", (Object)this.auth).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control a default ACL resource")
        public void testCanControlDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainerAcl).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that a user cannot control the child of a default ACL resource")
        public void testCanControlDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.auth).get();){
                Assertions.assertEquals((Object)Response.Status.FORBIDDEN, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }
    }

    @Nested
    @DisplayName(value="Jwt Administrator tests")
    public class JwtAdministratorTests {
        private final String jwt = "Bearer " + Jwts.builder().claim("webid", (Object)Trellis.AdministratorAgent.getIRIString()).signWith(SignatureAlgorithm.HS512, "secret".getBytes(StandardCharsets.UTF_8)).compact();

        @Test
        @DisplayName(value="Verify that an administrator can read a public resource")
        public void testAdminCanReadPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can read the child of a public resource")
        public void testAdminCanReadPublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can write to a public resource")
        public void testAdminCanWritePublicResource() {
            try (Response res = BaseCommonTests.target(publicContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can write to the child of a public resource")
        public void testAdminCanWritePublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can control a public resource")
        public void testAdminCanControlPublicResource() {
            try (Response res = BaseCommonTests.target(publicContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can control the child of a public resource")
        public void testAdminCanControlPublicResourceChild() {
            try (Response res = BaseCommonTests.target(publicContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.NOT_FOUND, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can read a protected resource")
        public void testAdminCanReadProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can read the child of a protected resource")
        public void testAdminCanReadProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can write to a protected resource")
        public void testAdminCanWriteProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can write to the child of a protected resource")
        public void testAdminCanWriteProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can control a protected resource")
        public void testAdminCanControlProtectedResource() {
            try (Response res = BaseCommonTests.target(protectedContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can control the child of a protected resource")
        public void testAdminCanControlProtectedResourceChild() {
            try (Response res = BaseCommonTests.target(protectedContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.NOT_FOUND, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can read a private resource")
        public void testAdminCanReadPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can read the child of a private resource")
        public void testAdminCanReadPrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can write to a private resource")
        public void testAdminCanWritePrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can write to the child of a private resource")
        public void testAdminCanWritePrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can control a private resource")
        public void testAdminCanControlPrivateResource() {
            try (Response res = BaseCommonTests.target(privateContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can control the child of a private resource")
        public void testAdminCanControlPrivateResourceChild() {
            try (Response res = BaseCommonTests.target(privateContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.NOT_FOUND, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can read a group-controlled resource")
        public void testAdminCanReadGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can read the child of a group-controlled resource")
        public void testAdminCanReadGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can write to a group-controlled resource")
        public void testAdminCanWriteGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can write to the child of a group-controlled resource")
        public void testAdminCanWriteGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can control a group-controlled resource")
        public void testAdminCanControlGroupResource() {
            try (Response res = BaseCommonTests.target(groupContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can't find the ACL of a child resource")
        public void testAdminCanControlGroupResourceChild() {
            try (Response res = BaseCommonTests.target(groupContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.NOT_FOUND, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can read a default ACL resource")
        public void testCanReadDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can read the child of a default ACL resource")
        public void testCanReadDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can write to a default ACL resource")
        public void testCanWriteDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainer).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can write to the child of a default ACL resource")
        public void testCanWriteDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild).request().header("Authorization", (Object)this.jwt).method(AuthorizationTests.PATCH, Entity.entity((Object)AuthorizationTests.INSERT_PROP_FOO, (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can control a default ACL resource")
        public void testCanControlDefaultAclResource() {
            try (Response res = BaseCommonTests.target(defaultContainerAcl).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Verify that an administrator can't find the ACL resource")
        public void testCanControlDefaultAclResourceChild() {
            try (Response res = BaseCommonTests.target(defaultContainerChild + AuthorizationTests.EXT_ACL).request().header("Authorization", (Object)this.jwt).get();){
                Assertions.assertEquals((Object)Response.Status.NOT_FOUND, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }
    }
}

