/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.test;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFSyntax;
import org.apache.commons.rdf.jena.JenaRDF;
import org.trellisldp.api.IOService;
import org.trellisldp.api.NamespaceService;
import org.trellisldp.io.JenaIOService;
import org.trellisldp.namespaces.NamespacesJsonContext;
import org.trellisldp.vocabulary.LDP;

class BaseCommonTests {
    protected static final String PATCH = "PATCH";
    private static String BASE_URL = null;
    private static Client CLIENT = null;
    private final IOService IO_SVC = new JenaIOService((NamespaceService)new NamespacesJsonContext(this.getResourcePath("/data/namespaces.json")), null, Collections.emptyMap());
    protected static final RDF rdf = new JenaRDF();

    BaseCommonTests() {
    }

    protected static void setUp() throws Exception {
    }

    protected static void tearDown() throws Exception {
    }

    protected static void setBaseUrl(String baseUrl) {
        Objects.requireNonNull(baseUrl, "baseUrl may not be null!");
        BASE_URL = baseUrl;
    }

    protected static void setClient(Client client) {
        Objects.requireNonNull(client, "client may not be null!");
        CLIENT = client;
        CLIENT.property("jersey.config.client.connectTimeout", (Object)5000);
        CLIENT.property("jersey.config.client.readTimeout", (Object)5000);
    }

    protected static Client getClient() {
        Objects.requireNonNull(CLIENT, "HTTP Client has not been initialized!");
        return CLIENT;
    }

    protected static String getBaseUrl() {
        Objects.requireNonNull(BASE_URL, "BaseUrl has not been initialized!");
        return BASE_URL;
    }

    protected static WebTarget target() {
        return BaseCommonTests.target(BaseCommonTests.getBaseUrl());
    }

    protected static WebTarget target(String url) {
        return BaseCommonTests.getClient().target(url);
    }

    protected static List<Link> getLinks(Response res) {
        return ((List)res.getStringHeaders().get((Object)"Link")).stream().map(Link::valueOf).collect(Collectors.toList());
    }

    protected String getResourcePath(String path) {
        try {
            return new File(BaseCommonTests.class.getResource(path).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static String getResourceAsString(String path) {
        try {
            return IOUtils.toString((InputStream)BaseCommonTests.class.getResourceAsStream(path), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected Predicate<Link> hasConstrainedBy(IRI iri) {
        return link -> LDP.constrainedBy.getIRIString().equals(link.getRel()) && iri.getIRIString().equals(link.getUri().toString());
    }

    protected Predicate<Link> hasType(IRI iri) {
        return link -> "type".equals(link.getRel()) && iri.getIRIString().equals(link.getUri().toString());
    }

    protected Graph readEntityAsGraph(Object entity, RDFSyntax syntax) {
        Graph g = rdf.createGraph();
        this.IO_SVC.read((InputStream)entity, BaseCommonTests.getBaseUrl(), syntax).forEach(arg_0 -> ((Graph)g).add(arg_0));
        return g;
    }

    protected static String readEntityAsString(Object entity) {
        try {
            return IOUtils.toString((InputStream)((InputStream)entity), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected static String buildJwt(String webid, String secret) {
        return "Bearer " + Jwts.builder().claim("webid", (Object)webid).signWith(SignatureAlgorithm.HS512, secret.getBytes(StandardCharsets.UTF_8)).compact();
    }
}

