/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.test;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFSyntax;
import org.apache.commons.rdf.api.RDFTerm;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.platform.runner.JUnitPlatform;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trellisldp.test.BaseCommonTests;
import org.trellisldp.vocabulary.AS;
import org.trellisldp.vocabulary.LDP;
import org.trellisldp.vocabulary.PROV;
import org.trellisldp.vocabulary.RDF;
import org.trellisldp.vocabulary.Trellis;

@RunWith(value=JUnitPlatform.class)
public class EventTests
extends BaseCommonTests
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventTests.class);
    private static String container;
    private static String JWT_SECRET;
    private final Set<Message> messages = new CopyOnWriteArraySet<Message>();
    private MessageConsumer consumer;
    private Connection connection;

    protected static void setUp() throws Exception {
        String jwt = EventTests.buildJwt(Trellis.AdministratorAgent.getIRIString(), JWT_SECRET);
        String containerContent = EventTests.getResourceAsString("/basicContainer.ttl");
        try (Response res = EventTests.target().request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).header("Authorization", (Object)jwt).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            container = res.getLocation().toString();
        }
    }

    @BeforeEach
    public void aquireConnection() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        this.connection = connectionFactory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue destination = session.createQueue("trellis");
        this.consumer = session.createConsumer((Destination)destination);
        this.consumer.setMessageListener((MessageListener)this);
    }

    @AfterEach
    public void releaseConnection() throws Exception {
        this.consumer.setMessageListener(msg -> {});
        this.consumer.close();
        this.connection.close();
    }

    @Test
    @DisplayName(value="Test receiving a JMS creation message")
    public void testReceiveCreateMessage() {
        IRI obj = rdf.createIRI(container);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> this.messages.stream().map(this::convertToGraph).filter(g -> g.contains((BlankNodeOrIRI)obj, RDF.type, null)).anyMatch(g -> g.contains(null, AS.object, (RDFTerm)obj) && g.contains(null, AS.actor, (RDFTerm)Trellis.AdministratorAgent) && g.contains(null, RDF.type, (RDFTerm)PROV.Activity) && g.contains(null, RDF.type, (RDFTerm)AS.Create) && g.contains((BlankNodeOrIRI)obj, RDF.type, (RDFTerm)LDP.BasicContainer)));
    }

    @Test
    @DisplayName(value="Test receiving an update message")
    public void testReceiveChildMessage() {
        String resource;
        String agent = "https://people.apache.org/~acoburn/#i";
        String jwt = EventTests.buildJwt("https://people.apache.org/~acoburn/#i", JWT_SECRET);
        try (Response res = EventTests.target(container).request().header("Authorization", (Object)jwt).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            resource = res.getLocation().toString();
        }
        IRI obj = rdf.createIRI(resource);
        IRI parent = rdf.createIRI(container);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> this.messages.stream().map(this::convertToGraph).filter(g -> g.contains((BlankNodeOrIRI)obj, RDF.type, null)).anyMatch(g -> g.contains(null, AS.object, (RDFTerm)obj) && g.contains(null, AS.actor, (RDFTerm)rdf.createIRI("https://people.apache.org/~acoburn/#i")) && g.contains(null, RDF.type, (RDFTerm)PROV.Activity) && g.contains(null, RDF.type, (RDFTerm)AS.Create) && g.contains((BlankNodeOrIRI)obj, RDF.type, (RDFTerm)LDP.RDFSource)));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> this.messages.stream().map(this::convertToGraph).filter(g -> g.contains((BlankNodeOrIRI)parent, RDF.type, null)).anyMatch(g -> g.contains(null, AS.object, (RDFTerm)parent) && g.contains(null, AS.actor, (RDFTerm)rdf.createIRI("https://people.apache.org/~acoburn/#i")) && g.contains(null, RDF.type, (RDFTerm)PROV.Activity) && g.contains(null, RDF.type, (RDFTerm)AS.Update) && g.contains((BlankNodeOrIRI)parent, RDF.type, (RDFTerm)LDP.BasicContainer)));
    }

    @Test
    @DisplayName(value="Test receiving a delete message")
    public void testReceiveDeleteMessage() {
        String resource;
        String agent1 = "https://madison.example.com/profile#me";
        String jwt1 = EventTests.buildJwt("https://madison.example.com/profile#me", JWT_SECRET);
        try (Response res = EventTests.target(container).request().header("Authorization", (Object)jwt1).post(Entity.entity((Object)"", (String)"text/turtle;charset=utf-8"));){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            resource = res.getLocation().toString();
        }
        IRI obj = rdf.createIRI(resource);
        IRI parent = rdf.createIRI(container);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> this.messages.stream().map(this::convertToGraph).filter(g -> g.contains((BlankNodeOrIRI)obj, RDF.type, null)).anyMatch(g -> g.contains(null, AS.object, (RDFTerm)obj) && g.contains(null, AS.actor, (RDFTerm)rdf.createIRI("https://madison.example.com/profile#me")) && g.contains(null, RDF.type, (RDFTerm)PROV.Activity) && g.contains(null, RDF.type, (RDFTerm)AS.Create) && g.contains((BlankNodeOrIRI)obj, RDF.type, (RDFTerm)LDP.RDFSource)));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> this.messages.stream().map(this::convertToGraph).filter(g -> g.contains((BlankNodeOrIRI)parent, RDF.type, null)).anyMatch(g -> g.contains(null, AS.object, (RDFTerm)parent) && g.contains(null, AS.actor, (RDFTerm)rdf.createIRI("https://madison.example.com/profile#me")) && g.contains(null, RDF.type, (RDFTerm)PROV.Activity) && g.contains(null, RDF.type, (RDFTerm)AS.Update) && g.contains((BlankNodeOrIRI)parent, RDF.type, (RDFTerm)LDP.BasicContainer)));
        String agent2 = "https://pat.example.com/profile#me";
        String jwt2 = EventTests.buildJwt("https://pat.example.com/profile#me", JWT_SECRET);
        try (Response res = EventTests.target(resource).request().header("Authorization", (Object)jwt2).delete();){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> this.messages.stream().map(this::convertToGraph).filter(g -> g.contains((BlankNodeOrIRI)obj, RDF.type, null)).anyMatch(g -> g.contains(null, AS.object, (RDFTerm)obj) && g.contains(null, AS.actor, (RDFTerm)rdf.createIRI("https://pat.example.com/profile#me")) && g.contains(null, RDF.type, (RDFTerm)PROV.Activity) && g.contains(null, RDF.type, (RDFTerm)AS.Delete) && g.contains((BlankNodeOrIRI)obj, RDF.type, (RDFTerm)LDP.Resource)));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> this.messages.stream().map(this::convertToGraph).filter(g -> g.contains((BlankNodeOrIRI)parent, RDF.type, null)).anyMatch(g -> g.contains(null, AS.object, (RDFTerm)parent) && g.contains(null, AS.actor, (RDFTerm)rdf.createIRI("https://pat.example.com/profile#me")) && g.contains(null, RDF.type, (RDFTerm)PROV.Activity) && g.contains(null, RDF.type, (RDFTerm)AS.Update) && g.contains((BlankNodeOrIRI)parent, RDF.type, (RDFTerm)LDP.BasicContainer)));
    }

    private Graph convertToGraph(Message msg) {
        try {
            String body = ((TextMessage)msg).getText();
            return this.readEntityAsGraph(new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)), RDFSyntax.JSONLD);
        }
        catch (Exception ex) {
            LOGGER.error("Error processing message: {}", (Object)ex.getMessage());
            return rdf.createGraph();
        }
    }

    public void onMessage(Message message) {
        this.messages.add(message);
    }

    static {
        JWT_SECRET = "secret";
    }
}

