/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.test;

import java.time.Instant;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFSyntax;
import org.apache.commons.rdf.api.RDFTerm;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.platform.runner.JUnitPlatform;
import org.junit.runner.RunWith;
import org.trellisldp.http.domain.RdfMediaType;
import org.trellisldp.test.BaseCommonTests;
import org.trellisldp.vocabulary.DC;
import org.trellisldp.vocabulary.LDP;
import org.trellisldp.vocabulary.RDF;
import org.trellisldp.vocabulary.SKOS;
import org.trellisldp.vocabulary.Trellis;

@RunWith(value=JUnitPlatform.class)
public class LdpTests
extends BaseCommonTests {
    private static final String ENG = "eng";
    private static final String BASIC_CONTAINER_LABEL = "Basic Container";
    private static final String DIRECT_CONTAINER = "/directContainer.ttl";
    private static final String INDIRECT_CONTAINER = "/indirectContainer.ttl";
    private static final String INDIRECT_CONTAINER_MEMBER_SUBJECT = "/indirectContainerMemberSubject.ttl";
    private static final String BASIC_CONTAINER = "/basicContainer.ttl";
    private static final String SIMPLE_RESOURCE = "/simpleResource.ttl";
    private static final String MEMBER_RESOURCE1 = "/members1";
    private static final String MEMBER_RESOURCE2 = "/members2";
    private static final String MEMBER_RESOURCE_HASH = "#members";

    private Instant meanwhile() {
        Instant t1 = Instant.now();
        Awaitility.await().until(() -> this.isReallyLaterThan(t1));
        Instant t2 = Instant.now();
        Awaitility.await().until(() -> this.isReallyLaterThan(t2));
        return t2;
    }

    private Boolean isReallyLaterThan(Instant time) {
        Instant t = Instant.now();
        return t.isAfter(time) && (t.toEpochMilli() > time.toEpochMilli() || t.getNano() > time.getNano());
    }

    private String membershipResource(String uri) {
        return "<> ldp:membershipResource <" + uri + ">.\n";
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="Indirect Container Tests")
    public class IndirectContainerTests {
        private String base;
        private String container;
        private String container2;
        private String member;
        private String other;
        private String child;

        @BeforeAll
        @DisplayName(value="Initialize Indirect Container tests")
        public void init() {
            String containerContent = BaseCommonTests.getResourceAsString(LdpTests.BASIC_CONTAINER);
            try (Response res = BaseCommonTests.target().request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                this.base = res.getLocation().toString();
            }
            this.member = this.base + "/member";
            String content = BaseCommonTests.getResourceAsString(LdpTests.INDIRECT_CONTAINER) + LdpTests.this.membershipResource(this.member);
            try (Response res = BaseCommonTests.target(this.base).request().header("Link", (Object)Link.fromUri((String)LDP.IndirectContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.IndirectContainer)));
                this.container = res.getLocation().toString();
            }
            String content2 = BaseCommonTests.getResourceAsString(LdpTests.INDIRECT_CONTAINER_MEMBER_SUBJECT) + LdpTests.this.membershipResource(LdpTests.MEMBER_RESOURCE_HASH);
            try (Response res = BaseCommonTests.target(this.base).request().header("Link", (Object)Link.fromUri((String)LDP.IndirectContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)content2, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.IndirectContainer)));
                this.container2 = res.getLocation().toString();
            }
            String memberContent = BaseCommonTests.getResourceAsString(LdpTests.SIMPLE_RESOURCE) + "<> foaf:primaryTopic <#it> .";
            try (Response res = BaseCommonTests.target(this.container2).request().post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                this.child = res.getLocation().toString();
            }
            res = BaseCommonTests.target(this.member).request().put(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));
            var6_11 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
            }
            catch (Throwable throwable) {
                var6_11 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    IndirectContainerTests.$closeResource(var6_11, (AutoCloseable)res);
                }
            }
            this.other = this.base + "/other";
            res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.IndirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));
            var6_11 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.IndirectContainer)));
            }
            catch (Throwable throwable) {
                var6_11 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    IndirectContainerTests.$closeResource(var6_11, (AutoCloseable)res);
                }
            }
        }

        @Test
        @DisplayName(value="Test adding resource to the indirect container")
        public void testAddResourceWithMemberSubject() {
            try (Response res = BaseCommonTests.target(this.container2).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.IndirectContainer)));
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.container2), LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(this.child)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.container2 + LdpTests.MEMBER_RESOURCE_HASH), LDP.member, (RDFTerm)BaseCommonTests.rdf.createIRI(this.child)));
            }
        }

        @Test
        @DisplayName(value="Test adding resources to the indirect container")
        public void testAddingMemberResources() {
            EntityTag etag5;
            EntityTag etag2;
            IRI identifier;
            String child2;
            String child1;
            EntityTag etag4;
            EntityTag etag1;
            Graph g;
            String hash = "#it";
            String childContent = BaseCommonTests.getResourceAsString("/childResource.ttl");
            try (Response res = BaseCommonTests.target(this.member).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.member), LDP.member, null));
                etag1 = res.getEntityTag();
                Assertions.assertTrue((boolean)etag1.isWeak());
            }
            res = BaseCommonTests.target(this.container).request().get();
            var12_4 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.IndirectContainer)));
                g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.container), LDP.contains, null));
                etag4 = res.getEntityTag();
                Assertions.assertTrue((boolean)etag4.isWeak());
            }
            catch (Throwable g2) {
                var12_4 = g2;
                throw g2;
            }
            finally {
                if (res != null) {
                    IndirectContainerTests.$closeResource(var12_4, (AutoCloseable)res);
                }
            }
            LdpTests.this.meanwhile();
            res = BaseCommonTests.target(this.container).request().post(Entity.entity((Object)childContent, (String)"text/turtle;charset=utf-8"));
            var12_4 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                child1 = res.getLocation().toString();
                Assertions.assertTrue((boolean)child1.startsWith(this.container));
                Assertions.assertTrue((child1.length() > this.container.length() ? 1 : 0) != 0);
            }
            catch (Throwable g2) {
                var12_4 = g2;
                throw g2;
            }
            finally {
                if (res != null) {
                    IndirectContainerTests.$closeResource(var12_4, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.container).request().post(Entity.entity((Object)childContent, (String)"text/turtle;charset=utf-8"));
            var12_4 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                child2 = res.getLocation().toString();
                Assertions.assertTrue((boolean)child2.startsWith(this.container));
                Assertions.assertTrue((child2.length() > this.container.length() ? 1 : 0) != 0);
            }
            catch (Throwable g2) {
                var12_4 = g2;
                throw g2;
            }
            finally {
                if (res != null) {
                    IndirectContainerTests.$closeResource(var12_4, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.member).request().get();
            var12_4 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                identifier = BaseCommonTests.rdf.createIRI(this.member);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.member, (RDFTerm)BaseCommonTests.rdf.createIRI(child1 + "#it")));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.member, (RDFTerm)BaseCommonTests.rdf.createIRI(child2 + "#it")));
                etag2 = res.getEntityTag();
                Assertions.assertTrue((boolean)etag2.isWeak());
                Assertions.assertNotEquals((Object)etag1, (Object)etag2);
            }
            catch (Throwable g3) {
                var12_4 = g3;
                throw g3;
            }
            finally {
                if (res != null) {
                    IndirectContainerTests.$closeResource(var12_4, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.container).request().get();
            var12_4 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.IndirectContainer)));
                g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                identifier = BaseCommonTests.rdf.createIRI(this.container);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(child1)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(child2)));
                etag5 = res.getEntityTag();
                Assertions.assertTrue((boolean)etag5.isWeak());
                Assertions.assertNotEquals((Object)etag4, (Object)etag5);
            }
            catch (Throwable g4) {
                var12_4 = g4;
                throw g4;
            }
            finally {
                if (res != null) {
                    IndirectContainerTests.$closeResource(var12_4, (AutoCloseable)res);
                }
            }
            LdpTests.this.meanwhile();
            res = BaseCommonTests.target(child1).request().delete();
            var12_4 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
            catch (Throwable g4) {
                var12_4 = g4;
                throw g4;
            }
            finally {
                if (res != null) {
                    IndirectContainerTests.$closeResource(var12_4, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(child1).request().get();
            var12_4 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
            }
            catch (Throwable g4) {
                var12_4 = g4;
                throw g4;
            }
            finally {
                if (res != null) {
                    IndirectContainerTests.$closeResource(var12_4, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.member).request().get();
            var12_4 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                identifier = BaseCommonTests.rdf.createIRI(this.member);
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.member, (RDFTerm)BaseCommonTests.rdf.createIRI(child1 + "#it")));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.member, (RDFTerm)BaseCommonTests.rdf.createIRI(child2 + "#it")));
                EntityTag etag3 = res.getEntityTag();
                Assertions.assertTrue((boolean)etag3.isWeak());
                Assertions.assertNotEquals((Object)etag1, (Object)etag3);
                Assertions.assertNotEquals((Object)etag2, (Object)etag3);
            }
            catch (Throwable g5) {
                var12_4 = g5;
                throw g5;
            }
            finally {
                if (res != null) {
                    IndirectContainerTests.$closeResource(var12_4, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.container).request().get();
            var12_4 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.IndirectContainer)));
                g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                identifier = BaseCommonTests.rdf.createIRI(this.container);
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(child1)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(child2)));
                EntityTag etag6 = res.getEntityTag();
                Assertions.assertTrue((boolean)etag6.isWeak());
                Assertions.assertNotEquals((Object)etag5, (Object)etag6);
                Assertions.assertNotEquals((Object)etag4, (Object)etag6);
            }
            catch (Throwable throwable) {
                var12_4 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    IndirectContainerTests.$closeResource(var12_4, (AutoCloseable)res);
                }
            }
            String updateContent = "PREFIX dc: <http://purl.org/dc/terms/>\nPREFIX ldp: <http://www.w3.org/ns/ldp#>\n\nDELETE WHERE { <> ldp:hasMemberRelation ?o };INSERT { <> ldp:hasMemberRelation dc:relation } WHERE {}";
            try (Response res = BaseCommonTests.target(this.container).request().method("PATCH", Entity.entity((Object)"PREFIX dc: <http://purl.org/dc/terms/>\nPREFIX ldp: <http://www.w3.org/ns/ldp#>\n\nDELETE WHERE { <> ldp:hasMemberRelation ?o };INSERT { <> ldp:hasMemberRelation dc:relation } WHERE {}", (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.IndirectContainer)));
            }
            res = BaseCommonTests.target(this.member).request().get();
            var13_5 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                Graph g6 = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier2 = BaseCommonTests.rdf.createIRI(this.member);
                Assertions.assertTrue((boolean)g6.contains((BlankNodeOrIRI)identifier2, DC.relation, (RDFTerm)BaseCommonTests.rdf.createIRI(child2 + "#it")));
            }
            catch (Throwable throwable) {
                var13_5 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    IndirectContainerTests.$closeResource(var13_5, (AutoCloseable)res);
                }
            }
        }

        @Test
        @DisplayName(value="Test creating an indirect container via PUT")
        public void testCreateIndirectContainerViaPut() {
            String other2 = this.base + "/other2";
            String content = BaseCommonTests.getResourceAsString(LdpTests.INDIRECT_CONTAINER) + LdpTests.this.membershipResource(this.base + LdpTests.MEMBER_RESOURCE2);
            try (Response res = BaseCommonTests.target(other2).request().header("Link", (Object)Link.fromUri((String)LDP.IndirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.IndirectContainer)));
            }
        }

        @Test
        @DisplayName(value="Test updating an indirect container via PUT")
        public void testUpdateIndirectContainerViaPut() {
            String content = BaseCommonTests.getResourceAsString("/indirectContainerInverse.ttl") + LdpTests.this.membershipResource(this.base + LdpTests.MEMBER_RESOURCE2);
            try (Response res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.IndirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.IndirectContainer)));
            }
        }

        @Test
        @DisplayName(value="Test updating an indirect container with too many member-related properties")
        public void testUpdateIndirectContainerTooManyMemberProps() {
            String content = BaseCommonTests.getResourceAsString(LdpTests.INDIRECT_CONTAINER) + LdpTests.this.membershipResource(this.base + LdpTests.MEMBER_RESOURCE2) + "<> ldp:isMemberOfRelation dc:isPartOf .";
            try (Response res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.IndirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasConstrainedBy(Trellis.InvalidCardinality)));
            }
        }

        @Test
        @DisplayName(value="Test updating an indirect container with no ldp:insertedContentRelation property")
        public void testUpdateIndirectContainerNoICRProp() {
            String content = BaseCommonTests.getResourceAsString(LdpTests.DIRECT_CONTAINER) + LdpTests.this.membershipResource(this.base + LdpTests.MEMBER_RESOURCE2);
            try (Response res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.IndirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasConstrainedBy(Trellis.InvalidCardinality)));
            }
        }

        @Test
        @DisplayName(value="Test updating an indirect container with too many membership resources")
        public void testUpdateIndirectContainerMultipleMemberResources() {
            String content = BaseCommonTests.getResourceAsString(LdpTests.INDIRECT_CONTAINER) + LdpTests.this.membershipResource(this.base + LdpTests.MEMBER_RESOURCE2) + LdpTests.this.membershipResource(this.base + "/member3");
            try (Response res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.IndirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasConstrainedBy(Trellis.InvalidCardinality)));
            }
        }

        @Test
        @DisplayName(value="Test updating an indirect container with no member relation property")
        public void testUpdateIndirectContainerMissingMemberRelation() {
            String content = "PREFIX skos: <http://www.w3.org/2004/02/skos/core#> \nPREFIX ldp: <http://www.w3.org/ns/ldp#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nPREFIX dc: <http://purl.org/dc/terms/> \n\n<> skos:prefLabel \"Indirect Container\"@eng ;    ldp:membershipResource <" + this.base + LdpTests.MEMBER_RESOURCE2 + "> ;    ldp:insertedContentRelation foaf:primaryTopic ;    dc:description \"This is an Indirect Container for testing.\"@eng .";
            try (Response res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.IndirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasConstrainedBy(Trellis.InvalidCardinality)));
            }
        }

        @Test
        @DisplayName(value="Test updating an indirect container with no member resource")
        public void testUpdateIndirectContainerMissingMemberResource() {
            String content = BaseCommonTests.getResourceAsString(LdpTests.INDIRECT_CONTAINER);
            try (Response res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.IndirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasConstrainedBy(Trellis.InvalidCardinality)));
            }
        }

        @Test
        @DisplayName(value="Test with ldp:PreferMinimalContainer Prefer header")
        public void testGetEmptyMember() {
            try (Response res = BaseCommonTests.target(this.member).request().header("Prefer", (Object)("return=representation; include=\"" + LDP.PreferMinimalContainer.getIRIString() + "\"")).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier = BaseCommonTests.rdf.createIRI(this.member);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, SKOS.prefLabel, null));
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.member, null));
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)identifier, DC.relation, null));
            }
        }

        @Test
        @DisplayName(value="Test with ldp:PreferMinimalContainer Prefer header")
        public void testGetInverseEmptyMember() {
            try (Response res = BaseCommonTests.target(this.member).request().header("Prefer", (Object)("return=representation; omit=\"" + LDP.PreferMinimalContainer.getIRIString() + "\"")).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier = BaseCommonTests.rdf.createIRI(this.member);
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)identifier, SKOS.prefLabel, null));
                Assertions.assertTrue((g.contains((BlankNodeOrIRI)identifier, LDP.member, null) || g.contains((BlankNodeOrIRI)identifier, DC.relation, null) ? 1 : 0) != 0);
            }
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="Direct Container Tests")
    public class DirectContainerTests {
        private String base;
        private String container;
        private String member;
        private String other;
        private String container2;
        private String child;

        @BeforeAll
        @DisplayName(value="Initialize Direct Container tests")
        public void init() {
            String containerContent = BaseCommonTests.getResourceAsString(LdpTests.BASIC_CONTAINER);
            try (Response res = BaseCommonTests.target().request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                this.base = res.getLocation().toString();
            }
            this.member = this.base + LdpTests.MEMBER_RESOURCE1;
            String content = BaseCommonTests.getResourceAsString(LdpTests.DIRECT_CONTAINER) + LdpTests.this.membershipResource(this.member);
            try (Response res = BaseCommonTests.target(this.base).request().header("Link", (Object)Link.fromUri((String)LDP.DirectContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.DirectContainer)));
                this.container = res.getLocation().toString();
            }
            String memberContent = BaseCommonTests.getResourceAsString(LdpTests.SIMPLE_RESOURCE);
            try (Response res = BaseCommonTests.target(this.member).request().put(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
            }
            String simpleContent = BaseCommonTests.getResourceAsString(LdpTests.DIRECT_CONTAINER) + LdpTests.this.membershipResource(LdpTests.MEMBER_RESOURCE_HASH);
            try (Response res = BaseCommonTests.target(this.base).request().header("Link", (Object)Link.fromUri((String)LDP.DirectContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)simpleContent, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.DirectContainer)));
                this.container2 = res.getLocation().toString();
            }
            res = BaseCommonTests.target(this.container2).request().post(Entity.entity((Object)memberContent, (String)"text/turtle;charset=utf-8"));
            var6_11 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                this.child = res.getLocation().toString();
            }
            catch (Throwable throwable) {
                var6_11 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    DirectContainerTests.$closeResource(var6_11, (AutoCloseable)res);
                }
            }
            this.other = this.base + "/other";
            res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.DirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));
            var6_11 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.DirectContainer)));
            }
            catch (Throwable throwable) {
                var6_11 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    DirectContainerTests.$closeResource(var6_11, (AutoCloseable)res);
                }
            }
        }

        @Test
        @DisplayName(value="Test fetch a self-contained direct container")
        public void testSimpleDirectContainer() {
            try (Response res = BaseCommonTests.target(this.container2).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.container2), LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(this.child)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.container2 + LdpTests.MEMBER_RESOURCE_HASH), LDP.member, (RDFTerm)BaseCommonTests.rdf.createIRI(this.child)));
            }
        }

        @Test
        @DisplayName(value="Test adding resources to the direct container")
        public void testAddingMemberResources() {
            EntityTag etag5;
            EntityTag etag2;
            IRI identifier;
            String child2;
            String child1;
            EntityTag etag4;
            EntityTag etag1;
            Graph g;
            String childContent = BaseCommonTests.getResourceAsString(LdpTests.SIMPLE_RESOURCE);
            try (Response res = BaseCommonTests.target(this.member).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.member), LDP.member, null));
                etag1 = res.getEntityTag();
                Assertions.assertTrue((boolean)etag1.isWeak());
            }
            res = BaseCommonTests.target(this.container).request().get();
            var11_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.DirectContainer)));
                g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.container), LDP.contains, null));
                etag4 = res.getEntityTag();
                Assertions.assertTrue((boolean)etag4.isWeak());
            }
            catch (Throwable g2) {
                var11_3 = g2;
                throw g2;
            }
            finally {
                if (res != null) {
                    DirectContainerTests.$closeResource(var11_3, (AutoCloseable)res);
                }
            }
            LdpTests.this.meanwhile();
            res = BaseCommonTests.target(this.container).request().post(Entity.entity((Object)childContent, (String)"text/turtle;charset=utf-8"));
            var11_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                child1 = res.getLocation().toString();
                Assertions.assertTrue((boolean)child1.startsWith(this.container));
                Assertions.assertTrue((child1.length() > this.container.length() ? 1 : 0) != 0);
            }
            catch (Throwable g2) {
                var11_3 = g2;
                throw g2;
            }
            finally {
                if (res != null) {
                    DirectContainerTests.$closeResource(var11_3, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.container).request().post(Entity.entity((Object)childContent, (String)"text/turtle;charset=utf-8"));
            var11_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                child2 = res.getLocation().toString();
                Assertions.assertTrue((boolean)child2.startsWith(this.container));
                Assertions.assertTrue((child2.length() > this.container.length() ? 1 : 0) != 0);
            }
            catch (Throwable g2) {
                var11_3 = g2;
                throw g2;
            }
            finally {
                if (res != null) {
                    DirectContainerTests.$closeResource(var11_3, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.member).request().get();
            var11_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                identifier = BaseCommonTests.rdf.createIRI(this.member);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.member, (RDFTerm)BaseCommonTests.rdf.createIRI(child1)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.member, (RDFTerm)BaseCommonTests.rdf.createIRI(child2)));
                etag2 = res.getEntityTag();
                Assertions.assertTrue((boolean)etag2.isWeak());
                Assertions.assertNotEquals((Object)etag1, (Object)etag2);
            }
            catch (Throwable g3) {
                var11_3 = g3;
                throw g3;
            }
            finally {
                if (res != null) {
                    DirectContainerTests.$closeResource(var11_3, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.container).request().get();
            var11_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.DirectContainer)));
                g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                identifier = BaseCommonTests.rdf.createIRI(this.container);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(child1)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(child2)));
                etag5 = res.getEntityTag();
                Assertions.assertTrue((boolean)etag5.isWeak());
                Assertions.assertNotEquals((Object)etag4, (Object)etag5);
            }
            catch (Throwable g4) {
                var11_3 = g4;
                throw g4;
            }
            finally {
                if (res != null) {
                    DirectContainerTests.$closeResource(var11_3, (AutoCloseable)res);
                }
            }
            LdpTests.this.meanwhile();
            res = BaseCommonTests.target(child1).request().delete();
            var11_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
            catch (Throwable g4) {
                var11_3 = g4;
                throw g4;
            }
            finally {
                if (res != null) {
                    DirectContainerTests.$closeResource(var11_3, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(child1).request().get();
            var11_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
            }
            catch (Throwable g4) {
                var11_3 = g4;
                throw g4;
            }
            finally {
                if (res != null) {
                    DirectContainerTests.$closeResource(var11_3, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.member).request().get();
            var11_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                identifier = BaseCommonTests.rdf.createIRI(this.member);
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.member, (RDFTerm)BaseCommonTests.rdf.createIRI(child1)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.member, (RDFTerm)BaseCommonTests.rdf.createIRI(child2)));
                EntityTag etag3 = res.getEntityTag();
                Assertions.assertTrue((boolean)etag3.isWeak());
                Assertions.assertNotEquals((Object)etag1, (Object)etag3);
                Assertions.assertNotEquals((Object)etag2, (Object)etag3);
            }
            catch (Throwable g5) {
                var11_3 = g5;
                throw g5;
            }
            finally {
                if (res != null) {
                    DirectContainerTests.$closeResource(var11_3, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.container).request().get();
            var11_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.DirectContainer)));
                g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                identifier = BaseCommonTests.rdf.createIRI(this.container);
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(child1)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(child2)));
                EntityTag etag6 = res.getEntityTag();
                Assertions.assertTrue((boolean)etag6.isWeak());
                Assertions.assertNotEquals((Object)etag5, (Object)etag6);
                Assertions.assertNotEquals((Object)etag4, (Object)etag6);
            }
            catch (Throwable throwable) {
                var11_3 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    DirectContainerTests.$closeResource(var11_3, (AutoCloseable)res);
                }
            }
            String updateContent = "PREFIX dc: <http://purl.org/dc/terms/>\nPREFIX ldp: <http://www.w3.org/ns/ldp#>\n\nDELETE WHERE { <> ldp:hasMemberRelation ?o };INSERT { <> ldp:hasMemberRelation dc:relation } WHERE {}";
            try (Response res = BaseCommonTests.target(this.container).request().method("PATCH", Entity.entity((Object)"PREFIX dc: <http://purl.org/dc/terms/>\nPREFIX ldp: <http://www.w3.org/ns/ldp#>\n\nDELETE WHERE { <> ldp:hasMemberRelation ?o };INSERT { <> ldp:hasMemberRelation dc:relation } WHERE {}", (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.DirectContainer)));
            }
            res = BaseCommonTests.target(this.member).request().get();
            var12_4 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                Graph g6 = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier2 = BaseCommonTests.rdf.createIRI(this.member);
                Assertions.assertTrue((boolean)g6.contains((BlankNodeOrIRI)identifier2, DC.relation, (RDFTerm)BaseCommonTests.rdf.createIRI(child2)));
            }
            catch (Throwable throwable) {
                var12_4 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    DirectContainerTests.$closeResource(var12_4, (AutoCloseable)res);
                }
            }
        }

        @Test
        @DisplayName(value="Test creating a direct container via PUT")
        public void testCreateDirectContainerViaPut() {
            String other2 = this.base + "/other2";
            String content = BaseCommonTests.getResourceAsString(LdpTests.DIRECT_CONTAINER) + LdpTests.this.membershipResource(this.base + LdpTests.MEMBER_RESOURCE2);
            try (Response res = BaseCommonTests.target(other2).request().header("Link", (Object)Link.fromUri((String)LDP.DirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.DirectContainer)));
            }
        }

        @Test
        @DisplayName(value="Test updating a direct container via PUT")
        public void testUpdateDirectContainerViaPut() {
            String content = BaseCommonTests.getResourceAsString("/directContainerIsPartOf.ttl") + LdpTests.this.membershipResource(this.base + LdpTests.MEMBER_RESOURCE2);
            try (Response res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.DirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.DirectContainer)));
            }
        }

        @Test
        @DisplayName(value="Test updating a direct container with too many member-related properties")
        public void testUpdateDirectContainerTooManyMemberProps() {
            String content = BaseCommonTests.getResourceAsString(LdpTests.DIRECT_CONTAINER) + LdpTests.this.membershipResource(this.base + LdpTests.MEMBER_RESOURCE2) + "<> ldp:isMemberOfRelation dc:isPartOf .";
            try (Response res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.DirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasConstrainedBy(Trellis.InvalidCardinality)));
            }
        }

        @Test
        @DisplayName(value="Test updating a direct container with too many membership resources")
        public void testUpdateDirectContainerMultipleMemberResources() {
            String content = BaseCommonTests.getResourceAsString(LdpTests.DIRECT_CONTAINER) + LdpTests.this.membershipResource(this.base + LdpTests.MEMBER_RESOURCE2) + LdpTests.this.membershipResource(this.base + "/member3");
            try (Response res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.DirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasConstrainedBy(Trellis.InvalidCardinality)));
            }
        }

        @Test
        @DisplayName(value="Test updating a direct container with no member relation property")
        public void testUpdateDirectContainerMissingMemberRelation() {
            String content = "PREFIX skos: <http://www.w3.org/2004/02/skos/core#> \nPREFIX ldp: <http://www.w3.org/ns/ldp#> \nPREFIX dc: <http://purl.org/dc/terms/> \n\n<> skos:prefLabel \"Direct Container\"@eng ;    ldp:membershipResource <" + this.base + LdpTests.MEMBER_RESOURCE2 + "> ;    dc:description \"This is a Direct Container for testing.\"@eng .";
            try (Response res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.DirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasConstrainedBy(Trellis.InvalidCardinality)));
            }
        }

        @Test
        @DisplayName(value="Test updating a direct container with no member resource")
        public void testUpdateDirectContainerMissingMemberResource() {
            String content = BaseCommonTests.getResourceAsString(LdpTests.DIRECT_CONTAINER);
            try (Response res = BaseCommonTests.target(this.other).request().header("Link", (Object)Link.fromUri((String)LDP.DirectContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasConstrainedBy(Trellis.InvalidCardinality)));
            }
        }

        @Test
        @DisplayName(value="Test with ldp:PreferMinimalContainer Prefer header")
        public void testGetEmptyMember() {
            try (Response res = BaseCommonTests.target(this.member).request().header("Prefer", (Object)("return=representation; include=\"" + LDP.PreferMinimalContainer.getIRIString() + "\"")).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier = BaseCommonTests.rdf.createIRI(this.member);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, SKOS.prefLabel, null));
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.member, null));
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)identifier, DC.relation, null));
            }
        }

        @Test
        @DisplayName(value="Test with ldp:PreferMinimalContainer Prefer header")
        public void testGetInverseEmptyMember() {
            try (Response res = BaseCommonTests.target(this.member).request().header("Prefer", (Object)("return=representation; omit=\"" + LDP.PreferMinimalContainer.getIRIString() + "\"")).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier = BaseCommonTests.rdf.createIRI(this.member);
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)identifier, SKOS.prefLabel, null));
                Assertions.assertTrue((g.contains((BlankNodeOrIRI)identifier, LDP.member, null) || g.contains((BlankNodeOrIRI)identifier, DC.relation, null) ? 1 : 0) != 0);
            }
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="Basic Container Tests")
    public class BasicContainerTests {
        private String container;
        private String child1;
        private String child2;
        private EntityTag etag1;
        private EntityTag etag2;
        private EntityTag etag3;
        private EntityTag etag4;
        private EntityTag etag5;
        private final String containerContent = BaseCommonTests.getResourceAsString("/basicContainer.ttl");

        @BeforeAll
        @DisplayName(value="Initialize Basic Containment tests")
        public void init() {
            try (Response res = BaseCommonTests.target().request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)this.containerContent, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                this.container = res.getLocation().toString();
            }
            res = BaseCommonTests.target(this.container).request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)this.containerContent, (String)"text/turtle;charset=utf-8"));
            var2_2 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                this.child1 = res.getLocation().toString();
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    BasicContainerTests.$closeResource(var2_2, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.container).request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)this.containerContent, (String)"text/turtle;charset=utf-8"));
            var2_2 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                this.child2 = res.getLocation().toString();
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    BasicContainerTests.$closeResource(var2_2, (AutoCloseable)res);
                }
            }
        }

        @Test
        @DisplayName(value="Test with ldp:PreferMinimalContainer Prefer header")
        public void testGetEmptyContainer() {
            try (Response res = BaseCommonTests.target(this.container).request().header("Prefer", (Object)("return=representation; include=\"" + LDP.PreferMinimalContainer.getIRIString() + "\"")).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier = BaseCommonTests.rdf.createIRI(this.container);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, SKOS.prefLabel, (RDFTerm)BaseCommonTests.rdf.createLiteral(LdpTests.BASIC_CONTAINER_LABEL, LdpTests.ENG)));
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, null));
            }
        }

        @Test
        @DisplayName(value="Test with ldp:PreferMinimalContainer Prefer header")
        public void testGetInverseEmptyContainer() {
            try (Response res = BaseCommonTests.target(this.container).request().header("Prefer", (Object)("return=representation; omit=\"" + LDP.PreferMinimalContainer.getIRIString() + "\"")).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier = BaseCommonTests.rdf.createIRI(this.container);
                Assertions.assertFalse((boolean)g.contains((BlankNodeOrIRI)identifier, SKOS.prefLabel, (RDFTerm)BaseCommonTests.rdf.createLiteral(LdpTests.BASIC_CONTAINER_LABEL, LdpTests.ENG)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, null));
            }
        }

        @Test
        @DisplayName(value="Test fetching a basic container")
        public void testGetContainer() {
            try (Response res = BaseCommonTests.target(this.container).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.TEXT_TURTLE_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.TEXT_TURTLE_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier = BaseCommonTests.rdf.createIRI(this.container);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, SKOS.prefLabel, (RDFTerm)BaseCommonTests.rdf.createLiteral(LdpTests.BASIC_CONTAINER_LABEL, LdpTests.ENG)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, DC.description, null));
                Assertions.assertTrue((g.size() >= 2L ? 1 : 0) != 0);
                this.etag1 = res.getEntityTag();
                Assertions.assertTrue((boolean)this.etag1.isWeak());
                Assertions.assertNotEquals((Object)this.etag1, (Object)this.etag2);
            }
        }

        @Test
        @DisplayName(value="Test creating a basic container via POST")
        public void testCreateContainerViaPost() {
            String child3;
            LdpTests.this.meanwhile();
            try (Response res = BaseCommonTests.target(this.container).request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)this.containerContent, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                child3 = res.getLocation().toString();
                Assertions.assertTrue((boolean)child3.startsWith(this.container));
                Assertions.assertTrue((child3.length() > this.container.length() ? 1 : 0) != 0);
            }
            res = BaseCommonTests.target(this.container).request().get();
            var3_2 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.TEXT_TURTLE_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.TEXT_TURTLE_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier = BaseCommonTests.rdf.createIRI(this.container);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, SKOS.prefLabel, (RDFTerm)BaseCommonTests.rdf.createLiteral(LdpTests.BASIC_CONTAINER_LABEL, LdpTests.ENG)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, DC.description, null));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(child3)));
                Assertions.assertTrue((g.size() >= 3L ? 1 : 0) != 0);
                this.etag2 = res.getEntityTag();
                Assertions.assertTrue((boolean)this.etag2.isWeak());
                Assertions.assertNotEquals((Object)this.etag1, (Object)this.etag2);
                Assertions.assertNotEquals((Object)this.etag3, (Object)this.etag2);
                Assertions.assertNotEquals((Object)this.etag4, (Object)this.etag2);
            }
            catch (Throwable throwable) {
                var3_2 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    BasicContainerTests.$closeResource(var3_2, (AutoCloseable)res);
                }
            }
        }

        @Test
        @DisplayName(value="Test creating a child resource via PUT")
        public void testCreateContainerViaPut() {
            String child4 = this.container + "/child4";
            LdpTests.this.meanwhile();
            try (Response res = BaseCommonTests.target(child4).request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).put(Entity.entity((Object)this.containerContent, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
            }
            res = BaseCommonTests.target(this.container).request().get();
            var3_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.TEXT_TURTLE_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.TEXT_TURTLE_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier = BaseCommonTests.rdf.createIRI(this.container);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, SKOS.prefLabel, (RDFTerm)BaseCommonTests.rdf.createLiteral(LdpTests.BASIC_CONTAINER_LABEL, LdpTests.ENG)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, DC.description, null));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(child4)));
                Assertions.assertTrue((g.size() >= 3L ? 1 : 0) != 0);
                this.etag3 = res.getEntityTag();
                Assertions.assertTrue((boolean)this.etag3.isWeak());
                Assertions.assertNotEquals((Object)this.etag1, (Object)this.etag3);
                Assertions.assertNotEquals((Object)this.etag2, (Object)this.etag3);
                Assertions.assertNotEquals((Object)this.etag4, (Object)this.etag3);
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    BasicContainerTests.$closeResource(var3_3, (AutoCloseable)res);
                }
            }
        }

        @Test
        @DisplayName(value="Test creating a child resource with a Slug header")
        public void testCreateContainerWithSlug() {
            String child5 = this.container + "/child5";
            try (Response res = BaseCommonTests.target(this.container).request().header("Slug", (Object)"child5").header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)this.containerContent, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                Assertions.assertEquals((Object)child5, (Object)res.getLocation().toString());
            }
            res = BaseCommonTests.target(this.container).request().get();
            var3_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.TEXT_TURTLE_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.TEXT_TURTLE_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier = BaseCommonTests.rdf.createIRI(this.container);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, SKOS.prefLabel, (RDFTerm)BaseCommonTests.rdf.createLiteral(LdpTests.BASIC_CONTAINER_LABEL, LdpTests.ENG)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, DC.description, null));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(child5)));
                Assertions.assertTrue((g.size() >= 3L ? 1 : 0) != 0);
                this.etag4 = res.getEntityTag();
                Assertions.assertTrue((boolean)this.etag4.isWeak());
                Assertions.assertNotEquals((Object)this.etag1, (Object)this.etag4);
                Assertions.assertNotEquals((Object)this.etag2, (Object)this.etag4);
                Assertions.assertNotEquals((Object)this.etag3, (Object)this.etag4);
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    BasicContainerTests.$closeResource(var3_3, (AutoCloseable)res);
                }
            }
        }

        @Test
        @DisplayName(value="Test deleting a basic container")
        public void testDeleteContainer() {
            EntityTag etag;
            Graph g2;
            try (Response res = BaseCommonTests.target(this.container).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.TEXT_TURTLE_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.TEXT_TURTLE_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                g2 = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI identifier = BaseCommonTests.rdf.createIRI(this.container);
                Assertions.assertTrue((boolean)g2.contains((BlankNodeOrIRI)identifier, SKOS.prefLabel, (RDFTerm)BaseCommonTests.rdf.createLiteral(LdpTests.BASIC_CONTAINER_LABEL, LdpTests.ENG)));
                Assertions.assertTrue((boolean)g2.contains((BlankNodeOrIRI)identifier, DC.description, null));
                Assertions.assertTrue((boolean)g2.contains((BlankNodeOrIRI)identifier, LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(this.child1)));
                Assertions.assertTrue((g2.size() >= 3L ? 1 : 0) != 0);
                etag = res.getEntityTag();
                Assertions.assertTrue((boolean)etag.isWeak());
            }
            LdpTests.this.meanwhile();
            res = BaseCommonTests.target(this.child1).request().delete();
            var3_2 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            }
            catch (Throwable g2) {
                var3_2 = g2;
                throw g2;
            }
            finally {
                if (res != null) {
                    BasicContainerTests.$closeResource(var3_2, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.child1).request().get();
            var3_2 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
            }
            catch (Throwable g2) {
                var3_2 = g2;
                throw g2;
            }
            finally {
                if (res != null) {
                    BasicContainerTests.$closeResource(var3_2, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.container).request().get();
            var3_2 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.TEXT_TURTLE_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.TEXT_TURTLE_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                g2 = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertFalse((boolean)g2.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.container), LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(this.child1)));
                Assertions.assertTrue((boolean)res.getEntityTag().isWeak());
                Assertions.assertNotEquals((Object)etag, (Object)res.getEntityTag());
            }
            catch (Throwable throwable) {
                var3_2 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    BasicContainerTests.$closeResource(var3_2, (AutoCloseable)res);
                }
            }
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="Binary resource tests")
    public class BinaryTests {
        private final String content = "This is a file.";
        private String container;
        private String binary;
        private EntityTag etag1;
        private EntityTag etag2;

        @BeforeAll
        @DisplayName(value="Initialize Binary tests")
        public void init() {
            String containerContent = BaseCommonTests.getResourceAsString(LdpTests.BASIC_CONTAINER);
            try (Response res = BaseCommonTests.target().request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                this.container = res.getLocation().toString();
            }
            res = BaseCommonTests.target(this.container).request().post(Entity.entity((Object)"This is a file.", (String)"text/plain"));
            var3_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                this.binary = res.getLocation().toString();
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    BinaryTests.$closeResource(var3_3, (AutoCloseable)res);
                }
            }
        }

        @Test
        @DisplayName(value="Test fetching a binary resource")
        public void testGetBinary() {
            try (Response res = BaseCommonTests.target(this.binary).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(MediaType.TEXT_PLAIN_TYPE));
                Assertions.assertTrue((boolean)MediaType.TEXT_PLAIN_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                Assertions.assertEquals((Object)"This is a file.", (Object)BaseCommonTests.readEntityAsString(res.getEntity()));
                Assertions.assertFalse((boolean)res.getEntityTag().isWeak());
                this.etag1 = res.getEntityTag();
                Assertions.assertNotEquals((Object)this.etag1, (Object)this.etag2);
            }
        }

        @Test
        @DisplayName(value="Test fetching a binary description")
        public void testGetBinaryDescription() {
            try (Response res = BaseCommonTests.target(this.binary).request().accept(new String[]{"text/turtle"}).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.TEXT_TURTLE_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.TEXT_TURTLE_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertTrue((g.size() >= 0L ? 1 : 0) != 0);
                Assertions.assertTrue((boolean)res.getEntityTag().isWeak());
                this.etag2 = res.getEntityTag();
                Assertions.assertNotEquals((Object)this.etag1, (Object)this.etag2);
            }
        }

        @Test
        @DisplayName(value="Test creating a new binary via POST")
        public void testPostBinary() {
            try (Response res = BaseCommonTests.target(this.container).request().post(Entity.entity((Object)"This is a file.", (String)"text/plain"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                String location = res.getLocation().toString();
                Assertions.assertTrue((boolean)location.startsWith(this.container));
                Assertions.assertTrue((location.length() > this.container.length() ? 1 : 0) != 0);
            }
        }

        @Test
        @DisplayName(value="Test creating a new binary via POST with a digest header")
        public void testPostBinaryWithDigest() {
            try (Response res = BaseCommonTests.target(this.container).request().header("Digest", (Object)"md5=bUMuG430lSc5B2PWyoNIgA==").post(Entity.entity((Object)"This is a file.", (String)"text/plain"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                String resource = res.getLocation().toString();
                Assertions.assertTrue((boolean)resource.startsWith(this.container));
                Assertions.assertTrue((resource.length() > this.container.length() ? 1 : 0) != 0);
            }
        }

        @Test
        @DisplayName(value="Test modifying a binary's description via PATCH")
        public void testPatchBinaryDescription() {
            EntityTag etag;
            Graph g2;
            try (Response res = BaseCommonTests.target(this.binary).request().accept(new String[]{"text/turtle"}).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.TEXT_TURTLE_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.TEXT_TURTLE_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                g2 = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertEquals((long)0L, (long)g2.size());
                etag = res.getEntityTag();
                Assertions.assertTrue((boolean)etag.isWeak());
                Assertions.assertNotEquals((Object)this.etag1, (Object)etag);
            }
            LdpTests.this.meanwhile();
            res = BaseCommonTests.target(this.binary).request().method("PATCH", Entity.entity((Object)"INSERT { <> <http://purl.org/dc/terms/title> \"Title\" } WHERE {}", (String)"application/sparql-update"));
            var3_2 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
            }
            catch (Throwable g2) {
                var3_2 = g2;
                throw g2;
            }
            finally {
                if (res != null) {
                    BinaryTests.$closeResource(var3_2, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.binary).request().accept(new String[]{"text/turtle"}).get();
            var3_2 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.TEXT_TURTLE_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.TEXT_TURTLE_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                g2 = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertEquals((long)1L, (long)g2.size());
                Assertions.assertTrue((boolean)g2.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.binary), DC.title, (RDFTerm)BaseCommonTests.rdf.createLiteral("Title")));
                Assertions.assertNotEquals((Object)etag, (Object)res.getEntityTag());
            }
            catch (Throwable throwable) {
                var3_2 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    BinaryTests.$closeResource(var3_2, (AutoCloseable)res);
                }
            }
            res = BaseCommonTests.target(this.binary).request().get();
            var3_2 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(MediaType.TEXT_PLAIN_TYPE));
                Assertions.assertTrue((boolean)MediaType.TEXT_PLAIN_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertEquals((Object)"This is a file.", (Object)BaseCommonTests.readEntityAsString(res.getEntity()));
                Assertions.assertEquals((Object)this.etag1, (Object)res.getEntityTag());
            }
            catch (Throwable throwable) {
                var3_2 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    BinaryTests.$closeResource(var3_2, (AutoCloseable)res);
                }
            }
        }

        @Test
        @DisplayName(value="Test that the binary appears in the parent container")
        public void testBinaryIsInContainer() {
            try (Response res = BaseCommonTests.target(this.container).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.container), LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(this.binary)));
            }
        }

        @Test
        @DisplayName(value="Test that the SHA digest is generated")
        public void testBinaryWantDigestSha() {
            try (Response res = BaseCommonTests.target(this.binary).request().header("Want-Digest", (Object)"SHA,MD5").get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(MediaType.TEXT_PLAIN_TYPE));
                Assertions.assertTrue((boolean)MediaType.TEXT_PLAIN_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertEquals((Object)"sha=Z5pg2cWB1IqkKKMjh57cQKAeKp0=", (Object)res.getHeaderString("Digest"));
            }
        }

        @Test
        @DisplayName(value="Test that the SHA-256 digest is generated")
        public void testBinaryWantDigestSha256() {
            try (Response res = BaseCommonTests.target(this.binary).request().header("Want-Digest", (Object)"SHA-256").get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(MediaType.TEXT_PLAIN_TYPE));
                Assertions.assertTrue((boolean)MediaType.TEXT_PLAIN_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertEquals((Object)"sha-256=wZXqBpAjgZLSoADF419CRpJCurDcagOwnb/8VAiiQXA=", (Object)res.getHeaderString("Digest"));
            }
        }

        @Test
        @DisplayName(value="Test that an unknown digest is ignored")
        public void testBinaryWantDigestUnknown() {
            try (Response res = BaseCommonTests.target(this.binary).request().header("Want-Digest", (Object)"FOO").get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(MediaType.TEXT_PLAIN_TYPE));
                Assertions.assertTrue((boolean)MediaType.TEXT_PLAIN_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertNull((Object)res.getHeaderString("Digest"));
            }
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="RDF resource tests")
    public class RDFTests {
        private String container;
        private String resource;
        private EntityTag etag1;
        private EntityTag etag2;
        private final String content = BaseCommonTests.getResourceAsString("/simpleResource.ttl");

        @BeforeAll
        @DisplayName(value="Initialize RDF tests")
        protected void setUp() {
            String containerContent = BaseCommonTests.getResourceAsString(LdpTests.BASIC_CONTAINER);
            try (Response res = BaseCommonTests.target().request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                this.container = res.getLocation().toString();
            }
            res = BaseCommonTests.target(this.container).request().post(Entity.entity((Object)this.content, (String)"text/turtle;charset=utf-8"));
            var3_3 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                this.resource = res.getLocation().toString();
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    RDFTests.$closeResource(var3_3, (AutoCloseable)res);
                }
            }
        }

        @Test
        @DisplayName(value="Fetch the default RDF serialization")
        public void testGetDefault() {
            try (Response res = BaseCommonTests.target(this.resource).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.TEXT_TURTLE_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.TEXT_TURTLE_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
            }
        }

        @Test
        @DisplayName(value="Fetch the JSON-LD serialization")
        public void testGetJsonLd() {
            try (Response res = BaseCommonTests.target(this.resource).request().accept(new String[]{"application/ld+json"}).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.APPLICATION_LD_JSON_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.APPLICATION_LD_JSON_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
            }
        }

        @Test
        @DisplayName(value="Fetch the N-Triples serialization")
        public void testGetNTriples() {
            try (Response res = BaseCommonTests.target(this.resource).request().accept(new String[]{"application/n-triples"}).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.APPLICATION_N_TRIPLES_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.APPLICATION_N_TRIPLES_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
            }
        }

        @Test
        @DisplayName(value="Test POSTing an RDF resource")
        public void testPostRDF() {
            try (Response res = BaseCommonTests.target(this.container).request().post(Entity.entity((Object)this.content, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                String location = res.getLocation().toString();
                Assertions.assertTrue((boolean)location.startsWith(this.container));
                Assertions.assertTrue((location.length() > this.container.length() ? 1 : 0) != 0);
            }
        }

        @Test
        @DisplayName(value="Test fetching an RDF resource")
        public void testGetRDF() {
            try (Response res = BaseCommonTests.target(this.resource).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.TEXT_TURTLE_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.TEXT_TURTLE_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertEquals((long)3L, (long)g.size());
                IRI identifier = BaseCommonTests.rdf.createIRI(this.resource);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, RDF.type, (RDFTerm)SKOS.Concept));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, SKOS.prefLabel, (RDFTerm)BaseCommonTests.rdf.createLiteral("Resource Name", LdpTests.ENG)));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)identifier, DC.subject, (RDFTerm)BaseCommonTests.rdf.createIRI("http://example.org/subject/1")));
                this.etag1 = res.getEntityTag();
                Assertions.assertTrue((boolean)this.etag1.isWeak());
                Assertions.assertNotEquals((Object)this.etag1, (Object)this.etag2);
            }
        }

        @Test
        @DisplayName(value="Test modifying an RDF document via PATCH")
        public void testPatchRDF() {
            LdpTests.this.meanwhile();
            try (Response res = BaseCommonTests.target(this.resource).request().method("PATCH", Entity.entity((Object)"INSERT { <> <http://purl.org/dc/terms/title> \"Title\" } WHERE {}", (String)"application/sparql-update"));){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
            }
            LdpTests.this.meanwhile();
            res = BaseCommonTests.target(this.resource).request().accept(new String[]{"application/n-triples"}).get();
            var2_2 = null;
            try {
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.APPLICATION_N_TRIPLES_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.APPLICATION_N_TRIPLES_TYPE.isCompatible(res.getMediaType()));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.RDFSource)));
                Assertions.assertFalse((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.NonRDFSource)));
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.NTRIPLES);
                Assertions.assertEquals((long)4L, (long)g.size());
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.resource), DC.title, (RDFTerm)BaseCommonTests.rdf.createLiteral("Title")));
                this.etag2 = res.getEntityTag();
                Assertions.assertTrue((boolean)this.etag2.isWeak());
                Assertions.assertNotEquals((Object)this.etag1, (Object)this.etag2);
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (res != null) {
                    RDFTests.$closeResource(var2_2, (AutoCloseable)res);
                }
            }
        }

        @Test
        @DisplayName(value="Verify that the correct containment triples exist")
        public void testRdfContainment() {
            try (Response res = BaseCommonTests.target(this.container).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasType(LDP.BasicContainer)));
                Graph g = LdpTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(this.container), LDP.contains, (RDFTerm)BaseCommonTests.rdf.createIRI(this.resource)));
            }
        }

        @Test
        @DisplayName(value="Test creating resource with invalid RDF")
        public void testWeirdRDF() {
            String rdf = BaseCommonTests.getResourceAsString(LdpTests.SIMPLE_RESOURCE) + "<> a \"skos concept\" .";
            try (Response res = BaseCommonTests.target(this.container).request().post(Entity.entity((Object)rdf, (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(LdpTests.this.hasConstrainedBy(Trellis.InvalidRange)));
            }
        }

        @Test
        @DisplayName(value="Test creating resource with syntactically invalid RDF")
        public void testInvalidRDF() {
            String rdf = "PREFIX skos: <http://www.w3.org/2004/02/skos/core#> \nPREFIX dc: <http://purl.org/dc/terms/> \n\n<> a skos:Concept \n   skos:prefLabel \"Resource Name\"@eng \n   dc:subject <http://example.org/subject/1> .";
            try (Response res = BaseCommonTests.target(this.container).request().post(Entity.entity((Object)"PREFIX skos: <http://www.w3.org/2004/02/skos/core#> \nPREFIX dc: <http://purl.org/dc/terms/> \n\n<> a skos:Concept \n   skos:prefLabel \"Resource Name\"@eng \n   dc:subject <http://example.org/subject/1> .", (String)"text/turtle;charset=utf-8"));){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
            }
        }
    }
}

