/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.test;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFSyntax;
import org.apache.commons.rdf.api.RDFTerm;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.platform.runner.JUnitPlatform;
import org.junit.runner.RunWith;
import org.trellisldp.http.domain.RdfMediaType;
import org.trellisldp.test.BaseCommonTests;
import org.trellisldp.vocabulary.DC;
import org.trellisldp.vocabulary.LDP;
import org.trellisldp.vocabulary.Memento;
import org.trellisldp.vocabulary.SKOS;
import org.trellisldp.vocabulary.Time;

@RunWith(value=JUnitPlatform.class)
public class MementoTests
extends BaseCommonTests {
    private static final String TIMEMAP_QUERY_ARG = "?ext=timemap";
    private static final String PATCH = "PATCH";
    private static String container;
    private static String resource;
    private static final String content = "PREFIX skos: <http://www.w3.org/2004/02/skos/core#> \nPREFIX dc: <http://purl.org/dc/terms/> \n\n<> a skos:Concept ;\n   skos:prefLabel \"Resource Name\"@eng ;\n   dc:subject <http://example.org/subject/1> .";
    private static final String containerContent = "PREFIX skos: <http://www.w3.org/2004/02/skos/core#> \nPREFIX dc: <http://purl.org/dc/terms/> \n\n<> skos:prefLabel \"Basic Container\"@eng ;    dc:description \"This is a simple Basic Container for testing.\"@eng .";

    protected static void setUp() {
        try (Response res = MementoTests.target().request().header("Link", (Object)Link.fromUri((String)LDP.BasicContainer.getIRIString()).rel("type").build(new Object[0])).post(Entity.entity((Object)containerContent, (String)"text/turtle;charset=utf-8"));){
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            container = res.getLocation().toString();
        }
        res = MementoTests.target(container).request().post(Entity.entity((Object)content, (String)"text/turtle;charset=utf-8"));
        var1_1 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
            resource = res.getLocation().toString();
        }
        catch (Throwable throwable) {
            var1_1 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                MementoTests.$closeResource(var1_1, (AutoCloseable)res);
            }
        }
        MementoTests.meanwhile();
        res = MementoTests.target(resource).request().method(PATCH, Entity.entity((Object)"INSERT { <> <http://purl.org/dc/terms/title> \"Title\" } WHERE {}", (String)"application/sparql-update"));
        var1_1 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
        }
        catch (Throwable throwable) {
            var1_1 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                MementoTests.$closeResource(var1_1, (AutoCloseable)res);
            }
        }
        MementoTests.meanwhile();
        res = MementoTests.target(resource).request().method(PATCH, Entity.entity((Object)"INSERT { <> <http://purl.org/dc/terms/alternative> \"Alternative Title\" } WHERE {}", (String)"application/sparql-update"));
        var1_1 = null;
        try {
            Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
        }
        catch (Throwable throwable) {
            var1_1 = throwable;
            throw throwable;
        }
        finally {
            if (res != null) {
                MementoTests.$closeResource(var1_1, (AutoCloseable)res);
            }
        }
    }

    protected static void tearDown() {
        System.getProperties().remove("trellis.namespaces.path");
    }

    private static Instant meanwhile() {
        Instant t1 = Instant.now();
        Awaitility.await().until(() -> MementoTests.isReallyLaterThan(t1));
        Instant t2 = Instant.now();
        Awaitility.await().until(() -> MementoTests.isReallyLaterThan(t2));
        return t2;
    }

    private static Boolean isReallyLaterThan(Instant time) {
        Instant t = Instant.now();
        return t.isAfter(time) && t.getEpochSecond() > time.getEpochSecond();
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="Memento resource tests")
    public class MementoResourceTests {
        final Map<String, String> mementos = new HashMap<String, String>();

        @BeforeAll
        @DisplayName(value="Build a list of all Mementos")
        public void getMementoList() {
            try (Response res = BaseCommonTests.target(resource).request().get();){
                BaseCommonTests.getLinks(res).stream().filter(link -> link.getRel().equals("memento")).filter(l -> l.getParams().containsKey("datetime")).forEach(link -> this.mementos.put(link.getUri().toString(), (String)link.getParams().get("datetime")));
            }
        }

        @Test
        @DisplayName(value="Test the presence of three mementos")
        public void testMementosWereFound() {
            Assertions.assertFalse((boolean)this.mementos.isEmpty());
            Assertions.assertEquals((int)3, (int)this.mementos.size());
        }

        @Test
        @DisplayName(value="Test the presence of a datetime header for each memento")
        public void testMementoDateTimeHeader() {
            this.mementos.forEach((memento, date) -> {
                Response res = BaseCommonTests.target(memento).request().get();
                Throwable throwable = null;
                try {
                    Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                    ZonedDateTime zdt = ZonedDateTime.parse(date, DateTimeFormatter.RFC_1123_DATE_TIME);
                    Assertions.assertEquals((Object)zdt, (Object)ZonedDateTime.parse(res.getHeaderString("Memento-Datetime"), DateTimeFormatter.RFC_1123_DATE_TIME));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (res != null) {
                        MementoResourceTests.$closeResource(throwable, (AutoCloseable)res);
                    }
                }
            });
        }

        @Test
        @DisplayName(value="Test the presence of a datetime header for each memento")
        public void testMementoAcceptDateTimeHeader() {
            this.mementos.forEach((memento, date) -> {
                Response res = BaseCommonTests.target(resource).request().header("Accept-Datetime", date).get();
                Throwable throwable = null;
                try {
                    Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                    ZonedDateTime zdt = ZonedDateTime.parse(date, DateTimeFormatter.RFC_1123_DATE_TIME);
                    Assertions.assertEquals((Object)zdt, (Object)ZonedDateTime.parse(res.getHeaderString("Memento-Datetime"), DateTimeFormatter.RFC_1123_DATE_TIME));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (res != null) {
                        MementoResourceTests.$closeResource(throwable, (AutoCloseable)res);
                    }
                }
            });
        }

        @Test
        @DisplayName(value="Test allowed methods on memento resources")
        public void testMementoAllowedMethods() {
            this.mementos.forEach((memento, date) -> {
                Response res = BaseCommonTests.target(memento).request().get();
                Throwable throwable = null;
                try {
                    Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                    Assertions.assertTrue((boolean)res.getAllowedMethods().contains("GET"));
                    Assertions.assertTrue((boolean)res.getAllowedMethods().contains("HEAD"));
                    Assertions.assertTrue((boolean)res.getAllowedMethods().contains("OPTIONS"));
                    Assertions.assertFalse((boolean)res.getAllowedMethods().contains("POST"));
                    Assertions.assertFalse((boolean)res.getAllowedMethods().contains("PUT"));
                    Assertions.assertFalse((boolean)res.getAllowedMethods().contains(MementoTests.PATCH));
                    Assertions.assertFalse((boolean)res.getAllowedMethods().contains("DELETE"));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (res != null) {
                        MementoResourceTests.$closeResource(throwable, (AutoCloseable)res);
                    }
                }
            });
        }

        @Test
        @DisplayName(value="Test that memento resources are also LDP resources")
        public void testMementoLdpResource() {
            this.mementos.forEach((memento, date) -> {
                Response res = BaseCommonTests.target(memento).request().get();
                Throwable throwable = null;
                try {
                    Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                    Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(MementoTests.this.hasType(LDP.Resource)));
                    Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(MementoTests.this.hasType(LDP.RDFSource)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (res != null) {
                        MementoResourceTests.$closeResource(throwable, (AutoCloseable)res);
                    }
                }
            });
        }

        @Test
        @DisplayName(value="Test the content of memento resources")
        public void testMementoContent() {
            Dataset dataset = BaseCommonTests.rdf.createDataset();
            this.mementos.forEach((memento, date) -> {
                Response res = BaseCommonTests.target(memento).request().get();
                Throwable throwable = null;
                try {
                    Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                    MementoTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE).stream().forEach(triple -> dataset.add((BlankNodeOrIRI)BaseCommonTests.rdf.createIRI(memento), triple.getSubject(), triple.getPredicate(), triple.getObject()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (res != null) {
                        MementoResourceTests.$closeResource(throwable, (AutoCloseable)res);
                    }
                }
            });
            IRI subject = BaseCommonTests.rdf.createIRI(resource);
            List urls = this.mementos.keySet().stream().sorted().map(arg_0 -> ((RDF)BaseCommonTests.rdf).createIRI(arg_0)).collect(Collectors.toList());
            Assertions.assertEquals((long)3L, (long)urls.size());
            Assertions.assertTrue((boolean)dataset.getGraph((BlankNodeOrIRI)urls.get(0)).isPresent());
            dataset.getGraph((BlankNodeOrIRI)urls.get(0)).ifPresent(g -> {
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)subject, org.trellisldp.vocabulary.RDF.type, (RDFTerm)SKOS.Concept));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)subject, SKOS.prefLabel, (RDFTerm)BaseCommonTests.rdf.createLiteral("Resource Name", "eng")));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)subject, DC.subject, (RDFTerm)BaseCommonTests.rdf.createIRI("http://example.org/subject/1")));
                Assertions.assertEquals((long)3L, (long)g.size());
            });
            Assertions.assertTrue((boolean)dataset.getGraph((BlankNodeOrIRI)urls.get(1)).isPresent());
            dataset.getGraph((BlankNodeOrIRI)urls.get(1)).ifPresent(g -> {
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)subject, org.trellisldp.vocabulary.RDF.type, (RDFTerm)SKOS.Concept));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)subject, SKOS.prefLabel, (RDFTerm)BaseCommonTests.rdf.createLiteral("Resource Name", "eng")));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)subject, DC.subject, (RDFTerm)BaseCommonTests.rdf.createIRI("http://example.org/subject/1")));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)subject, DC.title, (RDFTerm)BaseCommonTests.rdf.createLiteral("Title")));
                Assertions.assertEquals((long)4L, (long)g.size());
            });
            Assertions.assertTrue((boolean)dataset.getGraph((BlankNodeOrIRI)urls.get(2)).isPresent());
            dataset.getGraph((BlankNodeOrIRI)urls.get(2)).ifPresent(g -> {
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)subject, org.trellisldp.vocabulary.RDF.type, (RDFTerm)SKOS.Concept));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)subject, SKOS.prefLabel, (RDFTerm)BaseCommonTests.rdf.createLiteral("Resource Name", "eng")));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)subject, DC.subject, (RDFTerm)BaseCommonTests.rdf.createIRI("http://example.org/subject/1")));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)subject, DC.title, (RDFTerm)BaseCommonTests.rdf.createLiteral("Title")));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)subject, DC.alternative, (RDFTerm)BaseCommonTests.rdf.createLiteral("Alternative Title")));
                Assertions.assertEquals((long)5L, (long)g.size());
            });
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="Memento TimeMap tests")
    public class TimeMapTests {
        @Test
        @DisplayName(value="Test the presence of a rel=timemap Link header")
        public void testTimeMapLinkHeader() {
            try (Response res = BaseCommonTests.target(resource).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().filter(l -> l.getRels().contains("timemap") && l.getUri().toString().equals(resource + MementoTests.TIMEMAP_QUERY_ARG)).findFirst().isPresent());
            }
        }

        @Test
        @DisplayName(value="Test the timemap response for a rel=timemap")
        public void testTimeMapResponseHasTimeMapLink() {
            try (Response res = BaseCommonTests.target(resource + MementoTests.TIMEMAP_QUERY_ARG).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().filter(l -> l.getRels().contains("timemap") && l.getUri().toString().equals(resource + MementoTests.TIMEMAP_QUERY_ARG)).findFirst().isPresent());
            }
        }

        @Test
        @DisplayName(value="Test that the timemap resource is an LDP resource")
        public void testTimeMapIsLDPResource() {
            try (Response res = BaseCommonTests.target(resource + MementoTests.TIMEMAP_QUERY_ARG).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(MementoTests.this.hasType(LDP.Resource)));
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().anyMatch(MementoTests.this.hasType(LDP.RDFSource)));
            }
        }

        @Test
        @DisplayName(value="Test that the timemap response is application/link-format")
        public void testTimeMapMediaType() {
            try (Response res = BaseCommonTests.target(resource + MementoTests.TIMEMAP_QUERY_ARG).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(MediaType.valueOf((String)"application/link-format")));
                Assertions.assertTrue((boolean)MediaType.valueOf((String)"application/link-format").isCompatible(res.getMediaType()));
            }
        }

        @Test
        @DisplayName(value="Test content negotiation on timemap resource: turtle")
        public void testTimeMapConnegTurtle() {
            try (Response res = BaseCommonTests.target(resource + MementoTests.TIMEMAP_QUERY_ARG).request().accept(new String[]{"text/turtle"}).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.TEXT_TURTLE_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.TEXT_TURTLE_TYPE.isCompatible(res.getMediaType()));
                Graph g = MementoTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.TURTLE);
                IRI original = BaseCommonTests.rdf.createIRI(resource);
                IRI timemap = BaseCommonTests.rdf.createIRI(resource + MementoTests.TIMEMAP_QUERY_ARG);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.OriginalResource));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.TimeGate));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, Memento.timegate, (RDFTerm)original));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, Memento.timemap, (RDFTerm)timemap));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, Memento.memento, null));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)timemap, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.TimeMap));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)timemap, Time.hasBeginning, null));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)timemap, Time.hasEnd, null));
                Assertions.assertTrue((boolean)g.contains(null, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.Memento));
                g.stream((BlankNodeOrIRI)original, Memento.memento, null).map(x -> (IRI)x.getObject()).forEach(memento -> {
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.Memento));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Memento.original, (RDFTerm)original));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Memento.timegate, (RDFTerm)original));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Memento.timemap, (RDFTerm)timemap));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Memento.mementoDatetime, null));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Time.hasTime, null));
                });
            }
        }

        @Test
        @DisplayName(value="Test content negotiation on timemap resource: json-ld")
        public void testTimeMapConnegJsonLd() {
            try (Response res = BaseCommonTests.target(resource + MementoTests.TIMEMAP_QUERY_ARG).request().accept(new String[]{"application/ld+json"}).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.APPLICATION_LD_JSON_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.APPLICATION_LD_JSON_TYPE.isCompatible(res.getMediaType()));
                Graph g = MementoTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.JSONLD);
                IRI original = BaseCommonTests.rdf.createIRI(resource);
                IRI timemap = BaseCommonTests.rdf.createIRI(resource + MementoTests.TIMEMAP_QUERY_ARG);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.OriginalResource));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.TimeGate));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, Memento.timegate, (RDFTerm)original));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, Memento.timemap, (RDFTerm)timemap));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, Memento.memento, null));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)timemap, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.TimeMap));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)timemap, Time.hasBeginning, null));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)timemap, Time.hasEnd, null));
                Assertions.assertTrue((boolean)g.contains(null, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.Memento));
                g.stream((BlankNodeOrIRI)original, Memento.memento, null).map(x -> (IRI)x.getObject()).forEach(memento -> {
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.Memento));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Memento.original, (RDFTerm)original));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Memento.timegate, (RDFTerm)original));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Memento.timemap, (RDFTerm)timemap));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Memento.mementoDatetime, null));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Time.hasTime, null));
                });
            }
        }

        @Test
        @DisplayName(value="Test content negotiation on timemap resource: n-triples")
        public void testTimeMapConnegNTriples() {
            try (Response res = BaseCommonTests.target(resource + MementoTests.TIMEMAP_QUERY_ARG).request().accept(new String[]{"application/n-triples"}).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getMediaType().isCompatible(RdfMediaType.APPLICATION_N_TRIPLES_TYPE));
                Assertions.assertTrue((boolean)RdfMediaType.APPLICATION_N_TRIPLES_TYPE.isCompatible(res.getMediaType()));
                Graph g = MementoTests.this.readEntityAsGraph(res.getEntity(), RDFSyntax.NTRIPLES);
                IRI original = BaseCommonTests.rdf.createIRI(resource);
                IRI timemap = BaseCommonTests.rdf.createIRI(resource + MementoTests.TIMEMAP_QUERY_ARG);
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.OriginalResource));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.TimeGate));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, Memento.timegate, (RDFTerm)original));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, Memento.timemap, (RDFTerm)timemap));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)original, Memento.memento, null));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)timemap, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.TimeMap));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)timemap, Time.hasBeginning, null));
                Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)timemap, Time.hasEnd, null));
                Assertions.assertTrue((boolean)g.contains(null, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.Memento));
                g.stream((BlankNodeOrIRI)original, Memento.memento, null).map(x -> (IRI)x.getObject()).forEach(memento -> {
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, org.trellisldp.vocabulary.RDF.type, (RDFTerm)Memento.Memento));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Memento.original, (RDFTerm)original));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Memento.timegate, (RDFTerm)original));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Memento.timemap, (RDFTerm)timemap));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Memento.mementoDatetime, null));
                    Assertions.assertTrue((boolean)g.contains((BlankNodeOrIRI)memento, Time.hasTime, null));
                });
            }
        }

        @Test
        @DisplayName(value="Test allowed methods on timemap resource")
        public void testTimeMapAllowedMethods() {
            try (Response res = BaseCommonTests.target(resource + MementoTests.TIMEMAP_QUERY_ARG).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getAllowedMethods().contains("GET"));
                Assertions.assertTrue((boolean)res.getAllowedMethods().contains("HEAD"));
                Assertions.assertTrue((boolean)res.getAllowedMethods().contains("OPTIONS"));
                Assertions.assertFalse((boolean)res.getAllowedMethods().contains("POST"));
                Assertions.assertFalse((boolean)res.getAllowedMethods().contains("PUT"));
                Assertions.assertFalse((boolean)res.getAllowedMethods().contains(MementoTests.PATCH));
                Assertions.assertFalse((boolean)res.getAllowedMethods().contains("DELETE"));
            }
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @DisplayName(value="Memento timegate tests")
    public class TimeGateTests {
        @Test
        @DisplayName(value="Test the presence of a Vary: Accept-DateTime header")
        public void testAcceptDateTimeHeader() {
            try (Response res = BaseCommonTests.target(resource).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)res.getHeaderString("Vary").contains("Accept-Datetime"));
            }
        }

        @Test
        @DisplayName(value="Test the presence of a rel=timegate Link header")
        public void testTimeGateLinkHeader() {
            try (Response res = BaseCommonTests.target(resource).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().filter(l -> l.getRels().contains("timegate") && l.getUri().toString().equals(resource)).findFirst().isPresent());
            }
        }

        @Test
        @DisplayName(value="Test the presence of a rel=original Link header")
        public void testOriginalLinkHeader() {
            try (Response res = BaseCommonTests.target(resource).request().get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertTrue((boolean)BaseCommonTests.getLinks(res).stream().filter(l -> l.getRels().contains("original") && l.getUri().toString().equals(resource)).findFirst().isPresent());
            }
        }

        @Test
        @DisplayName(value="Test redirection of a timeget request")
        public void testTimeGateRedirect() {
            Instant time = Instant.now();
            try (Response res = BaseCommonTests.target(resource).request().property("jersey.config.client.followRedirects", (Object)Boolean.FALSE).header("Accept-Datetime", (Object)DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC).format(time)).get();){
                Assertions.assertEquals((Object)Response.Status.Family.REDIRECTION, (Object)res.getStatusInfo().getFamily());
                Assertions.assertNotNull((Object)res.getLocation());
            }
        }

        @Test
        @DisplayName(value="Test normal redirection of a timeget request")
        public void testTimeGateRedirected() {
            Instant time = Instant.now();
            try (Response res = BaseCommonTests.target(resource).request().header("Accept-Datetime", (Object)DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC).format(time)).get();){
                Assertions.assertEquals((Object)Response.Status.Family.SUCCESSFUL, (Object)res.getStatusInfo().getFamily());
                Assertions.assertNotNull((Object)res.getHeaderString("Memento-Datetime"));
            }
        }

        @Test
        @DisplayName(value="Test bad timegate request")
        public void testBadTimeGateRequest() {
            Instant time = Instant.now();
            try (Response res = BaseCommonTests.target(resource).request().header("Accept-Datetime", (Object)"unparseable date string").get();){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
            }
        }

        @Test
        @DisplayName(value="Test timegate request that predates creation")
        public void testTimeGateNotFound() {
            Instant time = Instant.now().minusSeconds(1000000L);
            try (Response res = BaseCommonTests.target(resource).request().header("Accept-Datetime", (Object)DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC).format(time)).get();){
                Assertions.assertEquals((Object)Response.Status.Family.CLIENT_ERROR, (Object)res.getStatusInfo().getFamily());
                Assertions.assertEquals((Object)Response.Status.NOT_FOUND, (Object)Response.Status.fromStatusCode((int)res.getStatus()));
            }
        }
    }
}

