/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.triplestore;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.jena.commonsrdf.JenaCommonsRDF;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trellisldp.api.BinaryMetadata;
import org.trellisldp.api.RDFFactory;
import org.trellisldp.api.Resource;
import org.trellisldp.api.TrellisUtils;
import org.trellisldp.triplestore.TriplestoreUtils;
import org.trellisldp.vocabulary.DC;
import org.trellisldp.vocabulary.LDP;
import org.trellisldp.vocabulary.Trellis;

public class TriplestoreResource
implements Resource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriplestoreResource.class);
    private static final RDF rdf = RDFFactory.getInstance();
    private static final Set<IRI> containerTypes = Set.of(LDP.Container, LDP.BasicContainer, LDP.DirectContainer, LDP.IndirectContainer);
    private final IRI identifier;
    private final RDFConnection rdfConnection;
    private final boolean includeLdpType;
    private final Map<IRI, String> extensions = new HashMap<IRI, String>();
    private final Map<IRI, RDFTerm> data = new HashMap<IRI, RDFTerm>();
    private final Map<IRI, Supplier<Stream<Quad>>> graphMapper = new HashMap<IRI, Supplier<Stream<Quad>>>();

    public TriplestoreResource(RDFConnection rdfConnection, IRI identifier, Map<String, IRI> extensions, boolean includeLdpType) {
        this.identifier = identifier;
        this.rdfConnection = rdfConnection;
        this.includeLdpType = includeLdpType;
        this.graphMapper.put(Trellis.PreferUserManaged, this::fetchUserQuads);
        this.graphMapper.put(Trellis.PreferServerManaged, this::fetchServerQuads);
        this.graphMapper.put(Trellis.PreferAudit, this::fetchAuditQuads);
        this.graphMapper.put(Trellis.PreferAccessControl, this::fetchAclQuads);
        this.graphMapper.put(LDP.PreferContainment, this::fetchContainmentQuads);
        this.graphMapper.put(LDP.PreferMembership, this::fetchMembershipQuads);
        extensions.forEach((k, v) -> {
            if (!this.graphMapper.containsKey(v)) {
                this.extensions.put((IRI)v, (String)k);
            }
        });
    }

    public static CompletableFuture<Resource> findResource(RDFConnection rdfConnection, IRI identifier, Map<String, IRI> extensions, boolean includeLdpType) {
        return CompletableFuture.supplyAsync(() -> {
            TriplestoreResource res = new TriplestoreResource(rdfConnection, TrellisUtils.normalizeIdentifier((IRI)identifier), extensions, includeLdpType);
            res.fetchData();
            if (!res.exists()) {
                return Resource.SpecialResources.MISSING_RESOURCE;
            }
            if (res.isDeleted()) {
                return Resource.SpecialResources.DELETED_RESOURCE;
            }
            return res;
        });
    }

    protected boolean exists() {
        return this.getModified() != null && this.getInteractionModel() != null;
    }

    protected boolean isDeleted() {
        return this.asIRI(DC.type).filter(Predicate.isEqual(Trellis.DeletedResource)).isPresent();
    }

    protected void fetchData() {
        LOGGER.debug("Fetching data from RDF datastore for: {}", (Object)this.identifier);
        Var binarySubject = Var.alloc((String)"binarySubject");
        Var binaryPredicate = Var.alloc((String)"binaryPredicate");
        Var binaryObject = Var.alloc((String)"binaryObject");
        Query q = new Query();
        q.setQuerySelectType();
        q.addResultVar((Node)TriplestoreUtils.PREDICATE);
        q.addResultVar((Node)TriplestoreUtils.OBJECT);
        q.addResultVar((Node)binarySubject);
        q.addResultVar((Node)binaryPredicate);
        q.addResultVar((Node)binaryObject);
        ElementPathBlock epb1 = new ElementPathBlock();
        epb1.addTriple(Triple.create((Node)JenaCommonsRDF.toJena((RDFTerm)this.identifier), (Node)TriplestoreUtils.PREDICATE, (Node)TriplestoreUtils.OBJECT));
        ElementPathBlock epb2 = new ElementPathBlock();
        epb2.addTriple(Triple.create((Node)JenaCommonsRDF.toJena((RDFTerm)this.identifier), (Node)JenaCommonsRDF.toJena((RDFTerm)DC.hasPart), (Node)binarySubject));
        epb2.addTriple(Triple.create((Node)JenaCommonsRDF.toJena((RDFTerm)this.identifier), (Node)org.apache.jena.vocabulary.RDF.type.asNode(), (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.NonRDFSource)));
        epb2.addTriple(Triple.create((Node)binarySubject, (Node)binaryPredicate, (Node)binaryObject));
        ElementGroup elg = new ElementGroup();
        elg.addElement((Element)epb1);
        elg.addElement((Element)new ElementOptional((Element)epb2));
        q.setQueryPattern((Element)new ElementNamedGraph(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged), (Element)elg));
        this.rdfConnection.querySelect(q, qs -> {
            RDFNode s = qs.get("binarySubject");
            RDFNode p = qs.get("binaryPredicate");
            RDFNode o = qs.get("binaryObject");
            TriplestoreUtils.nodesToTriple(s, p, o).ifPresent(t -> this.data.put(t.getPredicate(), t.getObject()));
            this.data.put(TriplestoreUtils.getPredicate(qs), TriplestoreUtils.getObject(qs));
        });
    }

    public Optional<IRI> getContainer() {
        return this.asIRI(DC.isPartOf);
    }

    public Stream<Quad> stream() {
        return Stream.concat(this.graphMapper.values().stream().flatMap(Supplier::get), this.extensions.keySet().stream().flatMap(this::fetchExtensionQuads));
    }

    public Stream<Quad> stream(Collection<IRI> graphNames) {
        return Stream.concat(graphNames.stream().filter(this.graphMapper::containsKey).map(this.graphMapper::get).flatMap(Supplier::get), graphNames.stream().filter(this.extensions::containsKey).flatMap(this::fetchExtensionQuads));
    }

    public IRI getIdentifier() {
        return this.identifier;
    }

    public IRI getInteractionModel() {
        return this.asIRI(org.trellisldp.vocabulary.RDF.type).orElse(null);
    }

    public Optional<IRI> getMembershipResource() {
        return this.asIRI(LDP.membershipResource);
    }

    public Optional<IRI> getMemberRelation() {
        return this.asIRI(LDP.hasMemberRelation);
    }

    public Optional<IRI> getMemberOfRelation() {
        return this.asIRI(LDP.isMemberOfRelation);
    }

    public Optional<IRI> getInsertedContentRelation() {
        return this.asIRI(LDP.insertedContentRelation);
    }

    public Optional<BinaryMetadata> getBinaryMetadata() {
        return this.asIRI(DC.hasPart).map(id -> BinaryMetadata.builder((IRI)id).mimeType((String)this.asLiteral(DC.format).orElse(null)).build());
    }

    public Instant getModified() {
        return this.asLiteral(DC.modified).map(Instant::parse).orElse(null);
    }

    public boolean hasMetadata(IRI graph) {
        if (Trellis.PreferAccessControl.equals((Object)graph)) {
            return this.fetchAclQuads().findAny().isPresent();
        }
        if (Trellis.PreferAudit.equals((Object)graph)) {
            return this.fetchAuditQuads().findAny().isPresent();
        }
        return this.extensions.containsKey(graph) && this.fetchExtensionQuads(graph).findAny().isPresent();
    }

    public Set<IRI> getMetadataGraphNames() {
        HashSet<IRI> graphs = new HashSet<IRI>(this.extensions.keySet().stream().filter(this::hasMetadata).collect(Collectors.toSet()));
        if (this.hasMetadata(Trellis.PreferAccessControl)) {
            graphs.add(Trellis.PreferAccessControl);
        }
        if (this.hasMetadata(Trellis.PreferAudit)) {
            graphs.add(Trellis.PreferAudit);
        }
        return Collections.unmodifiableSet(graphs);
    }

    private Stream<Quad> fetchAllFromGraph(String fromGraphName, IRI toGraphName) {
        Query q = new Query();
        q.setQuerySelectType();
        q.addResultVar((Node)TriplestoreUtils.SUBJECT);
        q.addResultVar((Node)TriplestoreUtils.PREDICATE);
        q.addResultVar((Node)TriplestoreUtils.OBJECT);
        ElementPathBlock epb = new ElementPathBlock();
        epb.addTriple(Triple.create((Node)TriplestoreUtils.SUBJECT, (Node)TriplestoreUtils.PREDICATE, (Node)TriplestoreUtils.OBJECT));
        ElementGroup elg = new ElementGroup();
        elg.addElement((Element)new ElementNamedGraph(NodeFactory.createURI((String)fromGraphName), (Element)epb));
        q.setQueryPattern((Element)elg);
        Stream.Builder builder = Stream.builder();
        this.rdfConnection.querySelect(q, qs -> builder.accept(rdf.createQuad((BlankNodeOrIRI)toGraphName, TriplestoreUtils.getSubject(qs), TriplestoreUtils.getPredicate(qs), TriplestoreUtils.getObject(qs))));
        return builder.build();
    }

    private Stream<Quad> fetchAuditQuads() {
        return this.fetchAllFromGraph(this.identifier.getIRIString() + "?ext=audit", Trellis.PreferAudit);
    }

    private Stream<Quad> fetchAclQuads() {
        return this.fetchAllFromGraph(this.identifier.getIRIString() + "?ext=acl", Trellis.PreferAccessControl);
    }

    private Stream<Quad> fetchMembershipQuads() {
        return Stream.concat(this.fetchIndirectMemberQuads(), Stream.concat(this.fetchDirectMemberQuads(), this.fetchDirectMemberQuadsInverse()));
    }

    private Stream<Quad> fetchIndirectMemberQuads() {
        Var s = Var.alloc((String)"s");
        Var o = Var.alloc((String)"o");
        Var res = Var.alloc((String)"res");
        Query q = new Query();
        q.setQuerySelectType();
        q.addResultVar((Node)TriplestoreUtils.SUBJECT);
        q.addResultVar((Node)TriplestoreUtils.PREDICATE);
        q.addResultVar((Node)TriplestoreUtils.OBJECT);
        ElementPathBlock epb1 = new ElementPathBlock();
        epb1.addTriple(Triple.create((Node)s, (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.member), (Node)JenaCommonsRDF.toJena((RDFTerm)this.identifier)));
        epb1.addTriple(Triple.create((Node)s, (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.membershipResource), (Node)TriplestoreUtils.SUBJECT));
        epb1.addTriple(Triple.create((Node)s, (Node)org.apache.jena.vocabulary.RDF.type.asNode(), (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.IndirectContainer)));
        epb1.addTriple(Triple.create((Node)s, (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.hasMemberRelation), (Node)TriplestoreUtils.PREDICATE));
        epb1.addTriple(Triple.create((Node)s, (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.insertedContentRelation), (Node)o));
        epb1.addTriple(Triple.create((Node)res, (Node)JenaCommonsRDF.toJena((RDFTerm)DC.isPartOf), (Node)s));
        ElementPathBlock epb2 = new ElementPathBlock();
        epb2.addTriple(Triple.create((Node)res, (Node)o, (Node)TriplestoreUtils.OBJECT));
        ElementGroup elg = new ElementGroup();
        elg.addElement((Element)new ElementNamedGraph(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged), (Element)epb1));
        elg.addElement((Element)new ElementNamedGraph((Node)res, (Element)epb2));
        q.setQueryPattern((Element)elg);
        Stream.Builder builder = Stream.builder();
        this.rdfConnection.querySelect(q, qs -> builder.accept(rdf.createQuad((BlankNodeOrIRI)LDP.PreferMembership, TriplestoreUtils.getSubject(qs), TriplestoreUtils.getPredicate(qs), TriplestoreUtils.getObject(qs))));
        return builder.build();
    }

    private Stream<Quad> fetchDirectMemberQuads() {
        Query q = new Query();
        q.setQuerySelectType();
        q.addResultVar((Node)TriplestoreUtils.SUBJECT);
        q.addResultVar((Node)TriplestoreUtils.PREDICATE);
        q.addResultVar((Node)TriplestoreUtils.OBJECT);
        q.addResultVar((Node)TriplestoreUtils.TYPE);
        Var s = Var.alloc((String)"s");
        ElementPathBlock epb = new ElementPathBlock();
        epb.addTriple(Triple.create((Node)s, (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.member), (Node)JenaCommonsRDF.toJena((RDFTerm)this.identifier)));
        epb.addTriple(Triple.create((Node)s, (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.membershipResource), (Node)TriplestoreUtils.SUBJECT));
        epb.addTriple(Triple.create((Node)s, (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.hasMemberRelation), (Node)TriplestoreUtils.PREDICATE));
        epb.addTriple(Triple.create((Node)s, (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.insertedContentRelation), (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.MemberSubject)));
        epb.addTriple(Triple.create((Node)TriplestoreUtils.OBJECT, (Node)JenaCommonsRDF.toJena((RDFTerm)DC.isPartOf), (Node)s));
        epb.addTriple(Triple.create((Node)TriplestoreUtils.OBJECT, (Node)org.apache.jena.vocabulary.RDF.type.asNode(), (Node)TriplestoreUtils.TYPE));
        ElementNamedGraph ng = new ElementNamedGraph(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged), (Element)epb);
        ElementGroup elg = new ElementGroup();
        elg.addElement((Element)ng);
        q.setQueryPattern((Element)elg);
        Stream.Builder builder = Stream.builder();
        this.rdfConnection.querySelect(q, qs -> builder.accept(rdf.createQuad((BlankNodeOrIRI)LDP.PreferMembership, TriplestoreUtils.getSubject(qs), TriplestoreUtils.getPredicate(qs), (RDFTerm)TriplestoreResource.adjustIdentifier((IRI)TriplestoreUtils.getObject(qs), TriplestoreUtils.getType(qs)))));
        return builder.build();
    }

    private Stream<Quad> fetchDirectMemberQuadsInverse() {
        Query q = new Query();
        q.setQuerySelectType();
        q.addResultVar((Node)TriplestoreUtils.PREDICATE);
        q.addResultVar((Node)TriplestoreUtils.OBJECT);
        q.addResultVar((Node)TriplestoreUtils.TYPE);
        ElementPathBlock epb = new ElementPathBlock();
        epb.addTriple(Triple.create((Node)JenaCommonsRDF.toJena((RDFTerm)this.identifier), (Node)JenaCommonsRDF.toJena((RDFTerm)DC.isPartOf), (Node)TriplestoreUtils.SUBJECT));
        epb.addTriple(Triple.create((Node)TriplestoreUtils.SUBJECT, (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.isMemberOfRelation), (Node)TriplestoreUtils.PREDICATE));
        epb.addTriple(Triple.create((Node)TriplestoreUtils.SUBJECT, (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.membershipResource), (Node)TriplestoreUtils.OBJECT));
        epb.addTriple(Triple.create((Node)TriplestoreUtils.SUBJECT, (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.insertedContentRelation), (Node)JenaCommonsRDF.toJena((RDFTerm)LDP.MemberSubject)));
        epb.addTriple(Triple.create((Node)TriplestoreUtils.OBJECT, (Node)org.apache.jena.vocabulary.RDF.type.asNode(), (Node)TriplestoreUtils.TYPE));
        ElementNamedGraph ng = new ElementNamedGraph(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged), (Element)epb);
        ElementGroup elg = new ElementGroup();
        elg.addElement((Element)ng);
        q.setQueryPattern((Element)elg);
        Stream.Builder builder = Stream.builder();
        IRI ixnModel = this.getInteractionModel();
        IRI subject = TriplestoreResource.adjustIdentifier(this.identifier, ixnModel);
        this.rdfConnection.querySelect(q, qs -> builder.accept(rdf.createQuad((BlankNodeOrIRI)LDP.PreferMembership, (BlankNodeOrIRI)subject, TriplestoreUtils.getPredicate(qs), TriplestoreUtils.getObject(qs))));
        return builder.build();
    }

    private Stream<Quad> fetchContainmentQuads() {
        if (this.getInteractionModel().getIRIString().endsWith("Container")) {
            Query q = new Query();
            q.setQuerySelectType();
            q.addResultVar((Node)TriplestoreUtils.OBJECT);
            q.addResultVar((Node)TriplestoreUtils.TYPE);
            ElementPathBlock epb = new ElementPathBlock();
            epb.addTriple(Triple.create((Node)TriplestoreUtils.OBJECT, (Node)JenaCommonsRDF.toJena((RDFTerm)DC.isPartOf), (Node)JenaCommonsRDF.toJena((RDFTerm)this.identifier)));
            epb.addTriple(Triple.create((Node)TriplestoreUtils.OBJECT, (Node)org.apache.jena.vocabulary.RDF.type.asNode(), (Node)TriplestoreUtils.TYPE));
            ElementNamedGraph ng = new ElementNamedGraph(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged), (Element)epb);
            ElementGroup elg = new ElementGroup();
            elg.addElement((Element)ng);
            q.setQueryPattern((Element)elg);
            Stream.Builder builder = Stream.builder();
            IRI ixnModel = this.getInteractionModel();
            IRI subject = TriplestoreResource.adjustIdentifier(this.identifier, ixnModel);
            this.rdfConnection.querySelect(q, qs -> builder.accept(rdf.createQuad((BlankNodeOrIRI)LDP.PreferContainment, (BlankNodeOrIRI)subject, LDP.contains, (RDFTerm)TriplestoreResource.adjustIdentifier((IRI)TriplestoreUtils.getObject(qs), TriplestoreUtils.getType(qs)))));
            return builder.build();
        }
        return Stream.empty();
    }

    private Stream<Quad> fetchExtensionQuads(IRI graphName) {
        return this.fetchAllFromGraph(this.identifier.getIRIString() + "?ext=" + this.extensions.get(graphName), graphName);
    }

    private Stream<Quad> fetchUserQuads() {
        return this.fetchAllFromGraph(this.identifier.getIRIString(), Trellis.PreferUserManaged);
    }

    private Stream<Quad> fetchServerQuads() {
        if (this.includeLdpType) {
            IRI ixnModel = this.getInteractionModel();
            return Stream.of(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)TriplestoreResource.adjustIdentifier(this.identifier, ixnModel), org.trellisldp.vocabulary.RDF.type, (RDFTerm)ixnModel));
        }
        return Stream.empty();
    }

    private static IRI adjustIdentifier(IRI identifier, IRI type) {
        if (containerTypes.contains(type) && !identifier.getIRIString().endsWith("/")) {
            return rdf.createIRI(identifier.getIRIString() + "/");
        }
        return identifier;
    }

    private Optional<IRI> asIRI(IRI predicate) {
        return Optional.ofNullable(this.data.get(predicate)).filter(IRI.class::isInstance).map(IRI.class::cast);
    }

    private Optional<String> asLiteral(IRI predicate) {
        return Optional.ofNullable(this.data.get(predicate)).filter(Literal.class::isInstance).map(Literal.class::cast).map(Literal::getLexicalForm);
    }
}

