/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.triplestore;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.jena.commonsrdf.JenaCommonsRDF;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.modify.request.QuadDataAcc;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDeleteInsert;
import org.apache.jena.sparql.modify.request.UpdateDeleteWhere;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateRequest;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trellisldp.api.IdentifierService;
import org.trellisldp.api.Metadata;
import org.trellisldp.api.RDFFactory;
import org.trellisldp.api.Resource;
import org.trellisldp.api.ResourceService;
import org.trellisldp.api.TrellisRuntimeException;
import org.trellisldp.api.TrellisUtils;
import org.trellisldp.triplestore.TriplestoreResource;
import org.trellisldp.triplestore.TriplestoreUtils;
import org.trellisldp.vocabulary.ACL;
import org.trellisldp.vocabulary.DC;
import org.trellisldp.vocabulary.FOAF;
import org.trellisldp.vocabulary.LDP;
import org.trellisldp.vocabulary.Trellis;
import org.trellisldp.vocabulary.XSD;

@ApplicationScoped
public class TriplestoreResourceService
implements ResourceService {
    private static final String CONFIG_HTTP_EXTENSION_GRAPHS = "trellis.http.extension-graphs";
    public static final String CONFIG_TRIPLESTORE_RDF_LOCATION = "trellis.triplestore.rdf-location";
    public static final String CONFIG_TRIPLESTORE_LDP_TYPE = "trellis.triplestore.ldp-type";
    private static final String MODIFIED = "modified";
    private static final Logger LOGGER = LoggerFactory.getLogger(TriplestoreResourceService.class);
    private static final String ACL_EXT = "acl";
    private static final RDF rdf = RDFFactory.getInstance();
    private final Set<IRI> supportedIxnModels = Set.of(LDP.Resource, LDP.RDFSource, LDP.NonRDFSource, LDP.Container, LDP.BasicContainer, LDP.DirectContainer, LDP.IndirectContainer);
    private Supplier<String> supplier;
    private Map<String, IRI> extensions;
    @Inject
    @ConfigProperty(name="trellis.triplestore.ldp-type", defaultValue="true")
    boolean includeLdpType = true;
    @Inject
    @ConfigProperty(name="trellis.http.extension-graphs")
    Optional<String> extensionGraphConfig = Optional.empty();
    @Inject
    RDFConnection rdfConnection;
    @Inject
    IdentifierService idService;

    public CompletionStage<Void> delete(Metadata metadata) {
        LOGGER.debug("Deleting: {}", (Object)metadata.getIdentifier());
        return CompletableFuture.runAsync(() -> {
            try (org.apache.commons.rdf.api.Dataset dataset = rdf.createDataset();){
                Instant eventTime = Instant.now();
                dataset.add((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)metadata.getIdentifier(), DC.type, (RDFTerm)Trellis.DeletedResource);
                dataset.add((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)metadata.getIdentifier(), org.trellisldp.vocabulary.RDF.type, (RDFTerm)LDP.Resource);
                this.storeResource(metadata.getIdentifier(), dataset, eventTime, OperationType.DELETE);
            }
            catch (Exception ex) {
                throw new TrellisRuntimeException("Error deleting resource: " + metadata.getIdentifier(), (Throwable)ex);
            }
        });
    }

    public CompletionStage<Void> create(Metadata metadata, org.apache.commons.rdf.api.Dataset dataset) {
        LOGGER.debug("Creating: {}", (Object)metadata.getIdentifier());
        return CompletableFuture.runAsync(() -> this.createOrReplace(metadata, dataset, OperationType.CREATE));
    }

    public CompletionStage<Void> replace(Metadata metadata, org.apache.commons.rdf.api.Dataset dataset) {
        LOGGER.debug("Persisting: {}", (Object)metadata.getIdentifier());
        return CompletableFuture.runAsync(() -> this.createOrReplace(metadata, dataset, OperationType.REPLACE));
    }

    private void createOrReplace(Metadata metadata, org.apache.commons.rdf.api.Dataset dataset, OperationType operation) {
        Instant eventTime = Instant.now();
        dataset.add((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)metadata.getIdentifier(), org.trellisldp.vocabulary.RDF.type, (RDFTerm)metadata.getInteractionModel());
        metadata.getMembershipResource().ifPresent(member -> {
            dataset.add((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)metadata.getIdentifier(), LDP.member, (RDFTerm)TrellisUtils.normalizeIdentifier((IRI)member));
            dataset.add((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)metadata.getIdentifier(), LDP.membershipResource, (RDFTerm)member);
        });
        metadata.getMemberRelation().ifPresent(relation -> dataset.add((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)metadata.getIdentifier(), LDP.hasMemberRelation, (RDFTerm)relation));
        metadata.getMemberOfRelation().ifPresent(relation -> dataset.add((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)metadata.getIdentifier(), LDP.isMemberOfRelation, (RDFTerm)relation));
        if (Arrays.asList(LDP.IndirectContainer, LDP.DirectContainer).contains(metadata.getInteractionModel())) {
            dataset.add((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)metadata.getIdentifier(), LDP.insertedContentRelation, (RDFTerm)metadata.getInsertedContentRelation().orElse(LDP.MemberSubject));
        }
        metadata.getContainer().ifPresent(parent -> dataset.add((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)metadata.getIdentifier(), DC.isPartOf, (RDFTerm)parent));
        metadata.getBinary().ifPresent(binary -> {
            dataset.add((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)metadata.getIdentifier(), DC.hasPart, (RDFTerm)binary.getIdentifier());
            binary.getMimeType().map(arg_0 -> ((RDF)rdf).createLiteral(arg_0)).ifPresent(mimeType -> dataset.add((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)binary.getIdentifier(), DC.format, (RDFTerm)mimeType));
        });
        this.storeResource(metadata.getIdentifier(), dataset, eventTime, operation);
    }

    private void storeResource(IRI identifier, org.apache.commons.rdf.api.Dataset dataset, Instant eventTime, OperationType type) {
        Literal time = rdf.createLiteral(eventTime.toString(), XSD.dateTime);
        try {
            this.rdfConnection.update(this.buildUpdateRequest(identifier, time, dataset, type));
        }
        catch (Exception ex) {
            throw new TrellisRuntimeException("Could not update data for " + identifier, (Throwable)ex);
        }
    }

    private Node getExtIRI(IRI identifier, String ext) {
        return NodeFactory.createURI((String)(identifier.getIRIString() + "?ext=" + ext));
    }

    private UpdateRequest buildUpdateRequest(IRI identifier, Literal time, org.apache.commons.rdf.api.Dataset dataset, OperationType operation) {
        dataset.add((BlankNodeOrIRI)Trellis.PreferServerManaged, (BlankNodeOrIRI)identifier, DC.modified, (RDFTerm)time);
        UpdateRequest req = new UpdateRequest();
        req.add((Update)new UpdateDeleteWhere(new QuadAcc(Collections.singletonList(new Quad(JenaCommonsRDF.toJena((RDFTerm)identifier), (Node)TriplestoreUtils.SUBJECT, (Node)TriplestoreUtils.PREDICATE, (Node)TriplestoreUtils.OBJECT)))));
        this.extensions.forEach((ext, graph) -> req.add((Update)new UpdateDeleteWhere(new QuadAcc(Collections.singletonList(new Quad(this.getExtIRI(identifier, (String)ext), (Node)TriplestoreUtils.SUBJECT, (Node)TriplestoreUtils.PREDICATE, (Node)TriplestoreUtils.OBJECT))))));
        req.add((Update)new UpdateDeleteWhere(new QuadAcc(Arrays.asList(new Quad(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged), JenaCommonsRDF.toJena((RDFTerm)identifier), JenaCommonsRDF.toJena((RDFTerm)org.trellisldp.vocabulary.RDF.type), JenaCommonsRDF.toJena((RDFTerm)LDP.NonRDFSource)), new Quad(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged), JenaCommonsRDF.toJena((RDFTerm)identifier), JenaCommonsRDF.toJena((RDFTerm)DC.hasPart), (Node)TriplestoreUtils.SUBJECT), new Quad(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged), (Node)TriplestoreUtils.SUBJECT, (Node)TriplestoreUtils.PREDICATE, (Node)TriplestoreUtils.OBJECT)))));
        req.add((Update)new UpdateDeleteWhere(new QuadAcc(Collections.singletonList(new Quad(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged), JenaCommonsRDF.toJena((RDFTerm)identifier), (Node)TriplestoreUtils.PREDICATE, (Node)TriplestoreUtils.OBJECT)))));
        QuadDataAcc sink = new QuadDataAcc(Collections.synchronizedList(new ArrayList()));
        if (operation == OperationType.DELETE) {
            dataset.stream().filter(q -> q.getGraphName().filter(arg_0 -> ((IRI)Trellis.PreferServerManaged).equals(arg_0)).isPresent()).map(JenaCommonsRDF::toJena).forEach(arg_0 -> ((QuadDataAcc)sink).addQuad(arg_0));
        } else {
            dataset.stream().filter(q -> q.getGraphName().filter(arg_0 -> ((IRI)Trellis.PreferServerManaged).equals(arg_0)).isPresent()).map(JenaCommonsRDF::toJena).forEach(arg_0 -> ((QuadDataAcc)sink).addQuad(arg_0));
            dataset.getGraph((BlankNodeOrIRI)Trellis.PreferUserManaged).ifPresent(g -> g.stream().map(t -> new Quad(JenaCommonsRDF.toJena((RDFTerm)identifier), JenaCommonsRDF.toJena((org.apache.commons.rdf.api.Triple)t))).forEach(arg_0 -> ((QuadDataAcc)sink).addQuad(arg_0)));
            dataset.getGraph((BlankNodeOrIRI)Trellis.PreferAudit).ifPresent(g -> g.stream().map(t -> new Quad(this.getExtIRI(identifier, "audit"), JenaCommonsRDF.toJena((org.apache.commons.rdf.api.Triple)t))).forEach(arg_0 -> ((QuadDataAcc)sink).addQuad(arg_0)));
            this.extensions.forEach((ext, graph) -> dataset.getGraph((BlankNodeOrIRI)graph).ifPresent(g -> g.stream().map(t -> new Quad(this.getExtIRI(identifier, (String)ext), JenaCommonsRDF.toJena((org.apache.commons.rdf.api.Triple)t))).forEach(arg_0 -> ((QuadDataAcc)sink).addQuad(arg_0))));
        }
        req.add((Update)new UpdateDataInsert(sink));
        return req;
    }

    private UpdateRequest buildUpdateModificationRequest(IRI identifier, Literal time) {
        UpdateRequest req = new UpdateRequest();
        Var modified = Var.alloc((String)MODIFIED);
        UpdateDeleteInsert modify = new UpdateDeleteInsert();
        modify.setWithIRI(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged));
        modify.getDeleteAcc().addTriple(TriplestoreResourceService.triple(JenaCommonsRDF.toJena((RDFTerm)identifier), JenaCommonsRDF.toJena((RDFTerm)DC.modified), (Node)modified));
        modify.getInsertAcc().addTriple(TriplestoreResourceService.triple(JenaCommonsRDF.toJena((RDFTerm)identifier), JenaCommonsRDF.toJena((RDFTerm)DC.modified), JenaCommonsRDF.toJena((RDFTerm)time)));
        ElementGroup eg = new ElementGroup();
        ElementPathBlock epb = new ElementPathBlock();
        epb.addTriple(TriplestoreResourceService.triple(JenaCommonsRDF.toJena((RDFTerm)identifier), JenaCommonsRDF.toJena((RDFTerm)DC.modified), (Node)modified));
        eg.addElement((Element)epb);
        modify.setElement((Element)eg);
        req.add((Update)modify);
        return req;
    }

    @PostConstruct
    public void initialize() {
        this.extensions = this.extensionGraphConfig.map(TriplestoreResourceService::buildExtensionMap).orElseGet(() -> Map.of(ACL_EXT, Trellis.PreferAccessControl));
        this.supplier = this.idService.getSupplier();
        IRI root = rdf.createIRI("trellis:data/");
        Query q = new Query();
        q.setQuerySelectType();
        q.addResultVar((Node)TriplestoreUtils.OBJECT);
        ElementPathBlock epb = new ElementPathBlock();
        epb.addTriple(TriplestoreResourceService.triple(JenaCommonsRDF.toJena((RDFTerm)root), JenaCommonsRDF.toJena((RDFTerm)org.trellisldp.vocabulary.RDF.type), (Node)TriplestoreUtils.OBJECT));
        ElementNamedGraph ng = new ElementNamedGraph(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged), (Element)epb);
        ElementGroup elg = new ElementGroup();
        elg.addElement((Element)ng);
        q.setQueryPattern((Element)elg);
        Stream.Builder builder = Stream.builder();
        this.rdfConnection.querySelect(q, qs -> builder.accept(TriplestoreUtils.getObject(qs)));
        if (!builder.build().findFirst().isPresent()) {
            Literal time = rdf.createLiteral(Instant.now().toString(), XSD.dateTime);
            IRI auth = rdf.createIRI("trellis:data/#auth");
            UpdateRequest update = new UpdateRequest();
            QuadDataAcc sink = new QuadDataAcc();
            sink.addQuad(new Quad(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged), TriplestoreResourceService.triple(JenaCommonsRDF.toJena((RDFTerm)root), JenaCommonsRDF.toJena((RDFTerm)org.trellisldp.vocabulary.RDF.type), JenaCommonsRDF.toJena((RDFTerm)LDP.BasicContainer))));
            sink.addQuad(new Quad(JenaCommonsRDF.toJena((RDFTerm)Trellis.PreferServerManaged), TriplestoreResourceService.triple(JenaCommonsRDF.toJena((RDFTerm)root), JenaCommonsRDF.toJena((RDFTerm)DC.modified), JenaCommonsRDF.toJena((RDFTerm)time))));
            sink.addQuad(new Quad(this.getExtIRI(root, ACL_EXT), TriplestoreResourceService.triple(JenaCommonsRDF.toJena((RDFTerm)auth), JenaCommonsRDF.toJena((RDFTerm)ACL.mode), JenaCommonsRDF.toJena((RDFTerm)ACL.Read))));
            sink.addQuad(new Quad(this.getExtIRI(root, ACL_EXT), TriplestoreResourceService.triple(JenaCommonsRDF.toJena((RDFTerm)auth), JenaCommonsRDF.toJena((RDFTerm)ACL.mode), JenaCommonsRDF.toJena((RDFTerm)ACL.Write))));
            sink.addQuad(new Quad(this.getExtIRI(root, ACL_EXT), TriplestoreResourceService.triple(JenaCommonsRDF.toJena((RDFTerm)auth), JenaCommonsRDF.toJena((RDFTerm)ACL.mode), JenaCommonsRDF.toJena((RDFTerm)ACL.Control))));
            sink.addQuad(new Quad(this.getExtIRI(root, ACL_EXT), TriplestoreResourceService.triple(JenaCommonsRDF.toJena((RDFTerm)auth), JenaCommonsRDF.toJena((RDFTerm)ACL.agentClass), JenaCommonsRDF.toJena((RDFTerm)FOAF.Agent))));
            sink.addQuad(new Quad(this.getExtIRI(root, ACL_EXT), TriplestoreResourceService.triple(JenaCommonsRDF.toJena((RDFTerm)auth), JenaCommonsRDF.toJena((RDFTerm)ACL.accessTo), JenaCommonsRDF.toJena((RDFTerm)root))));
            update.add((Update)new UpdateDataInsert(sink));
            this.rdfConnection.update(update);
        }
        LOGGER.info("Initialized Trellis Triplestore Resource Service");
    }

    public CompletionStage<Resource> get(IRI identifier) {
        return TriplestoreResource.findResource(this.rdfConnection, identifier, this.extensions, this.includeLdpType);
    }

    public String generateIdentifier() {
        return this.supplier.get();
    }

    public CompletionStage<Void> add(IRI id, org.apache.commons.rdf.api.Dataset dataset) {
        return CompletableFuture.runAsync(() -> {
            IRI graphName = rdf.createIRI(id.getIRIString() + "?ext=audit");
            try (org.apache.commons.rdf.api.Dataset data = rdf.createDataset();){
                dataset.getGraph((BlankNodeOrIRI)Trellis.PreferAudit).ifPresent(g -> g.stream().forEach(t -> data.add((BlankNodeOrIRI)graphName, t.getSubject(), t.getPredicate(), t.getObject())));
                Txn.executeWrite((Transactional)this.rdfConnection, () -> this.rdfConnection.loadDataset(DatasetFactory.wrap((DatasetGraph)JenaCommonsRDF.toJena((org.apache.commons.rdf.api.Dataset)data))));
            }
            catch (Exception ex) {
                throw new TrellisRuntimeException("Error storing audit dataset for " + id, (Throwable)ex);
            }
        });
    }

    public CompletionStage<Void> touch(IRI identifier) {
        Literal time = rdf.createLiteral(Instant.now().toString(), XSD.dateTime);
        return CompletableFuture.runAsync(() -> {
            try {
                this.rdfConnection.update(this.buildUpdateModificationRequest(identifier, time));
            }
            catch (Exception ex) {
                throw new TrellisRuntimeException("Could not update data for " + identifier, (Throwable)ex);
            }
        });
    }

    public Set<IRI> supportedInteractionModels() {
        return this.supportedIxnModels;
    }

    public static RDFConnection buildRDFConnection(String location) {
        if (location != null) {
            if (location.startsWith("http://") || location.startsWith("https://")) {
                LOGGER.info("Using remote Triplestore for persistence at {}", (Object)location);
                return RDFConnectionFactory.connect((String)location);
            }
            LOGGER.info("Using local TDB2 database at {}", (Object)location);
            return RDFConnectionFactory.connect((Dataset)DatasetFactory.wrap((DatasetGraph)DatabaseMgr.connectDatasetGraph((String)location)));
        }
        LOGGER.info("Using an in-memory dataset for resources");
        return RDFConnectionFactory.connect((Dataset)DatasetFactory.createTxnMem());
    }

    static Triple triple(Node subj, Node pred, Node obj) {
        return Triple.create((Node)subj, (Node)pred, (Node)obj);
    }

    static Map<String, IRI> buildExtensionMap(String extensions) {
        return Arrays.stream(extensions.split(",")).map(item -> item.split("=")).filter(kv -> ((String[])kv).length == 2).filter(kv -> !kv[0].trim().isEmpty() && !kv[1].trim().isEmpty()).collect(Collectors.toMap(kv -> kv[0].trim(), kv -> rdf.createIRI(kv[1].trim())));
    }

    private static enum OperationType {
        DELETE,
        CREATE,
        REPLACE;

    }
}

