/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.triplestore;

import java.util.Optional;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.jena.commonsrdf.JenaCommonsRDF;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Var;

final class TriplestoreUtils {
    public static final Var SUBJECT = Var.alloc((String)"subject");
    public static final Var PREDICATE = Var.alloc((String)"predicate");
    public static final Var OBJECT = Var.alloc((String)"object");
    public static final Var TYPE = Var.alloc((String)"type");

    public static BlankNodeOrIRI getSubject(QuerySolution qs) {
        return (BlankNodeOrIRI)JenaCommonsRDF.fromJena((Node)qs.get("subject").asNode());
    }

    public static IRI getPredicate(QuerySolution qs) {
        return (IRI)JenaCommonsRDF.fromJena((Node)qs.get("predicate").asNode());
    }

    public static RDFTerm getObject(QuerySolution qs) {
        return JenaCommonsRDF.fromJena((Node)qs.get("object").asNode());
    }

    public static IRI getType(QuerySolution qs) {
        return (IRI)JenaCommonsRDF.fromJena((Node)qs.get("type").asNode());
    }

    public static Optional<Triple> nodesToTriple(RDFNode s, RDFNode p, RDFNode o) {
        if (s != null && p != null && o != null) {
            return Optional.of(JenaCommonsRDF.fromJena((org.apache.jena.graph.Triple)org.apache.jena.graph.Triple.create((Node)s.asNode(), (Node)p.asNode(), (Node)o.asNode())));
        }
        return Optional.empty();
    }

    private TriplestoreUtils() {
    }
}

