/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.webac;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.Triple;
import org.trellisldp.api.RDFFactory;
import org.trellisldp.vocabulary.ACL;

public class Authorization {
    private static final RDF rdf = RDFFactory.getInstance();
    private static final Set<IRI> predicates = new HashSet<IRI>(Arrays.asList(ACL.agent, ACL.agentClass, ACL.agentGroup, ACL.mode, ACL.accessTo, ACL.default_));
    private final BlankNodeOrIRI identifier;
    private final Map<IRI, Set<IRI>> dataMap;

    public static Authorization from(BlankNodeOrIRI identifier, Graph graph) {
        return new Authorization(identifier, graph);
    }

    public Authorization(BlankNodeOrIRI identifier, Graph graph) {
        this.identifier = Objects.requireNonNull(identifier, "The Authorization identifier may not be null!");
        Objects.requireNonNull(graph, "The input graph may not be null!");
        this.dataMap = graph.stream(identifier, null, null).filter(triple -> predicates.contains(triple.getPredicate())).filter(triple -> triple.getObject() instanceof IRI).collect(Collectors.groupingBy(Triple::getPredicate, Collectors.mapping(Authorization::normalizeIdentifier, Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet))));
    }

    static IRI normalizeIdentifier(Triple triple) {
        if (triple.getObject() instanceof IRI) {
            String obj;
            if ((triple.getPredicate().equals((Object)ACL.accessTo) || triple.getPredicate().equals((Object)ACL.default_)) && (obj = ((IRI)triple.getObject()).getIRIString()).endsWith("/") && !obj.equals("trellis:data/")) {
                return rdf.createIRI(obj.substring(0, obj.length() - 1));
            }
            return (IRI)triple.getObject();
        }
        return null;
    }

    public BlankNodeOrIRI getIdentifier() {
        return this.identifier;
    }

    public Set<IRI> getAgent() {
        return this.dataMap.getOrDefault(ACL.agent, Collections.emptySet());
    }

    public Set<IRI> getAgentClass() {
        return this.dataMap.getOrDefault(ACL.agentClass, Collections.emptySet());
    }

    public Set<IRI> getAgentGroup() {
        return this.dataMap.getOrDefault(ACL.agentGroup, Collections.emptySet());
    }

    public Set<IRI> getMode() {
        return this.dataMap.getOrDefault(ACL.mode, Collections.emptySet());
    }

    public Set<IRI> getAccessTo() {
        return this.dataMap.getOrDefault(ACL.accessTo, Collections.emptySet());
    }

    public Set<IRI> getDefault() {
        return this.dataMap.getOrDefault(ACL.default_, Collections.emptySet());
    }
}

