/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.webac;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trellisldp.api.RDFFactory;
import org.trellisldp.api.ResourceService;
import org.trellisldp.api.Session;
import org.trellisldp.common.HttpSession;
import org.trellisldp.common.LdpResource;
import org.trellisldp.common.Prefer;
import org.trellisldp.common.TrellisRequest;
import org.trellisldp.vocabulary.ACL;
import org.trellisldp.vocabulary.Trellis;
import org.trellisldp.webac.AuthorizedModes;
import org.trellisldp.webac.WebAcService;

@Provider
@Priority(value=2000)
@LdpResource
public class WebAcFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String CONFIG_WEBAC_CHALLENGES = "trellis.webac.challenges";
    public static final String CONFIG_WEBAC_READABLE_METHODS = "trellis.webac.readable-methods";
    public static final String CONFIG_WEBAC_WRITABLE_METHODS = "trellis.webac.writable-methods";
    public static final String CONFIG_WEBAC_APPENDABLE_METHODS = "trellis.webac.appendable-methods";
    public static final String CONFIG_WEBAC_REALM = "trellis.webac.realm";
    public static final String CONFIG_WEBAC_SCOPE = "trellis.webac.scope";
    public static final String CONFIG_WEBAC_ENABED = "trellis.webac.enabled";
    public static final String SESSION_WEBAC_MODES = "trellis.webac.session-modes";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAcFilter.class);
    private static final Set<String> readable = new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS"));
    private static final Set<String> writable = new HashSet<String>(Arrays.asList("PUT", "PATCH", "DELETE"));
    private static final Set<String> appendable = new HashSet<String>(Collections.singletonList("POST"));
    private static final String SLASH = "/";
    private static final RDF rdf = RDFFactory.getInstance();
    @Inject
    WebAcService accessService;
    @Inject
    ResourceService resourceService;
    List<String> challenges;
    String baseUrl;
    private final boolean enabled;

    public WebAcFilter() {
        Config config = ConfigProvider.getConfig();
        String realm = config.getOptionalValue(CONFIG_WEBAC_REALM, String.class).orElse("trellis");
        String scope = config.getOptionalValue(CONFIG_WEBAC_SCOPE, String.class).orElse("");
        this.challenges = Arrays.stream(config.getOptionalValue(CONFIG_WEBAC_CHALLENGES, String.class).orElse("").split(",")).map(String::trim).map(ch -> WebAcFilter.buildChallenge(ch, realm, scope)).collect(Collectors.toList());
        this.baseUrl = config.getOptionalValue("trellis.http.base-url", String.class).orElse(null);
        this.enabled = config.getOptionalValue(CONFIG_WEBAC_ENABED, Boolean.class).orElse(Boolean.TRUE);
        config.getOptionalValue(CONFIG_WEBAC_READABLE_METHODS, String.class).ifPresent(r -> Arrays.stream(r.split(",")).map(String::trim).map(String::toUpperCase).forEach(readable::add));
        config.getOptionalValue(CONFIG_WEBAC_WRITABLE_METHODS, String.class).ifPresent(w -> Arrays.stream(w.split(",")).map(String::trim).map(String::toUpperCase).forEach(writable::add));
        config.getOptionalValue(CONFIG_WEBAC_APPENDABLE_METHODS, String.class).ifPresent(a -> Arrays.stream(a.split(",")).map(String::trim).map(String::toUpperCase).forEach(appendable::add));
    }

    @Timed
    public void filter(ContainerRequestContext ctx) {
        if (!this.enabled) {
            return;
        }
        String path = ctx.getUriInfo().getPath();
        String base = WebAcFilter.getBaseUrl(ctx, this.baseUrl);
        Session s = WebAcFilter.buildSession(ctx, this.baseUrl);
        String method = ctx.getMethod();
        IRI resourceIdentifier = this.resourceService.getResourceIdentifier(base, path);
        AuthorizedModes modes = this.accessService.getAuthorizedModes(resourceIdentifier, s);
        ctx.setProperty(SESSION_WEBAC_MODES, (Object)modes);
        Prefer prefer = Prefer.valueOf((String)ctx.getHeaderString("Prefer"));
        if (((List)ctx.getUriInfo().getQueryParameters().getOrDefault((Object)"ext", Collections.emptyList())).contains("acl") || WebAcFilter.reqAudit(prefer)) {
            this.verifyCanControl(modes.getAccessModes(), s, resourceIdentifier.getIRIString());
        } else {
            if (readable.contains(method) || WebAcFilter.reqRepresentation(prefer)) {
                this.verifyCanRead(modes.getAccessModes(), s, resourceIdentifier.getIRIString());
            }
            if (writable.contains(method)) {
                this.verifyCanWrite(modes.getAccessModes(), s, resourceIdentifier.getIRIString());
            }
            if (appendable.contains(method)) {
                this.verifyCanAppend(modes.getAccessModes(), s, resourceIdentifier.getIRIString());
            }
        }
    }

    public void filter(ContainerRequestContext req, ContainerResponseContext res) {
        AuthorizedModes modes;
        Object sessionModes = req.getProperty(SESSION_WEBAC_MODES);
        if (Response.Status.Family.SUCCESSFUL.equals((Object)res.getStatusInfo().getFamily()) && !"DELETE".equals(req.getMethod()) && sessionModes instanceof AuthorizedModes && (modes = (AuthorizedModes)sessionModes).getAccessModes().contains(ACL.Control)) {
            boolean isAcl = ((List)req.getUriInfo().getQueryParameters().getOrDefault((Object)"ext", Collections.emptyList())).contains("acl");
            String rel = isAcl ? "acl self" : "acl";
            String path = req.getUriInfo().getPath();
            res.getHeaders().add((Object)"Link", (Object)Link.fromUri((URI)UriBuilder.fromPath((String)(path.startsWith(SLASH) ? path : SLASH + path)).queryParam("ext", new Object[]{"acl"}).build(new Object[0])).rel(rel).build(new Object[0]));
            modes.getEffectiveAcl().map(IRI::getIRIString).map(acl -> WebAcFilter.effectiveAclToUrlPath(acl, path, res)).ifPresent(urlPath -> res.getHeaders().add((Object)"Link", (Object)Link.fromUri((URI)UriBuilder.fromPath((String)urlPath).queryParam("ext", new Object[]{"acl"}).build(new Object[0])).rel(Trellis.effectiveAcl.getIRIString()).build(new Object[0])));
        }
    }

    protected void verifyCanAppend(Set<IRI> modes, Session session, String path) {
        if (!modes.contains(ACL.Append) && !modes.contains(ACL.Write)) {
            LOGGER.debug("User: {} cannot Append to {}", (Object)session.getAgent(), (Object)path);
            if (Trellis.AnonymousAgent.equals((Object)session.getAgent())) {
                throw new NotAuthorizedException((Object)this.challenges.get(0), this.challenges.subList(1, this.challenges.size()).toArray());
            }
            throw new ForbiddenException();
        }
        LOGGER.trace("User: {} can append to {}", (Object)session.getAgent(), (Object)path);
    }

    protected void verifyCanControl(Set<IRI> modes, Session session, String path) {
        if (!modes.contains(ACL.Control)) {
            LOGGER.debug("User: {} cannot Control {}", (Object)session.getAgent(), (Object)path);
            if (Trellis.AnonymousAgent.equals((Object)session.getAgent())) {
                throw new NotAuthorizedException((Object)this.challenges.get(0), this.challenges.subList(1, this.challenges.size()).toArray());
            }
            throw new ForbiddenException();
        }
        LOGGER.trace("User: {} can control {}", (Object)session.getAgent(), (Object)path);
    }

    protected void verifyCanWrite(Set<IRI> modes, Session session, String path) {
        if (!modes.contains(ACL.Write)) {
            LOGGER.debug("User: {} cannot Write to {}", (Object)session.getAgent(), (Object)path);
            if (Trellis.AnonymousAgent.equals((Object)session.getAgent())) {
                throw new NotAuthorizedException((Object)this.challenges.get(0), this.challenges.subList(1, this.challenges.size()).toArray());
            }
            throw new ForbiddenException();
        }
        LOGGER.trace("User: {} can write to {}", (Object)session.getAgent(), (Object)path);
    }

    protected void verifyCanRead(Set<IRI> modes, Session session, String path) {
        if (!modes.contains(ACL.Read)) {
            LOGGER.debug("User: {} cannot Read from {}", (Object)session.getAgent(), (Object)path);
            if (Trellis.AnonymousAgent.equals((Object)session.getAgent())) {
                throw new NotAuthorizedException((Object)this.challenges.get(0), this.challenges.subList(1, this.challenges.size()).toArray());
            }
            throw new ForbiddenException();
        }
        LOGGER.trace("User: {} can read {}", (Object)session.getAgent(), (Object)path);
    }

    static boolean reqAudit(Prefer prefer) {
        return prefer != null && prefer.getInclude().contains(Trellis.PreferAudit.getIRIString());
    }

    static boolean reqRepresentation(Prefer prefer) {
        return prefer != null && prefer.getPreference().filter(Predicate.isEqual("representation")).isPresent();
    }

    static String getBaseUrl(ContainerRequestContext ctx, String baseUrl) {
        if (baseUrl != null) {
            return baseUrl;
        }
        return TrellisRequest.buildBaseUrl((URI)ctx.getUriInfo().getBaseUri(), (MultivaluedMap)ctx.getHeaders());
    }

    static Session buildSession(ContainerRequestContext ctx, String baseUrl) {
        Session session = HttpSession.from((SecurityContext)ctx.getSecurityContext());
        String context = WebAcFilter.getBaseUrl(ctx, baseUrl);
        if (session.getAgent().getIRIString().startsWith(context)) {
            String path = session.getAgent().getIRIString().substring(context.length());
            if (path.startsWith(SLASH)) {
                return new HttpSession(rdf.createIRI("trellis:data/" + path.substring(1)));
            }
            return new HttpSession(rdf.createIRI("trellis:data/" + path));
        }
        return session;
    }

    static String buildChallenge(String challenge, String realm, String scope) {
        Object realmParam = realm.isEmpty() ? "" : " realm=\"" + realm + "\"";
        Object scopeParam = scope.isEmpty() ? "" : " scope=\"" + scope + "\"";
        return challenge + (String)realmParam + (String)scopeParam;
    }

    static String effectiveAclToUrlPath(String effectiveAclPath, String resourceAclPath, ContainerResponseContext response) {
        boolean isContainer;
        String resourcePath;
        String effectivePath = WebAcFilter.normalizePath(effectiveAclPath);
        boolean inherited = !effectivePath.equals(resourcePath = WebAcFilter.normalizePath(resourceAclPath));
        boolean bl = isContainer = inherited || ((List)response.getStringHeaders().getOrDefault((Object)"Link", Collections.emptyList())).stream().map(Link::valueOf).anyMatch(link -> link.getUri().toString().endsWith("Container") && link.getRels().contains("type"));
        if (SLASH.equals(effectivePath) || !isContainer) {
            return effectivePath;
        }
        return effectivePath + SLASH;
    }

    static String normalizePath(String path) {
        if (path.startsWith("trellis:data/")) {
            return path.substring("trellis:data/".length() - 1);
        }
        if (path.startsWith(SLASH)) {
            return path;
        }
        return SLASH + path;
    }
}

