/*
 * Decompiled with CFR 0.152.
 */
package org.trellisldp.webac;

import java.io.InputStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.jena.commonsrdf.JenaCommonsRDF;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trellisldp.api.CacheService;
import org.trellisldp.api.Metadata;
import org.trellisldp.api.RDFFactory;
import org.trellisldp.api.Resource;
import org.trellisldp.api.ResourceService;
import org.trellisldp.api.Session;
import org.trellisldp.api.TrellisRuntimeException;
import org.trellisldp.api.TrellisUtils;
import org.trellisldp.vocabulary.ACL;
import org.trellisldp.vocabulary.FOAF;
import org.trellisldp.vocabulary.Trellis;
import org.trellisldp.vocabulary.VCARD;
import org.trellisldp.webac.Authorization;
import org.trellisldp.webac.AuthorizedModes;

@ApplicationScoped
public class WebAcService {
    public static final String CONFIG_WEBAC_MEMBERSHIP_CHECK = "trellis.webac.membership-check";
    public static final String CONFIG_WEBAC_DEFAULT_ACL_LOCATION = "trellis.webac.default-acl-location";
    public static final String CONFIG_WEBAC_INITIALIZE_ROOT_ACL = "trellis.webac.initialize-root-acl";
    public static final String DEFAULT_ACL_LOCATION = "org/trellisldp/webac/defaultAcl.ttl";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAcService.class);
    private static final CompletionStage<Void> DONE = CompletableFuture.completedFuture(null);
    private static final RDF rdf = RDFFactory.getInstance();
    private static final IRI root = rdf.createIRI("trellis:data/");
    private static final IRI rootAuth = rdf.createIRI("trellis:data/#auth");
    private static final Set<IRI> allModes = new HashSet<IRI>();
    private List<Authorization> defaultRootAuthorizations;
    @Inject
    @ConfigProperty(name="trellis.webac.membership-check", defaultValue="false")
    boolean checkMembershipResources;
    @Inject
    @ConfigProperty(name="trellis.webac.initialize-root-acl", defaultValue="true")
    boolean initializeRoot;
    @Inject
    @ConfigProperty(name="trellis.webac.default-acl-location", defaultValue="org/trellisldp/webac/defaultAcl.ttl")
    String defaultAuthResourceLocation;
    @Inject
    ResourceService resourceService;
    @Inject
    @TrellisAuthorizationCache
    CacheService<String, AuthorizedModes> cache;

    @PostConstruct
    public void initialize() {
        this.defaultRootAuthorizations = Collections.unmodifiableList(WebAcService.getDefaultRootAuthorizations(this.defaultAuthResourceLocation));
        if (this.initializeRoot) {
            try (Dataset dataset = WebAcService.generateDefaultRootAuthorizationsDataset(this.defaultAuthResourceLocation);){
                this.resourceService.get(root).thenCompose(res -> this.initialize((Resource)res, dataset)).exceptionally(err -> {
                    LOGGER.warn("Unable to auto-initialize Trellis: {}. See DEBUG log for more info", (Object)err.getMessage());
                    LOGGER.debug("Error auto-initializing Trellis", err);
                    return null;
                }).toCompletableFuture().join();
            }
            catch (Exception ex) {
                throw new TrellisRuntimeException("Error initializing Trellis ACL", (Throwable)ex);
            }
        }
    }

    private CompletionStage<Void> initialize(Resource res, Dataset dataset) {
        if (!res.hasMetadata(Trellis.PreferAccessControl)) {
            LOGGER.info("Initializing root ACL: {}", (Object)res.getIdentifier());
            try (Stream quads = res.stream(Trellis.PreferUserManaged);){
                quads.forEach(arg_0 -> ((Dataset)dataset).add(arg_0));
            }
            HashSet<IRI> metadata = new HashSet<IRI>(res.getMetadataGraphNames());
            metadata.add(Trellis.PreferAccessControl);
            return this.resourceService.replace(Metadata.builder((Resource)res).metadataGraphNames(metadata).build(), dataset);
        }
        LOGGER.info("Root ACL is present, not initializing: {}", (Object)res.getIdentifier());
        return DONE;
    }

    public Set<IRI> getAccessModes(IRI identifier, Session session) {
        return this.getAuthorizedModes(identifier, session).getAccessModes();
    }

    public AuthorizedModes getAuthorizedModes(IRI identifier, Session session) {
        Objects.requireNonNull(session, "A non-null session must be provided!");
        if (Trellis.AdministratorAgent.equals((Object)session.getAgent())) {
            return new AuthorizedModes(null, allModes);
        }
        LOGGER.debug("Looking up ACL for agent [{}] on resource [{}]", (Object)session.getAgent(), (Object)identifier);
        AuthorizedModes cachedModes = (AuthorizedModes)this.cache.get((Object)WebAcService.generateCacheKey(identifier, session.getAgent()), k -> this.getAuthz(identifier, session.getAgent()));
        return session.getDelegatedBy().map(delegate -> {
            HashSet<IRI> modes = new HashSet<IRI>(cachedModes.getAccessModes());
            AuthorizedModes delegatedModes = (AuthorizedModes)this.cache.get((Object)WebAcService.generateCacheKey(identifier, delegate), k -> this.getAuthz(identifier, (IRI)delegate));
            modes.retainAll(delegatedModes.getAccessModes());
            return new AuthorizedModes(cachedModes.getEffectiveAcl().orElse(null), modes);
        }).orElse(cachedModes);
    }

    public static String generateCacheKey(IRI identifier, IRI agent) {
        return String.join((CharSequence)"||", identifier.getIRIString(), agent.getIRIString());
    }

    private AuthorizedModes getAuthz(IRI identifier, IRI agent) {
        AuthorizedModes authModes = this.getModesFor(identifier, agent);
        if (authModes.getAccessModes().isEmpty()) {
            LOGGER.debug("Agent [{}] has no access to resource [{}]", (Object)agent, (Object)identifier);
        }
        HashSet<IRI> modes = new HashSet<IRI>(authModes.getAccessModes());
        if (this.checkMembershipResources && WebAcService.hasWritableMode(modes)) {
            TrellisUtils.getContainer((IRI)identifier).map(arg_0 -> ((ResourceService)this.resourceService).get(arg_0)).map(CompletionStage::toCompletableFuture).map(CompletableFuture::join).flatMap(Resource::getMembershipResource).map(TrellisUtils::normalizeIdentifier).map(member -> this.getModesFor((IRI)member, agent)).ifPresent(memberModes -> {
                if (!memberModes.getAccessModes().contains(ACL.Write)) {
                    modes.remove(ACL.Write);
                }
                if (!memberModes.getAccessModes().contains(ACL.Append)) {
                    modes.remove(ACL.Append);
                }
            });
            return new AuthorizedModes(authModes.getEffectiveAcl().orElse(null), modes);
        }
        return authModes;
    }

    private AuthorizedModes getModesFor(IRI identifier, IRI agent) {
        return this.getNearestResource(identifier).map(resource -> {
            Authorizations authorizations = this.getAllAuthorizationsFor((Resource)resource, !identifier.equals((Object)resource.getIdentifier()));
            return new AuthorizedModes(authorizations.getIdentifier(), authorizations.stream().filter(this.agentFilter(agent)).flatMap(auth -> auth.getMode().stream()).collect(Collectors.toSet()));
        }).orElseGet(() -> new AuthorizedModes(root, Collections.emptySet()));
    }

    private Optional<Resource> getNearestResource(IRI identifier) {
        Resource res = (Resource)this.resourceService.get(identifier).toCompletableFuture().join();
        if (WebAcService.resourceExists(res)) {
            return Optional.of(res);
        }
        return TrellisUtils.getContainer((IRI)identifier).flatMap(this::getNearestResource);
    }

    private Predicate<Authorization> agentFilter(IRI agent) {
        return auth -> auth.getAgentClass().contains(FOAF.Agent) || auth.getAgentClass().contains(ACL.AuthenticatedAgent) && !Trellis.AnonymousAgent.equals((Object)agent) || auth.getAgent().contains(agent) || auth.getAgentGroup().stream().anyMatch(this.isAgentInGroup(agent));
    }

    private Predicate<IRI> isAgentInGroup(IRI agent) {
        return group -> this.resourceService.get(TrellisUtils.normalizeIdentifier((IRI)group)).thenApply(res -> {
            try (Stream<RDFTerm> triples = res.stream(Trellis.PreferUserManaged).filter(t -> t.getSubject().equals(group) && t.getPredicate().equals((Object)VCARD.hasMember)).map(Quad::getObject);){
                Boolean bl = triples.anyMatch(arg_0 -> ((IRI)agent).equals(arg_0));
                return bl;
            }
        }).toCompletableFuture().join();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Authorizations getAllAuthorizationsFor(Resource resource, boolean inherited) {
        LOGGER.debug("Checking ACL for: {}", (Object)resource.getIdentifier());
        if (resource.hasMetadata(Trellis.PreferAccessControl)) {
            try (Graph graph = (Graph)resource.stream(Trellis.PreferAccessControl).map(Quad::asTriple).collect(TrellisUtils.toGraph());){
                List<Authorization> authorizations2 = WebAcService.getAuthorizationFromGraph(resource.getIdentifier(), graph);
                if (inherited) {
                    Authorizations authorizations3 = new Authorizations(resource.getIdentifier(), authorizations2.stream().filter(WebAcService.getInheritedAuth(resource.getIdentifier())));
                    return authorizations3;
                }
                Authorizations authorizations = new Authorizations(resource.getIdentifier(), authorizations2.stream().filter(auth -> auth.getAccessTo().contains(resource.getIdentifier())));
                return authorizations;
            }
            catch (Exception ex) {
                throw new TrellisRuntimeException("Error closing graph", (Throwable)ex);
            }
        }
        if (root.equals((Object)resource.getIdentifier())) {
            return new Authorizations(root, this.defaultRootAuthorizations.stream());
        }
        LOGGER.debug("No ACL for {}; looking up parent resource", (Object)resource.getIdentifier());
        return TrellisUtils.getContainer((IRI)resource.getIdentifier()).flatMap(this::getNearestResource).map(res -> this.getAllAuthorizationsFor((Resource)res, true)).orElseGet(() -> new Authorizations(root));
    }

    static List<Authorization> getAuthorizationFromGraph(IRI identifier, Graph graph) {
        return graph.stream().map(Triple::getSubject).distinct().map(subject -> {
            Authorization authorization;
            block8: {
                Graph subGraph = (Graph)graph.stream(subject, null, null).collect(TrellisUtils.toGraph());
                try {
                    authorization = Authorization.from(subject, subGraph);
                    if (subGraph == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (subGraph != null) {
                            try {
                                subGraph.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw new TrellisRuntimeException("Error closing graph", (Throwable)ex);
                    }
                }
                subGraph.close();
            }
            return authorization;
        }).filter(auth -> auth.getAccessTo().contains(identifier) || auth.getDefault().contains(identifier)).collect(Collectors.toList());
    }

    static boolean hasWritableMode(Set<IRI> modes) {
        return modes.contains(ACL.Write) || modes.contains(ACL.Append);
    }

    static boolean resourceExists(Resource res) {
        return !Resource.SpecialResources.MISSING_RESOURCE.equals((Object)res) && !Resource.SpecialResources.DELETED_RESOURCE.equals((Object)res);
    }

    static Predicate<Authorization> getInheritedAuth(IRI identifier) {
        return auth -> root.equals((Object)identifier) || auth.getDefault().contains(identifier);
    }

    static List<Authorization> getDefaultRootAuthorizations(String resource) {
        return WebAcService.generateDefaultRootAuthorizationsDataset(resource).getGraph((BlankNodeOrIRI)Trellis.PreferAccessControl).map(graph -> Authorization.from((BlankNodeOrIRI)rootAuth, graph)).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Dataset generateDefaultRootAuthorizationsDataset(String resource) {
        Dataset dataset = rdf.createDataset();
        try (Model model = ModelFactory.createDefaultModel();
             InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);){
            if (is != null) {
                LOGGER.debug("Using classpath resource for default root ACL: {}", (Object)resource);
                RDFParser.source((InputStream)is).lang(Lang.TURTLE).base("trellis:data/").parse(model);
            } else {
                LOGGER.debug("Using external resource for default root ACL: {}", (Object)resource);
                RDFParser.source((String)resource).lang(Lang.TURTLE).base("trellis:data/").parse(model);
            }
            JenaCommonsRDF.fromJena((org.apache.jena.graph.Graph)model.getGraph()).stream().map(triple -> rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAccessControl, triple.getSubject(), triple.getPredicate(), triple.getObject())).forEach(arg_0 -> ((Dataset)dataset).add(arg_0));
        }
        if (dataset.size() == 0L) {
            dataset.add(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAccessControl, (BlankNodeOrIRI)rootAuth, ACL.mode, (RDFTerm)ACL.Read));
            dataset.add(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAccessControl, (BlankNodeOrIRI)rootAuth, ACL.mode, (RDFTerm)ACL.Write));
            dataset.add(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAccessControl, (BlankNodeOrIRI)rootAuth, ACL.mode, (RDFTerm)ACL.Control));
            dataset.add(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAccessControl, (BlankNodeOrIRI)rootAuth, ACL.mode, (RDFTerm)ACL.Append));
            dataset.add(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAccessControl, (BlankNodeOrIRI)rootAuth, ACL.agentClass, (RDFTerm)FOAF.Agent));
            dataset.add(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAccessControl, (BlankNodeOrIRI)rootAuth, ACL.default_, (RDFTerm)root));
            dataset.add(rdf.createQuad((BlankNodeOrIRI)Trellis.PreferAccessControl, (BlankNodeOrIRI)rootAuth, ACL.accessTo, (RDFTerm)root));
        }
        return dataset;
    }

    static {
        allModes.add(ACL.Read);
        allModes.add(ACL.Write);
        allModes.add(ACL.Control);
        allModes.add(ACL.Append);
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    @Qualifier
    public static @interface TrellisAuthorizationCache {
    }

    @TrellisAuthorizationCache
    public static class NoopAuthorizationCache
    implements CacheService<String, AuthorizedModes> {
        public AuthorizedModes get(String key, Function<String, AuthorizedModes> f) {
            return f.apply(key);
        }
    }

    static class Authorizations {
        private final IRI resource;
        private final Stream<Authorization> stream;

        public Authorizations(IRI resource) {
            this(resource, Stream.empty());
        }

        public Authorizations(IRI resource, Stream<Authorization> stream) {
            this.resource = resource;
            this.stream = stream;
        }

        public IRI getIdentifier() {
            return this.resource;
        }

        public Stream<Authorization> stream() {
            return this.stream;
        }
    }
}

